/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue.inMemoryQueue;

import androidx.annotation.NonNull;
import com.birbit.android.jobqueue.Constraint;
import com.birbit.android.jobqueue.JobHolder;
import com.birbit.android.jobqueue.JobQueue;
import com.birbit.android.jobqueue.config.Configuration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;

public class SimpleInMemoryPriorityQueue
implements JobQueue {
    private final TreeSet<JobHolder> jobs = new TreeSet<JobHolder>(new Comparator<JobHolder>(){

        @Override
        public int compare(JobHolder holder1, JobHolder holder2) {
            if (holder1.getJob().getId().equals(holder2.getJob().getId())) {
                return 0;
            }
            int cmp = this.compareInt(holder1.getPriority(), holder2.getPriority());
            if (cmp != 0) {
                return cmp;
            }
            cmp = -this.compareLong(holder1.getCreatedNs(), holder2.getCreatedNs());
            if (cmp != 0) {
                return cmp;
            }
            return -this.compareLong(holder1.getInsertionOrder(), holder2.getInsertionOrder());
        }

        private int compareInt(int i1, int i2) {
            if (i1 > i2) {
                return -1;
            }
            if (i2 > i1) {
                return 1;
            }
            return 0;
        }

        private int compareLong(long l1, long l2) {
            if (l1 > l2) {
                return -1;
            }
            if (l2 > l1) {
                return 1;
            }
            return 0;
        }
    });
    private final Map<String, JobHolder> idCache = new HashMap<String, JobHolder>();
    private final AtomicLong insertionOrderCounter = new AtomicLong(0L);
    private final List<String> reusedList = new ArrayList<String>();
    private final long sessionId;

    public SimpleInMemoryPriorityQueue(Configuration configuration, long sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public boolean insert(@NonNull JobHolder jobHolder) {
        jobHolder.setInsertionOrder(this.insertionOrderCounter.incrementAndGet());
        JobHolder existing = this.idCache.get(jobHolder.getId());
        if (existing != null) {
            throw new IllegalArgumentException("cannot add a job with the same id twice");
        }
        this.idCache.put(jobHolder.getId(), jobHolder);
        this.jobs.add(jobHolder);
        return true;
    }

    @Override
    public boolean insertOrReplace(@NonNull JobHolder jobHolder) {
        if (jobHolder.getInsertionOrder() == null) {
            return this.insert(jobHolder);
        }
        JobHolder existing = this.idCache.get(jobHolder.getId());
        if (existing != null) {
            this.remove(existing);
        }
        this.idCache.put(jobHolder.getId(), jobHolder);
        this.jobs.add(jobHolder);
        return true;
    }

    @Override
    public void substitute(@NonNull JobHolder newJob, @NonNull JobHolder oldJob) {
        this.remove(oldJob);
        this.insert(newJob);
    }

    @Override
    public void remove(@NonNull JobHolder jobHolder) {
        this.idCache.remove(jobHolder.getId());
        this.jobs.remove(jobHolder);
    }

    @Override
    public int count() {
        return this.jobs.size();
    }

    @Override
    public int countReadyJobs(@NonNull Constraint constraint) {
        int count = 0;
        this.reusedList.clear();
        for (JobHolder holder : this.jobs) {
            String groupId = holder.getGroupId();
            if (groupId != null && this.reusedList.contains(groupId) || !SimpleInMemoryPriorityQueue.matches(holder, constraint, false)) continue;
            ++count;
            if (groupId == null) continue;
            this.reusedList.add(groupId);
        }
        this.reusedList.clear();
        return count;
    }

    @Override
    public JobHolder nextJobAndIncRunCount(@NonNull Constraint constraint) {
        for (JobHolder holder : this.jobs) {
            if (!SimpleInMemoryPriorityQueue.matches(holder, constraint, false)) continue;
            this.remove(holder);
            holder.setRunCount(holder.getRunCount() + 1);
            holder.setRunningSessionId(this.sessionId);
            return holder;
        }
        return null;
    }

    @Override
    public Long getNextJobDelayUntilNs(@NonNull Constraint constraint) {
        Long minDelay = null;
        for (JobHolder holder : this.jobs) {
            if (!SimpleInMemoryPriorityQueue.matches(holder, constraint, true)) continue;
            boolean hasDelay = holder.hasDelay() && SimpleInMemoryPriorityQueue.matches(holder, constraint, false);
            boolean hasDeadline = holder.hasDeadline();
            long delay = hasDeadline == hasDelay ? Math.min(holder.getDeadlineNs(), holder.getDelayUntilNs()) : (hasDeadline ? holder.getDeadlineNs() : holder.getDelayUntilNs());
            if (minDelay != null && delay >= minDelay) continue;
            minDelay = delay;
        }
        return minDelay;
    }

    @Override
    public void clear() {
        this.jobs.clear();
        this.idCache.clear();
    }

    @Override
    public JobHolder findJobById(@NonNull String id) {
        return this.idCache.get(id);
    }

    @Override
    @NonNull
    public Set<JobHolder> findJobs(@NonNull Constraint constraint) {
        HashSet<JobHolder> result = new HashSet<JobHolder>();
        for (JobHolder holder : this.jobs) {
            if (!SimpleInMemoryPriorityQueue.matches(holder, constraint, false)) continue;
            result.add(holder);
        }
        return result;
    }

    @Override
    public void onJobCancelled(JobHolder holder) {
        this.remove(holder);
    }

    private static boolean matches(JobHolder holder, Constraint constraint, boolean acceptAnyDeadline) {
        boolean hitDeadline;
        boolean bl = hitDeadline = constraint.getNowInNs() >= holder.getDeadlineNs() || acceptAnyDeadline && holder.hasDeadline();
        if (!hitDeadline && constraint.getMaxNetworkType() < holder.getRequiredNetworkType()) {
            return false;
        }
        if (constraint.getTimeLimit() != null && holder.getDelayUntilNs() > constraint.getTimeLimit()) {
            return false;
        }
        if (holder.getGroupId() != null && constraint.getExcludeGroups().contains(holder.getGroupId())) {
            return false;
        }
        if (constraint.getExcludeJobIds().contains(holder.getId())) {
            return false;
        }
        return constraint.getTagConstraint() == null || holder.getTags() != null && !constraint.getTags().isEmpty() && constraint.getTagConstraint().matches(constraint.getTags(), holder.getTags());
    }
}

