/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue.config;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.birbit.android.jobqueue.DefaultQueueFactory;
import com.birbit.android.jobqueue.QueueFactory;
import com.birbit.android.jobqueue.di.DependencyInjector;
import com.birbit.android.jobqueue.log.CustomLogger;
import com.birbit.android.jobqueue.log.JqLog;
import com.birbit.android.jobqueue.network.NetworkUtil;
import com.birbit.android.jobqueue.network.NetworkUtilImpl;
import com.birbit.android.jobqueue.persistentQueue.sqlite.SqliteJobQueue;
import com.birbit.android.jobqueue.scheduling.Scheduler;
import com.birbit.android.jobqueue.timer.SystemTimer;
import com.birbit.android.jobqueue.timer.Timer;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Pattern;

public class Configuration {
    public static final String DEFAULT_ID = "default_job_manager";
    public static final int DEFAULT_THREAD_KEEP_ALIVE_SECONDS = 15;
    public static final int DEFAULT_LOAD_FACTOR_PER_CONSUMER = 3;
    public static final int MAX_CONSUMER_COUNT = 5;
    public static final int MIN_CONSUMER_COUNT = 0;
    public static final int DEFAULT_THREAD_PRIORITY = 5;
    String id = "default_job_manager";
    int maxConsumerCount = 5;
    int minConsumerCount = 0;
    int consumerKeepAlive = 15;
    int loadFactor = 3;
    Context appContext;
    QueueFactory queueFactory;
    DependencyInjector dependencyInjector;
    NetworkUtil networkUtil;
    CustomLogger customLogger = new JqLog.ErrorLogger();
    Timer timer;
    Scheduler scheduler;
    boolean inTestMode = false;
    boolean resetDelaysOnRestart = false;
    int threadPriority = 5;
    boolean batchSchedulerRequests = true;
    ThreadFactory threadFactory = null;

    private Configuration() {
    }

    @NonNull
    public Context getAppContext() {
        return this.appContext;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    public boolean batchSchedulerRequests() {
        return this.batchSchedulerRequests;
    }

    @NonNull
    public QueueFactory getQueueFactory() {
        return this.queueFactory;
    }

    @Nullable
    public DependencyInjector getDependencyInjector() {
        return this.dependencyInjector;
    }

    public int getConsumerKeepAlive() {
        return this.consumerKeepAlive;
    }

    @NonNull
    public NetworkUtil getNetworkUtil() {
        return this.networkUtil;
    }

    public int getMaxConsumerCount() {
        return this.maxConsumerCount;
    }

    public int getMinConsumerCount() {
        return this.minConsumerCount;
    }

    @Nullable
    public CustomLogger getCustomLogger() {
        return this.customLogger;
    }

    public int getLoadFactor() {
        return this.loadFactor;
    }

    public boolean isInTestMode() {
        return this.inTestMode;
    }

    @NonNull
    public Timer getTimer() {
        return this.timer;
    }

    public boolean resetDelaysOnRestart() {
        return this.resetDelaysOnRestart;
    }

    @Nullable
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    @Nullable
    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public static final class Builder {
        private Pattern idRegex = Pattern.compile("^([A-Za-z]|[0-9]|_|-)+$");
        private Configuration configuration = new Configuration();

        public Builder(@NonNull Context context) {
            this.configuration.appContext = context.getApplicationContext();
        }

        @NonNull
        public Builder id(@NonNull String id) {
            if (id == null || !this.idRegex.matcher(id).matches()) {
                throw new IllegalArgumentException("id cannot be null or empty and can only include alphanumeric characters, - or _ .");
            }
            this.configuration.id = id;
            return this;
        }

        @NonNull
        public Builder consumerKeepAlive(int keepAlive) {
            this.configuration.consumerKeepAlive = keepAlive;
            return this;
        }

        @NonNull
        public Builder resetDelaysOnRestart() {
            this.configuration.resetDelaysOnRestart = true;
            return this;
        }

        @NonNull
        public Builder queueFactory(@Nullable QueueFactory queueFactory) {
            if (this.configuration.queueFactory != null && queueFactory != null) {
                throw new RuntimeException("already set a queue factory. This might happen ifyou've provided a custom job serializer");
            }
            this.configuration.queueFactory = queueFactory;
            return this;
        }

        @NonNull
        public Builder jobSerializer(@NonNull SqliteJobQueue.JobSerializer jobSerializer) {
            this.configuration.queueFactory = new DefaultQueueFactory(jobSerializer);
            return this;
        }

        @NonNull
        public Builder networkUtil(@Nullable NetworkUtil networkUtil) {
            this.configuration.networkUtil = networkUtil;
            return this;
        }

        @NonNull
        public Builder injector(@Nullable DependencyInjector injector) {
            this.configuration.dependencyInjector = injector;
            return this;
        }

        @NonNull
        public Builder maxConsumerCount(int count) {
            this.configuration.maxConsumerCount = count;
            return this;
        }

        @NonNull
        public Builder minConsumerCount(int count) {
            this.configuration.minConsumerCount = count;
            return this;
        }

        @NonNull
        public Builder timer(@Nullable Timer timer) {
            this.configuration.timer = timer;
            return this;
        }

        @NonNull
        public Builder customLogger(@Nullable CustomLogger logger) {
            this.configuration.customLogger = logger;
            return this;
        }

        @NonNull
        public Builder loadFactor(int loadFactor) {
            this.configuration.loadFactor = loadFactor;
            return this;
        }

        @NonNull
        public Builder inTestMode() {
            this.configuration.inTestMode = true;
            return this;
        }

        @NonNull
        public Builder scheduler(@Nullable Scheduler scheduler, boolean batch) {
            this.configuration.scheduler = scheduler;
            this.configuration.batchSchedulerRequests = batch;
            return this;
        }

        @NonNull
        public Builder consumerThreadPriority(int threadPriority) {
            this.configuration.threadPriority = threadPriority;
            return this;
        }

        @NonNull
        public Builder scheduler(@Nullable Scheduler scheduler) {
            return this.scheduler(scheduler, true);
        }

        @NonNull
        public Builder threadFactory(@Nullable ThreadFactory threadFactory) {
            this.configuration.threadFactory = threadFactory;
            return this;
        }

        @NonNull
        public Configuration build() {
            if (this.configuration.queueFactory == null) {
                this.configuration.queueFactory = new DefaultQueueFactory();
            }
            if (this.configuration.networkUtil == null) {
                this.configuration.networkUtil = new NetworkUtilImpl(this.configuration.appContext);
            }
            if (this.configuration.timer == null) {
                this.configuration.timer = new SystemTimer();
            }
            return this.configuration;
        }
    }
}

