/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.birbit.android.jobqueue.JobHolder;
import com.birbit.android.jobqueue.Params;
import com.birbit.android.jobqueue.RetryConstraint;
import com.birbit.android.jobqueue.log.JqLog;
import com.birbit.android.jobqueue.timer.Timer;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public abstract class Job
implements Serializable {
    private static final long serialVersionUID = 3L;
    public static final int DEFAULT_RETRY_LIMIT = 20;
    static final String SINGLE_ID_TAG_PREFIX = "job-single-id:";
    private transient String id = UUID.randomUUID().toString();
    transient int requiredNetworkType;
    private transient String groupId;
    private transient boolean persistent;
    private transient Set<String> readonlyTags;
    private transient int currentRunCount;
    transient int priority;
    private transient long delayInMs;
    private transient long deadlineInMs;
    private transient boolean cancelOnDeadline;
    volatile transient boolean cancelled;
    private transient Context applicationContext;
    private volatile transient boolean sealed;
    private volatile transient boolean isDeadlineReached;

    protected Job(Params params) {
        this.requiredNetworkType = params.requiredNetworkType;
        this.persistent = params.isPersistent();
        this.groupId = params.getGroupId();
        this.priority = params.getPriority();
        this.delayInMs = Math.max(0L, params.getDelayMs());
        this.deadlineInMs = Math.max(0L, params.getDeadlineMs());
        this.cancelOnDeadline = params.shouldCancelOnDeadline();
        String singleId = params.getSingleId();
        if (params.getTags() != null || singleId != null) {
            HashSet<String> tags;
            HashSet<String> hashSet = tags = params.getTags() != null ? params.getTags() : new HashSet<String>();
            if (singleId != null) {
                String tagForSingleId = this.createTagForSingleId(singleId);
                tags.add(tagForSingleId);
                if (this.groupId == null) {
                    this.groupId = tagForSingleId;
                }
            }
            this.readonlyTags = Collections.unmodifiableSet(tags);
        }
        if (this.deadlineInMs > 0L && this.deadlineInMs < this.delayInMs) {
            throw new IllegalArgumentException("deadline cannot be less than the delay. It does not make sense. deadline:" + this.deadlineInMs + ",delay:" + this.delayInMs);
        }
    }

    public final String getId() {
        return this.id;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final long getDelayInMs() {
        return this.delayInMs;
    }

    @Nullable
    public final Set<String> getTags() {
        return this.readonlyTags;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (!this.sealed) {
            throw new IllegalStateException("A job cannot be serialized w/o first being added into a job manager.");
        }
    }

    final void updateFromJobHolder(JobHolder holder) {
        if (this.sealed) {
            throw new IllegalStateException("Cannot set a Job from JobHolder after it is sealed.");
        }
        this.id = holder.id;
        this.groupId = holder.groupId;
        this.priority = holder.getPriority();
        this.persistent = holder.persistent;
        this.readonlyTags = holder.tags;
        this.requiredNetworkType = holder.requiredNetworkType;
        this.sealed = true;
    }

    public final boolean isPersistent() {
        return this.persistent;
    }

    public abstract void onAdded();

    public abstract void onRun() throws Throwable;

    protected abstract void onCancel(int var1, @Nullable Throwable var2);

    protected abstract RetryConstraint shouldReRunOnThrowable(@NonNull Throwable var1, int var2, int var3);

    final int safeRun(JobHolder holder, int currentRunCount, Timer timer) {
        boolean cancelForDeadline;
        Throwable throwable;
        boolean failed;
        boolean reRun;
        block13: {
            this.currentRunCount = currentRunCount;
            if (JqLog.isDebugEnabled()) {
                JqLog.d("running job %s", this.getClass().getSimpleName());
            }
            reRun = false;
            failed = false;
            throwable = null;
            cancelForDeadline = false;
            try {
                this.onRun();
                if (JqLog.isDebugEnabled()) {
                    JqLog.d("finished job %s", this);
                }
            }
            catch (Throwable t) {
                failed = true;
                throwable = t;
                JqLog.e(t, "error while executing job %s", this);
                cancelForDeadline = holder.shouldCancelOnDeadline() && holder.getDeadlineNs() <= timer.nanoTime();
                boolean bl = reRun = currentRunCount < this.getRetryLimit() && !cancelForDeadline;
                if (!reRun || this.cancelled) break block13;
                try {
                    RetryConstraint retryConstraint = this.shouldReRunOnThrowable(t, currentRunCount, this.getRetryLimit());
                    if (retryConstraint == null) {
                        retryConstraint = RetryConstraint.RETRY;
                    }
                    holder.retryConstraint = retryConstraint;
                    reRun = retryConstraint.shouldRetry();
                }
                catch (Throwable t2) {
                    JqLog.e(t2, "shouldReRunOnThrowable did throw an exception", new Object[0]);
                }
            }
        }
        JqLog.d("safeRunResult for %s : %s. re run:%s. cancelled: %s", this, !failed, reRun, this.cancelled);
        if (!failed) {
            return 1;
        }
        if (holder.isCancelledSingleId()) {
            return 6;
        }
        if (holder.isCancelled()) {
            return 3;
        }
        if (reRun) {
            return 4;
        }
        if (cancelForDeadline) {
            return 7;
        }
        if (currentRunCount < this.getRetryLimit()) {
            holder.setThrowable(throwable);
            return 5;
        }
        holder.setThrowable(throwable);
        return 2;
    }

    public final int getCurrentRunCount() {
        return this.currentRunCount;
    }

    public final String getRunGroupId() {
        return this.groupId;
    }

    public final String getSingleInstanceId() {
        if (this.readonlyTags != null) {
            for (String tag : this.readonlyTags) {
                if (!tag.startsWith(SINGLE_ID_TAG_PREFIX)) continue;
                return tag;
            }
        }
        return null;
    }

    private String createTagForSingleId(String singleId) {
        return SINGLE_ID_TAG_PREFIX + singleId;
    }

    protected int getRetryLimit() {
        return 20;
    }

    public final boolean isCancelled() {
        return this.cancelled;
    }

    public void assertNotCancelled() {
        if (this.cancelled) {
            throw new RuntimeException("job is cancelled");
        }
    }

    void setApplicationContext(Context context) {
        this.applicationContext = context;
    }

    void setDeadlineReached(boolean deadlineReached) {
        this.isDeadlineReached = deadlineReached;
    }

    public Context getApplicationContext() {
        return this.applicationContext;
    }

    public boolean isDeadlineReached() {
        return this.isDeadlineReached;
    }

    public final boolean requiresNetwork() {
        return this.requiredNetworkType >= 1;
    }

    public final boolean requiresUnmeteredNetwork() {
        return this.requiredNetworkType >= 2;
    }

    long getDeadlineInMs() {
        return this.deadlineInMs;
    }

    boolean shouldCancelOnDeadline() {
        return this.cancelOnDeadline;
    }
}

