/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue.scheduling;

import android.content.Context;
import com.birbit.android.jobqueue.scheduling.SchedulerConstraint;

public abstract class Scheduler {
    private Callback callback;
    private Context context;

    protected Scheduler() {
    }

    public void init(Context context, Callback callback) {
        this.context = context.getApplicationContext();
        this.callback = callback;
    }

    Context getApplicationContext() {
        return this.context;
    }

    public abstract void request(SchedulerConstraint var1);

    public final boolean start(SchedulerConstraint constraint) {
        if (this.callback == null) {
            throw new IllegalStateException("JobManager callback is not configured");
        }
        return this.callback.start(constraint);
    }

    public final boolean stop(SchedulerConstraint constraint) {
        if (this.callback == null) {
            throw new IllegalStateException("JobManager callback is not configured");
        }
        return this.callback.stop(constraint);
    }

    public abstract void onFinished(SchedulerConstraint var1, boolean var2);

    public abstract void cancelAll();

    public static interface Callback {
        public boolean start(SchedulerConstraint var1);

        public boolean stop(SchedulerConstraint var1);
    }
}

