/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue.scheduling;

import android.content.Context;
import android.os.Bundle;
import com.birbit.android.jobqueue.log.JqLog;
import com.birbit.android.jobqueue.scheduling.GcmJobSchedulerService;
import com.birbit.android.jobqueue.scheduling.Scheduler;
import com.birbit.android.jobqueue.scheduling.SchedulerConstraint;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.OneoffTask;
import com.google.android.gms.gcm.Task;
import com.google.android.gms.gcm.TaskParams;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class GcmScheduler
extends Scheduler {
    private static final String KEY_UUID = "uuid";
    private static final String KEY_DELAY = "delay";
    private static final String KEY_OVERRIDE_DEADLINE = "deadline";
    private static final String KEY_NETWORK_STATUS = "networkStatus";
    GcmNetworkManager gcmNetworkManager;
    final Class<? extends GcmJobSchedulerService> serviceClass;

    GcmScheduler(Context context, Class<? extends GcmJobSchedulerService> serviceClass) {
        this.serviceClass = serviceClass;
        this.gcmNetworkManager = GcmNetworkManager.getInstance((Context)context.getApplicationContext());
    }

    @Override
    public void request(SchedulerConstraint constraint) {
        if (JqLog.isDebugEnabled()) {
            JqLog.d("creating gcm wake up request for %s", constraint);
        }
        OneoffTask.Builder builder = new OneoffTask.Builder().setRequiredNetwork(GcmScheduler.toNetworkState(constraint.getNetworkStatus())).setPersisted(true).setService(this.serviceClass).setTag(constraint.getUuid()).setExtras(GcmScheduler.toBundle(constraint));
        long endTimeMs = constraint.getOverrideDeadlineInMs() == null ? constraint.getDelayInMs() + TimeUnit.SECONDS.toMillis(this.getExecutionWindowSizeInSeconds()) : constraint.getOverrideDeadlineInMs();
        long executionStart = TimeUnit.MILLISECONDS.toSeconds(constraint.getDelayInMs());
        long executionEnd = TimeUnit.MILLISECONDS.toSeconds(endTimeMs);
        if (executionEnd <= executionStart) {
            executionEnd = executionStart + 1L;
        }
        builder.setExecutionWindow(executionStart, executionEnd);
        this.gcmNetworkManager.schedule((Task)builder.build());
    }

    long getExecutionWindowSizeInSeconds() {
        return TimeUnit.DAYS.toSeconds(7L);
    }

    @Override
    public void cancelAll() {
        this.gcmNetworkManager.cancelAllTasks(this.serviceClass);
    }

    private static int toNetworkState(int networkStatus) {
        switch (networkStatus) {
            case 0: {
                return 2;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        JqLog.e("unknown network status %d. Defaulting to CONNECTED", networkStatus);
        return 0;
    }

    static Bundle toBundle(SchedulerConstraint constraint) {
        Bundle bundle = new Bundle();
        if (constraint.getUuid() != null) {
            bundle.putString(KEY_UUID, constraint.getUuid());
        }
        bundle.putInt(KEY_NETWORK_STATUS, constraint.getNetworkStatus());
        bundle.putLong(KEY_DELAY, constraint.getDelayInMs());
        if (constraint.getOverrideDeadlineInMs() != null) {
            bundle.putLong(KEY_OVERRIDE_DEADLINE, constraint.getOverrideDeadlineInMs().longValue());
        }
        return bundle;
    }

    static SchedulerConstraint fromBundle(Bundle bundle) throws Exception {
        SchedulerConstraint constraint = new SchedulerConstraint(bundle.getString(KEY_UUID));
        if (constraint.getUuid() == null) {
            constraint.setUuid(UUID.randomUUID().toString());
        }
        constraint.setNetworkStatus(bundle.getInt(KEY_NETWORK_STATUS, 0));
        constraint.setDelayInMs(bundle.getLong(KEY_DELAY, 0L));
        if (bundle.containsKey(KEY_OVERRIDE_DEADLINE)) {
            constraint.setOverrideDeadlineInMs(bundle.getLong(KEY_OVERRIDE_DEADLINE));
        }
        return constraint;
    }

    int onStartJob(TaskParams taskParams) {
        SchedulerConstraint constraint = null;
        try {
            constraint = GcmScheduler.fromBundle(taskParams.getExtras());
        }
        catch (Exception e) {
            JqLog.e(e, "bad bundle from GcmScheduler. Ignoring the call", new Object[0]);
            return 0;
        }
        if (JqLog.isDebugEnabled()) {
            JqLog.d("starting job %s", constraint);
        }
        ResultCallback callback = new ResultCallback();
        constraint.setData(callback);
        this.start(constraint);
        return callback.get() ? 1 : 0;
    }

    @Override
    public void onFinished(SchedulerConstraint constraint, boolean reschedule) {
        Object data = constraint.getData();
        if (JqLog.isDebugEnabled()) {
            JqLog.d("finished job %s", constraint);
        }
        if (data instanceof ResultCallback) {
            ResultCallback callback = (ResultCallback)data;
            callback.onDone(reschedule);
        }
    }

    private static class ResultCallback {
        volatile boolean reschedule = false;
        CountDownLatch latch = new CountDownLatch(1);

        ResultCallback() {
        }

        public boolean get() {
            try {
                this.latch.await(600L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                JqLog.e("job did not finish in 10 minutes :/", new Object[0]);
            }
            return this.reschedule;
        }

        void onDone(boolean reschedule) {
            this.reschedule = reschedule;
            this.latch.countDown();
        }
    }
}

