/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue.scheduling;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.birbit.android.jobqueue.JobManager;
import com.birbit.android.jobqueue.log.JqLog;
import com.birbit.android.jobqueue.scheduling.GcmScheduler;
import com.birbit.android.jobqueue.scheduling.Scheduler;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.TaskParams;

public abstract class GcmJobSchedulerService
extends GcmTaskService {
    public static GcmScheduler createSchedulerFor(Context appContext, Class<? extends GcmJobSchedulerService> klass) {
        if (GcmJobSchedulerService.class == klass) {
            throw new IllegalArgumentException("You must create a service that extends GcmJobSchedulerService");
        }
        return new GcmScheduler(appContext.getApplicationContext(), klass);
    }

    public int onRunTask(TaskParams taskParams) {
        GcmScheduler scheduler = this.getScheduler();
        if (scheduler != null) {
            return scheduler.onStartJob(taskParams);
        }
        JqLog.e("RunTask on GcmJobSchedulerService has been called but it does not have a scheduler. Make sure you've initialized JobManager before the service might be created.", new Object[0]);
        return 2;
    }

    @Nullable
    protected GcmScheduler getScheduler() {
        Scheduler scheduler = this.getJobManager().getScheduler();
        if (scheduler instanceof GcmScheduler) {
            return (GcmScheduler)scheduler;
        }
        JqLog.e("GcmJobSchedulerService has been created but the JobManager does not have a scheduler created by GcmJobSchedulerService.", new Object[0]);
        return null;
    }

    @NonNull
    protected abstract JobManager getJobManager();
}

