/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue.messaging;

import com.birbit.android.jobqueue.log.JqLog;
import com.birbit.android.jobqueue.messaging.Message;
import com.birbit.android.jobqueue.messaging.Type;
import java.util.Arrays;

public class MessageFactory {
    private static final int CACHE_LIMIT = 20;
    Message[] pools = new Message[Type.values().length];
    int[] counts = new int[this.pools.length];

    public MessageFactory() {
        Arrays.fill(this.counts, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Message> T obtain(Class<T> klass) {
        Type type;
        Type type2 = type = Type.mapping.get(klass);
        synchronized (type2) {
            Message message = this.pools[type.ordinal()];
            if (message != null) {
                this.pools[type.ordinal()] = message.next;
                int n = type.ordinal();
                this.counts[n] = this.counts[n] - 1;
                message.next = null;
                return (T)message;
            }
            try {
                return (T)((Message)klass.newInstance());
            }
            catch (InstantiationException e) {
                JqLog.e(e, "Cannot create an instance of " + klass + ". Make sure it has a empty" + " constructor.", new Object[0]);
            }
            catch (IllegalAccessException e) {
                JqLog.e(e, "Cannot create an instance of " + klass + ". Make sure it has a public" + " empty constructor.", new Object[0]);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Message message) {
        Type type = message.type;
        message.recycle();
        Type type2 = type;
        synchronized (type2) {
            if (this.counts[type.ordinal()] < 20) {
                message.next = this.pools[type.ordinal()];
                this.pools[type.ordinal()] = message;
                int n = type.ordinal();
                this.counts[n] = this.counts[n] + 1;
            }
        }
    }
}

