/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue.cachedQueue;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.birbit.android.jobqueue.Constraint;
import com.birbit.android.jobqueue.JobHolder;
import com.birbit.android.jobqueue.JobQueue;
import java.util.Set;

public class CachedJobQueue
implements JobQueue {
    private JobQueue delegate;
    private Integer cachedCount;

    public CachedJobQueue(JobQueue delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean insert(@NonNull JobHolder jobHolder) {
        this.invalidateCache();
        return this.delegate.insert(jobHolder);
    }

    private void invalidateCache() {
        this.cachedCount = null;
    }

    @Override
    public boolean insertOrReplace(@NonNull JobHolder jobHolder) {
        this.invalidateCache();
        return this.delegate.insertOrReplace(jobHolder);
    }

    @Override
    public void substitute(@NonNull JobHolder newJob, @NonNull JobHolder oldJob) {
        this.invalidateCache();
        this.delegate.substitute(newJob, oldJob);
    }

    @Override
    public void remove(@NonNull JobHolder jobHolder) {
        this.invalidateCache();
        this.delegate.remove(jobHolder);
    }

    @Override
    public int count() {
        if (this.cachedCount == null) {
            this.cachedCount = this.delegate.count();
        }
        return this.cachedCount;
    }

    private boolean isEmpty() {
        return this.cachedCount != null && this.cachedCount == 0;
    }

    @Override
    public int countReadyJobs(@NonNull Constraint constraint) {
        if (this.isEmpty()) {
            return 0;
        }
        return this.delegate.countReadyJobs(constraint);
    }

    @Override
    public JobHolder nextJobAndIncRunCount(@NonNull Constraint constraint) {
        if (this.isEmpty()) {
            return null;
        }
        JobHolder holder = this.delegate.nextJobAndIncRunCount(constraint);
        if (holder != null && this.cachedCount != null) {
            this.cachedCount = this.cachedCount - 1;
        }
        return holder;
    }

    @Override
    public Long getNextJobDelayUntilNs(@NonNull Constraint constraint) {
        return this.delegate.getNextJobDelayUntilNs(constraint);
    }

    @Override
    public void clear() {
        this.invalidateCache();
        this.delegate.clear();
    }

    @Override
    @NonNull
    public Set<JobHolder> findJobs(@NonNull Constraint constraint) {
        return this.delegate.findJobs(constraint);
    }

    @Override
    public void onJobCancelled(@NonNull JobHolder holder) {
        this.invalidateCache();
        this.delegate.onJobCancelled(holder);
    }

    @Override
    @Nullable
    public JobHolder findJobById(@NonNull String id) {
        return this.delegate.findJobById(id);
    }
}

