/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue;

import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.birbit.android.jobqueue.AsyncAddCallback;
import com.birbit.android.jobqueue.CancelResult;
import com.birbit.android.jobqueue.IntCallback;
import com.birbit.android.jobqueue.Job;
import com.birbit.android.jobqueue.JobManagerThread;
import com.birbit.android.jobqueue.JobStatus;
import com.birbit.android.jobqueue.TagConstraint;
import com.birbit.android.jobqueue.WrongThreadException;
import com.birbit.android.jobqueue.callback.JobManagerCallback;
import com.birbit.android.jobqueue.callback.JobManagerCallbackAdapter;
import com.birbit.android.jobqueue.config.Configuration;
import com.birbit.android.jobqueue.log.JqLog;
import com.birbit.android.jobqueue.messaging.Message;
import com.birbit.android.jobqueue.messaging.MessageFactory;
import com.birbit.android.jobqueue.messaging.MessageQueue;
import com.birbit.android.jobqueue.messaging.PriorityMessageQueue;
import com.birbit.android.jobqueue.messaging.message.AddJobMessage;
import com.birbit.android.jobqueue.messaging.message.CancelMessage;
import com.birbit.android.jobqueue.messaging.message.CommandMessage;
import com.birbit.android.jobqueue.messaging.message.PublicQueryMessage;
import com.birbit.android.jobqueue.messaging.message.SchedulerMessage;
import com.birbit.android.jobqueue.scheduling.Scheduler;
import com.birbit.android.jobqueue.scheduling.SchedulerConstraint;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class JobManager {
    public static final long NS_PER_MS = 1000000L;
    public static final long NOT_RUNNING_SESSION_ID = Long.MIN_VALUE;
    public static final long NOT_DELAYED_JOB_DELAY = Long.MIN_VALUE;
    public static final long NETWORK_CHECK_INTERVAL = TimeUnit.MILLISECONDS.toNanos(10000L);
    public static final long MIN_DELAY_TO_USE_SCHEDULER_IN_MS = 30000L;
    final JobManagerThread jobManagerThread;
    private final PriorityMessageQueue messageQueue;
    private final MessageFactory messageFactory = new MessageFactory();
    private Thread chefThread;
    @Nullable
    private Scheduler scheduler;

    public JobManager(Configuration configuration) {
        this.messageQueue = new PriorityMessageQueue(configuration.getTimer(), this.messageFactory);
        this.jobManagerThread = new JobManagerThread(configuration, this.messageQueue, this.messageFactory);
        this.chefThread = new Thread((Runnable)this.jobManagerThread, "job-manager");
        if (configuration.getScheduler() != null) {
            this.scheduler = configuration.getScheduler();
            Scheduler.Callback callback = this.createSchedulerCallback();
            configuration.getScheduler().init(configuration.getAppContext(), callback);
        }
        this.chefThread.start();
    }

    public Thread getJobManagerExecutionThread() {
        return this.chefThread;
    }

    @Nullable
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    private Scheduler.Callback createSchedulerCallback() {
        return new Scheduler.Callback(){

            @Override
            public boolean start(SchedulerConstraint constraint) {
                JobManager.this.dispatchSchedulerStart(constraint);
                return true;
            }

            @Override
            public boolean stop(SchedulerConstraint constraint) {
                JobManager.this.dispatchSchedulerStop(constraint);
                return false;
            }
        };
    }

    private void dispatchSchedulerStart(SchedulerConstraint constraint) {
        SchedulerMessage message = this.messageFactory.obtain(SchedulerMessage.class);
        message.set(1, constraint);
        this.messageQueue.post(message);
    }

    private void dispatchSchedulerStop(SchedulerConstraint constraint) {
        SchedulerMessage message = this.messageFactory.obtain(SchedulerMessage.class);
        message.set(2, constraint);
        this.messageQueue.post(message);
    }

    public void start() {
        PublicQueryMessage message = this.messageFactory.obtain(PublicQueryMessage.class);
        message.set(2, null);
        this.messageQueue.post(message);
    }

    public void stop() {
        PublicQueryMessage message = this.messageFactory.obtain(PublicQueryMessage.class);
        message.set(3, null);
        this.messageQueue.post(message);
    }

    public int getActiveConsumerCount() {
        this.assertNotInMainThread();
        this.assertNotInJobManagerThread("Cannot call sync methods in JobManager's callback thread.");
        PublicQueryMessage message = this.messageFactory.obtain(PublicQueryMessage.class);
        message.set(6, null);
        return new IntQueryFuture<PublicQueryMessage>(this.messageQueue, message).getSafe();
    }

    public void destroy() {
        JqLog.d("destroying job queue", new Object[0]);
        this.stopAndWaitUntilConsumersAreFinished();
        CommandMessage message = this.messageFactory.obtain(CommandMessage.class);
        message.set(1);
        this.messageQueue.post(message);
        this.jobManagerThread.callbackManager.destroy();
    }

    public void stopAndWaitUntilConsumersAreFinished() {
        this.waitUntilConsumersAreFinished(true);
    }

    public void waitUntilConsumersAreFinished() {
        this.waitUntilConsumersAreFinished(false);
    }

    private void waitUntilConsumersAreFinished(boolean stop) {
        this.assertNotInMainThread();
        final CountDownLatch latch = new CountDownLatch(1);
        this.jobManagerThread.consumerManager.addNoConsumersListener(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
                JobManager.this.jobManagerThread.consumerManager.removeNoConsumersListener(this);
            }
        });
        if (stop) {
            this.stop();
        }
        if (this.jobManagerThread.consumerManager.getWorkerCount() == 0) {
            return;
        }
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        PublicQueryMessage pm = this.messageFactory.obtain(PublicQueryMessage.class);
        pm.set(5, null);
        new IntQueryFuture<PublicQueryMessage>(this.jobManagerThread.callbackManager.messageQueue, pm).getSafe();
    }

    public void addJobInBackground(Job job) {
        AddJobMessage message = this.messageFactory.obtain(AddJobMessage.class);
        message.setJob(job);
        this.messageQueue.post(message);
    }

    public void cancelJobsInBackground(CancelResult.AsyncCancelCallback cancelCallback, TagConstraint constraint, String ... tags) {
        if (constraint == null) {
            throw new IllegalArgumentException("must provide a TagConstraint");
        }
        CancelMessage message = this.messageFactory.obtain(CancelMessage.class);
        message.setCallback(cancelCallback);
        message.setConstraint(constraint);
        message.setTags(tags);
        this.messageQueue.post(message);
    }

    public void addCallback(JobManagerCallback callback) {
        this.jobManagerThread.addCallback(callback);
    }

    public boolean removeCallback(JobManagerCallback callback) {
        return this.jobManagerThread.removeCallback(callback);
    }

    public void addJob(Job job) {
        this.assertNotInMainThread("Cannot call this method on main thread. Use addJobInBackground instead.");
        this.assertNotInJobManagerThread("Cannot call sync methods in JobManager's callback thread.Use addJobInBackground instead");
        final CountDownLatch latch = new CountDownLatch(1);
        final String uuid = job.getId();
        this.addCallback(new JobManagerCallbackAdapter(){

            @Override
            public void onJobAdded(@NonNull Job job) {
                if (uuid.equals(job.getId())) {
                    latch.countDown();
                    JobManager.this.removeCallback(this);
                }
            }
        });
        this.addJobInBackground(job);
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void addJobInBackground(Job job, final AsyncAddCallback callback) {
        if (callback == null) {
            this.addJobInBackground(job);
            return;
        }
        final String uuid = job.getId();
        this.addCallback(new JobManagerCallbackAdapter(){

            @Override
            public void onJobAdded(@NonNull Job job) {
                if (uuid.equals(job.getId())) {
                    try {
                        callback.onAdded();
                    }
                    finally {
                        JobManager.this.removeCallback(this);
                    }
                }
            }
        });
        this.addJobInBackground(job);
    }

    public CancelResult cancelJobs(TagConstraint constraint, String ... tags) {
        this.assertNotInMainThread("Cannot call this method on main thread. Use cancelJobsInBackground instead");
        this.assertNotInJobManagerThread("Cannot call this method on JobManager's thread. UsecancelJobsInBackground instead");
        if (constraint == null) {
            throw new IllegalArgumentException("must provide a TagConstraint");
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final CancelResult[] result = new CancelResult[1];
        CancelResult.AsyncCancelCallback myCallback = new CancelResult.AsyncCancelCallback(){

            @Override
            public void onCancelled(CancelResult cancelResult) {
                result[0] = cancelResult;
                latch.countDown();
            }
        };
        CancelMessage message = this.messageFactory.obtain(CancelMessage.class);
        message.setConstraint(constraint);
        message.setTags(tags);
        message.setCallback(myCallback);
        this.messageQueue.post(message);
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result[0];
    }

    public int count() {
        this.assertNotInMainThread();
        this.assertNotInJobManagerThread("Cannot call count sync method in JobManager's thread");
        PublicQueryMessage message = this.messageFactory.obtain(PublicQueryMessage.class);
        message.set(0, null);
        return new IntQueryFuture<PublicQueryMessage>(this.messageQueue, message).getSafe();
    }

    public int countReadyJobs() {
        this.assertNotInMainThread();
        this.assertNotInJobManagerThread("Cannot call countReadyJobs sync method on JobManager's thread");
        PublicQueryMessage message = this.messageFactory.obtain(PublicQueryMessage.class);
        message.set(1, null);
        return new IntQueryFuture<PublicQueryMessage>(this.messageQueue, message).getSafe();
    }

    public JobStatus getJobStatus(String id) {
        this.assertNotInMainThread();
        this.assertNotInJobManagerThread("Cannot call getJobStatus on JobManager's thread");
        PublicQueryMessage message = this.messageFactory.obtain(PublicQueryMessage.class);
        message.set(4, id, null);
        Integer status = new IntQueryFuture<PublicQueryMessage>(this.messageQueue, message).getSafe();
        return JobStatus.values()[status];
    }

    public void clear() {
        this.assertNotInMainThread();
        this.assertNotInJobManagerThread("Cannot call clear on JobManager's thread");
        PublicQueryMessage message = this.messageFactory.obtain(PublicQueryMessage.class);
        message.set(5, null);
        new IntQueryFuture<PublicQueryMessage>(this.messageQueue, message).getSafe();
    }

    void internalRunInJobManagerThread(final Runnable runnable) throws Throwable {
        final Throwable[] error = new Throwable[1];
        PublicQueryMessage message = this.messageFactory.obtain(PublicQueryMessage.class);
        message.set(101, null);
        new IntQueryFuture<PublicQueryMessage>((MessageQueue)this.messageQueue, message){

            @Override
            public void onResult(int result) {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    error[0] = t;
                }
                super.onResult(result);
            }
        }.getSafe();
        if (error[0] != null) {
            throw error[0];
        }
    }

    private void assertNotInMainThread() {
        this.assertNotInMainThread("Cannot call this method on main thread.");
    }

    private void assertNotInMainThread(String message) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            throw new WrongThreadException(message);
        }
    }

    private void assertNotInJobManagerThread(String message) {
        if (Thread.currentThread() == this.chefThread) {
            throw new WrongThreadException(message);
        }
    }

    static class IntQueryFuture<T extends Message>
    implements Future<Integer>,
    IntCallback {
        final MessageQueue messageQueue;
        volatile Integer result = null;
        final CountDownLatch latch = new CountDownLatch(1);
        final T message;

        IntQueryFuture(MessageQueue messageQueue, T message) {
            this.messageQueue = messageQueue;
            this.message = message;
            ((IntCallback.MessageWithCallback)message).setCallback(this);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.latch.getCount() == 0L;
        }

        Integer getSafe() {
            try {
                return this.get();
            }
            catch (Throwable t) {
                JqLog.e(t, "message is not complete", new Object[0]);
                throw new RuntimeException("cannot get the result of the JobManager query");
            }
        }

        @Override
        public Integer get() throws InterruptedException, ExecutionException {
            this.messageQueue.post((Message)this.message);
            this.latch.await();
            return this.result;
        }

        @Override
        public Integer get(long timeout, @NonNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.messageQueue.post((Message)this.message);
            this.latch.await(timeout, unit);
            return this.result;
        }

        @Override
        public void onResult(int result) {
            this.result = result;
            this.latch.countDown();
        }
    }
}

