/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.birbit.android.jobqueue.Job;
import com.birbit.android.jobqueue.RetryConstraint;
import com.birbit.android.jobqueue.timer.Timer;
import java.util.Set;

public class JobHolder {
    public static final int RUN_RESULT_SUCCESS = 1;
    public static final int RUN_RESULT_FAIL_RUN_LIMIT = 2;
    public static final int RUN_RESULT_FAIL_FOR_CANCEL = 3;
    public static final int RUN_RESULT_TRY_AGAIN = 4;
    public static final int RUN_RESULT_FAIL_SHOULD_RE_RUN = 5;
    public static final int RUN_RESULT_FAIL_SINGLE_ID = 6;
    public static final int RUN_RESULT_HIT_DEADLINE = 7;
    private Long insertionOrder;
    public final String id;
    public final boolean persistent;
    private int priority;
    public final String groupId;
    private int runCount;
    private long delayUntilNs;
    private long createdNs;
    private long runningSessionId;
    int requiredNetworkType;
    private long deadlineNs;
    private boolean cancelOnDeadline;
    final transient Job job;
    protected final Set<String> tags;
    private volatile boolean cancelled;
    private volatile boolean cancelledSingleId;
    RetryConstraint retryConstraint;
    @Nullable
    private Throwable throwable;

    private JobHolder(String id, boolean persistent, int priority, String groupId, int runCount, Job job, long createdNs, long delayUntilNs, long runningSessionId, Set<String> tags, int requiredNetworkType, long deadlineNs, boolean cancelOnDeadline) {
        this.id = id;
        this.persistent = persistent;
        this.priority = priority;
        this.groupId = groupId;
        this.runCount = runCount;
        this.createdNs = createdNs;
        this.delayUntilNs = delayUntilNs;
        this.job = job;
        this.runningSessionId = runningSessionId;
        this.requiredNetworkType = requiredNetworkType;
        this.tags = tags;
        this.deadlineNs = deadlineNs;
        this.cancelOnDeadline = cancelOnDeadline;
    }

    int safeRun(int currentRunCount, Timer timer) {
        return this.job.safeRun(this, currentRunCount, timer);
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    public final String getSingleInstanceId() {
        if (this.tags != null) {
            for (String tag : this.tags) {
                if (!tag.startsWith("job-single-id:")) continue;
                return tag;
            }
        }
        return null;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.job.priority = this.priority = priority;
    }

    public Long getInsertionOrder() {
        return this.insertionOrder;
    }

    public void setInsertionOrder(long insertionOrder) {
        this.insertionOrder = insertionOrder;
    }

    public void setDelayUntilNs(long delayUntilNs) {
        this.delayUntilNs = delayUntilNs;
    }

    public int getRunCount() {
        return this.runCount;
    }

    public void setRunCount(int runCount) {
        this.runCount = runCount;
    }

    public long getCreatedNs() {
        return this.createdNs;
    }

    public long getRunningSessionId() {
        return this.runningSessionId;
    }

    public void setRunningSessionId(long runningSessionId) {
        this.runningSessionId = runningSessionId;
    }

    public long getDeadlineNs() {
        return this.deadlineNs;
    }

    public boolean shouldCancelOnDeadline() {
        return this.cancelOnDeadline;
    }

    public long getDelayUntilNs() {
        return this.delayUntilNs;
    }

    public Job getJob() {
        return this.job;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void markAsCancelled() {
        this.cancelled = true;
        this.job.cancelled = true;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void markAsCancelledSingleId() {
        this.cancelledSingleId = true;
        this.markAsCancelled();
    }

    public boolean isCancelledSingleId() {
        return this.cancelledSingleId;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof JobHolder)) {
            return false;
        }
        JobHolder other = (JobHolder)o;
        return this.id.equals(other.id);
    }

    public boolean hasTags() {
        return this.tags != null && this.tags.size() > 0;
    }

    public void setApplicationContext(Context applicationContext) {
        this.job.setApplicationContext(applicationContext);
    }

    public void setDeadlineIsReached(boolean didReachDeadline) {
        this.job.setDeadlineReached(didReachDeadline);
    }

    public boolean hasDeadline() {
        return this.deadlineNs != Long.MAX_VALUE;
    }

    public boolean hasDelay() {
        return this.delayUntilNs != Long.MIN_VALUE;
    }

    public void onCancel(int cancelReason) {
        this.job.onCancel(cancelReason, this.throwable);
    }

    public RetryConstraint getRetryConstraint() {
        return this.retryConstraint;
    }

    void setThrowable(@Nullable Throwable throwable) {
        this.throwable = throwable;
    }

    @Nullable
    Throwable getThrowable() {
        return this.throwable;
    }

    public int getRequiredNetworkType() {
        return this.requiredNetworkType;
    }

    public static class Builder {
        private int priority;
        private static final int FLAG_PRIORITY = 1;
        private String id;
        private static final int FLAG_PERSISTENT = 2;
        private boolean persistent;
        private static final int FLAG_ID = 4;
        private String groupId;
        private static final int FLAG_GROUP_ID = 8;
        private int runCount = 0;
        private Job job;
        private static final int FLAG_JOB = 16;
        private long createdNs;
        private static final int FLAG_CREATED_NS = 32;
        private long delayUntilNs = Long.MIN_VALUE;
        private static final int FLAG_DELAY_UNTIL = 64;
        private Long insertionOrder;
        private long runningSessionId;
        private long deadlineNs = Long.MAX_VALUE;
        private boolean cancelOnDeadline = false;
        private static final int FLAG_DEADLINE = 128;
        private static final int FLAG_RUNNING_SESSION_ID = 256;
        private int providedFlags = 0;
        private Set<String> tags;
        private static final int FLAG_TAGS = 512;
        private int requiredNetworkType;
        private static final int FLAG_REQ_NETWORK = 1024;
        private static final int REQUIRED_FLAGS = 2047;

        public Builder priority(int priority) {
            this.priority = priority;
            this.providedFlags |= 1;
            return this;
        }

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            this.providedFlags |= 8;
            return this;
        }

        public Builder tags(Set<String> tags) {
            this.tags = tags;
            this.providedFlags |= 0x200;
            return this;
        }

        public Builder runCount(int runCount) {
            this.runCount = runCount;
            return this;
        }

        public Builder persistent(boolean persistent) {
            this.persistent = persistent;
            this.providedFlags |= 2;
            return this;
        }

        public Builder job(Job job) {
            this.job = job;
            this.providedFlags |= 0x10;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.providedFlags |= 4;
            return this;
        }

        public Builder requiredNetworkType(int requiredNetworkType) {
            this.requiredNetworkType = requiredNetworkType;
            this.providedFlags |= 0x400;
            return this;
        }

        public Builder createdNs(long createdNs) {
            this.createdNs = createdNs;
            this.providedFlags |= 0x20;
            return this;
        }

        public Builder delayUntilNs(long delayUntilNs) {
            this.delayUntilNs = delayUntilNs;
            this.providedFlags |= 0x40;
            return this;
        }

        public Builder insertionOrder(long insertionOrder) {
            this.insertionOrder = insertionOrder;
            return this;
        }

        public Builder runningSessionId(long runningSessionId) {
            this.runningSessionId = runningSessionId;
            this.providedFlags |= 0x100;
            return this;
        }

        public Builder deadline(long deadlineNs, boolean cancelOnDeadline) {
            this.deadlineNs = deadlineNs;
            this.cancelOnDeadline = cancelOnDeadline;
            this.providedFlags |= 0x80;
            return this;
        }

        public JobHolder build() {
            if (this.job == null) {
                throw new IllegalArgumentException("must provide a job");
            }
            int flagCheck = 0x7FF & this.providedFlags;
            if (flagCheck != 2047) {
                throw new IllegalArgumentException("must provide all required fields. your result:" + Long.toBinaryString(flagCheck));
            }
            JobHolder jobHolder = new JobHolder(this.id, this.persistent, this.priority, this.groupId, this.runCount, this.job, this.createdNs, this.delayUntilNs, this.runningSessionId, this.tags, this.requiredNetworkType, this.deadlineNs, this.cancelOnDeadline);
            if (this.insertionOrder != null) {
                jobHolder.setInsertionOrder(this.insertionOrder);
            }
            this.job.updateFromJobHolder(jobHolder);
            return jobHolder;
        }
    }
}

