/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue;

import android.support.annotation.NonNull;
import com.birbit.android.jobqueue.JobHolder;
import com.birbit.android.jobqueue.JobManagerThread;
import com.birbit.android.jobqueue.RetryConstraint;
import com.birbit.android.jobqueue.RunningJobSet;
import com.birbit.android.jobqueue.TagConstraint;
import com.birbit.android.jobqueue.config.Configuration;
import com.birbit.android.jobqueue.log.JqLog;
import com.birbit.android.jobqueue.messaging.Message;
import com.birbit.android.jobqueue.messaging.MessageFactory;
import com.birbit.android.jobqueue.messaging.MessagePredicate;
import com.birbit.android.jobqueue.messaging.MessageQueue;
import com.birbit.android.jobqueue.messaging.MessageQueueConsumer;
import com.birbit.android.jobqueue.messaging.SafeMessageQueue;
import com.birbit.android.jobqueue.messaging.Type;
import com.birbit.android.jobqueue.messaging.message.CommandMessage;
import com.birbit.android.jobqueue.messaging.message.JobConsumerIdleMessage;
import com.birbit.android.jobqueue.messaging.message.RunJobMessage;
import com.birbit.android.jobqueue.messaging.message.RunJobResultMessage;
import com.birbit.android.jobqueue.scheduling.SchedulerConstraint;
import com.birbit.android.jobqueue.timer.Timer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadFactory;

class ConsumerManager {
    private List<Consumer> waitingConsumers = new ArrayList<Consumer>();
    private final List<Consumer> consumers = new ArrayList<Consumer>();
    private final int maxConsumerCount;
    private final int minConsumerCount;
    private final long consumerKeepAliveNs;
    private final int threadPriority;
    private final int loadFactor;
    private final ThreadGroup threadGroup;
    private final JobManagerThread jobManagerThread;
    private final Timer timer;
    private final MessageFactory factory;
    private final Map<String, JobHolder> runningJobHolders;
    final RunningJobSet runningJobGroups;
    private final ThreadFactory threadFactory;
    private final CopyOnWriteArrayList<Runnable> internalZeroConsumersListeners = new CopyOnWriteArrayList();

    ConsumerManager(JobManagerThread jobManagerThread, Timer timer, MessageFactory factory, Configuration configuration) {
        this.jobManagerThread = jobManagerThread;
        this.timer = timer;
        this.factory = factory;
        this.loadFactor = configuration.getLoadFactor();
        this.minConsumerCount = configuration.getMinConsumerCount();
        this.maxConsumerCount = configuration.getMaxConsumerCount();
        this.consumerKeepAliveNs = (long)(configuration.getConsumerKeepAlive() * 1000) * 1000000L;
        this.threadPriority = configuration.getThreadPriority();
        this.threadFactory = configuration.getThreadFactory();
        this.runningJobHolders = new HashMap<String, JobHolder>();
        this.runningJobGroups = new RunningJobSet(timer);
        this.threadGroup = new ThreadGroup("JobConsumers");
    }

    void addNoConsumersListener(Runnable runnable) {
        this.internalZeroConsumersListeners.add(runnable);
    }

    boolean removeNoConsumersListener(Runnable runnable) {
        return this.internalZeroConsumersListeners.remove(runnable);
    }

    void onJobAdded() {
        this.considerAddingConsumers(false);
    }

    boolean handleConstraintChange() {
        return this.considerAddingConsumers(true);
    }

    void handleStop() {
        for (Consumer consumer : this.consumers) {
            SafeMessageQueue mq = consumer.messageQueue;
            CommandMessage command = this.factory.obtain(CommandMessage.class);
            command.set(2);
            mq.post(command);
        }
        if (this.consumers.isEmpty()) {
            for (Runnable runnable : this.internalZeroConsumersListeners) {
                runnable.run();
            }
        }
    }

    private boolean considerAddingConsumers(boolean pokeAllWaiting) {
        JqLog.d("considering adding a new consumer. Should poke all waiting? %s isRunning? %s waiting workers? %d", pokeAllWaiting, this.jobManagerThread.isRunning(), this.waitingConsumers.size());
        if (!this.jobManagerThread.isRunning()) {
            JqLog.d("jobqueue is not running, no consumers will be added", new Object[0]);
            return false;
        }
        if (this.waitingConsumers.size() > 0) {
            JqLog.d("there are waiting workers, will poke them instead", new Object[0]);
            for (int i = this.waitingConsumers.size() - 1; i >= 0; --i) {
                Consumer consumer = this.waitingConsumers.remove(i);
                CommandMessage command = this.factory.obtain(CommandMessage.class);
                command.set(2);
                consumer.messageQueue.post(command);
                if (!pokeAllWaiting) break;
            }
            JqLog.d("there were waiting workers, poked them and I'm done", new Object[0]);
            return true;
        }
        boolean isAboveLoadFactor = this.isAboveLoadFactor();
        JqLog.d("nothing has been poked. are we above load factor? %s", isAboveLoadFactor);
        if (isAboveLoadFactor) {
            this.addWorker();
            return true;
        }
        return false;
    }

    private void addWorker() {
        Thread thread;
        JqLog.d("adding another consumer", new Object[0]);
        Consumer consumer = new Consumer(this.jobManagerThread.messageQueue, new SafeMessageQueue(this.timer, this.factory, "consumer"), this.factory, this.timer);
        if (this.threadFactory != null) {
            thread = this.threadFactory.newThread(consumer);
        } else {
            thread = new Thread(this.threadGroup, consumer, "job-queue-worker-" + UUID.randomUUID());
            thread.setPriority(this.threadPriority);
        }
        this.consumers.add(consumer);
        thread.start();
    }

    private boolean isAboveLoadFactor() {
        int runningHolders;
        int workerCount = this.consumers.size();
        if (workerCount >= this.maxConsumerCount) {
            JqLog.d("too many consumers, clearly above load factor %s", workerCount);
            return false;
        }
        int remainingJobs = this.jobManagerThread.countRemainingReadyJobs();
        boolean aboveLoadFactor = workerCount * this.loadFactor < remainingJobs + (runningHolders = this.runningJobHolders.size()) || workerCount < this.minConsumerCount && workerCount < remainingJobs + runningHolders;
        JqLog.d("check above load factor: totalCons:%s minCons:%s maxConsCount: %s, loadFactor %s remainingJobs: %s running holders: %s. isAbove:%s", workerCount, this.minConsumerCount, this.maxConsumerCount, this.loadFactor, remainingJobs, runningHolders, aboveLoadFactor);
        return aboveLoadFactor;
    }

    boolean handleIdle(@NonNull JobConsumerIdleMessage message) {
        Consumer consumer = (Consumer)message.getWorker();
        if (consumer.hasJob) {
            return true;
        }
        JobHolder nextJob = null;
        boolean running = this.jobManagerThread.isRunning();
        if (running) {
            nextJob = this.jobManagerThread.getNextJob(this.runningJobGroups.getSafe());
        }
        if (nextJob != null) {
            consumer.hasJob = true;
            this.runningJobGroups.add(nextJob.getGroupId());
            RunJobMessage runJobMessage = this.factory.obtain(RunJobMessage.class);
            runJobMessage.setJobHolder(nextJob);
            this.runningJobHolders.put(nextJob.getJob().getId(), nextJob);
            if (nextJob.getGroupId() != null) {
                this.runningJobGroups.add(nextJob.getGroupId());
            }
            consumer.messageQueue.post(runJobMessage);
            return true;
        }
        long keepAliveTimeout = message.getLastJobCompleted() + this.consumerKeepAliveNs;
        JqLog.d("keep alive: %s", keepAliveTimeout);
        boolean tooMany = this.consumers.size() > this.minConsumerCount;
        boolean kill = !running || tooMany && keepAliveTimeout < this.timer.nanoTime();
        JqLog.d("Consumer idle, will kill? %s . isRunning: %s", kill, running);
        if (kill) {
            CommandMessage command = this.factory.obtain(CommandMessage.class);
            command.set(1);
            consumer.messageQueue.post(command);
            this.waitingConsumers.remove(consumer);
            this.consumers.remove(consumer);
            JqLog.d("killed consumers. remaining consumers %d", this.consumers.size());
            if (this.consumers.isEmpty() && this.internalZeroConsumersListeners != null) {
                for (Runnable runnable : this.internalZeroConsumersListeners) {
                    runnable.run();
                }
            }
        } else {
            if (!this.waitingConsumers.contains(consumer)) {
                this.waitingConsumers.add(consumer);
            }
            if (tooMany || !this.jobManagerThread.canListenToNetwork()) {
                CommandMessage cm = this.factory.obtain(CommandMessage.class);
                cm.set(2);
                if (!tooMany) {
                    keepAliveTimeout = this.timer.nanoTime() + this.consumerKeepAliveNs;
                }
                consumer.messageQueue.postAt(cm, keepAliveTimeout);
                JqLog.d("poke consumer manager at %s", keepAliveTimeout);
            }
        }
        return false;
    }

    Set<String> markJobsCancelled(TagConstraint constraint, String[] tags) {
        return this.markJobsCancelled(constraint, tags, false);
    }

    Set<String> markJobsCancelledSingleId(TagConstraint constraint, String[] tags) {
        return this.markJobsCancelled(constraint, tags, true);
    }

    private Set<String> markJobsCancelled(TagConstraint constraint, String[] tags, boolean singleId) {
        HashSet<String> result = new HashSet<String>();
        for (JobHolder holder : this.runningJobHolders.values()) {
            JqLog.d("checking job tag %s. tags of job: %s", holder.getJob(), holder.getJob().getTags());
            if (!holder.hasTags() || holder.isCancelled() || !constraint.matches(tags, holder.getTags())) continue;
            result.add(holder.getId());
            if (singleId) {
                holder.markAsCancelledSingleId();
                continue;
            }
            holder.markAsCancelled();
        }
        return result;
    }

    void handleRunJobResult(RunJobResultMessage message, JobHolder jobHolder, RetryConstraint retryConstraint) {
        Consumer consumer = (Consumer)message.getWorker();
        if (!consumer.hasJob) {
            throw new IllegalStateException("this worker should not have a job");
        }
        consumer.hasJob = false;
        this.runningJobHolders.remove(jobHolder.getJob().getId());
        if (jobHolder.getGroupId() != null) {
            this.runningJobGroups.remove(jobHolder.getGroupId());
            if (retryConstraint != null && retryConstraint.willApplyNewDelayToGroup() && retryConstraint.getNewDelayInMs() > 0L) {
                this.runningJobGroups.addGroupUntil(jobHolder.getGroupId(), this.timer.nanoTime() + retryConstraint.getNewDelayInMs() * 1000000L);
            }
        }
    }

    boolean isJobRunning(String id) {
        return this.runningJobHolders.get(id) != null;
    }

    public int getWorkerCount() {
        return this.consumers.size();
    }

    public boolean hasJobsWithSchedulerConstraint(SchedulerConstraint constraint) {
        for (JobHolder jobHolder : this.runningJobHolders.values()) {
            if (!jobHolder.getJob().isPersistent() || constraint.getNetworkStatus() < jobHolder.requiredNetworkType) continue;
            return true;
        }
        return false;
    }

    public boolean areAllConsumersIdle() {
        return this.waitingConsumers.size() == this.consumers.size();
    }

    static class Consumer
    implements Runnable {
        final SafeMessageQueue messageQueue;
        final MessageQueue parentMessageQueue;
        final MessageFactory factory;
        final Timer timer;
        boolean hasJob;
        long lastJobCompleted;
        static final MessagePredicate pokeMessagePredicate = new MessagePredicate(){

            @Override
            public boolean onMessage(Message message) {
                return message.type == Type.COMMAND && ((CommandMessage)message).getWhat() == 2;
            }
        };
        final MessageQueueConsumer queueConsumer = new MessageQueueConsumer(){

            @Override
            public void handleMessage(Message message) {
                switch (message.type) {
                    case RUN_JOB: {
                        Consumer.this.handleRunJob((RunJobMessage)message);
                        Consumer.this.lastJobCompleted = Consumer.this.timer.nanoTime();
                        Consumer.this.removePokeMessages();
                        break;
                    }
                    case COMMAND: {
                        Consumer.this.handleCommand((CommandMessage)message);
                    }
                }
            }

            @Override
            public void onIdle() {
                JqLog.d("consumer manager on idle", new Object[0]);
                JobConsumerIdleMessage idle = Consumer.this.factory.obtain(JobConsumerIdleMessage.class);
                idle.setWorker(Consumer.this);
                idle.setLastJobCompleted(Consumer.this.lastJobCompleted);
                Consumer.this.parentMessageQueue.post(idle);
            }
        };

        private void removePokeMessages() {
            this.messageQueue.cancelMessages(pokeMessagePredicate);
        }

        public Consumer(MessageQueue parentMessageQueue, SafeMessageQueue messageQueue, MessageFactory factory, Timer timer) {
            this.messageQueue = messageQueue;
            this.factory = factory;
            this.parentMessageQueue = parentMessageQueue;
            this.timer = timer;
            this.lastJobCompleted = timer.nanoTime();
        }

        @Override
        public void run() {
            this.messageQueue.consume(this.queueConsumer);
        }

        private void handleCommand(CommandMessage message) {
            switch (message.getWhat()) {
                case 1: {
                    this.messageQueue.stop();
                    break;
                }
                case 2: {
                    JqLog.d("Consumer has been poked.", new Object[0]);
                }
            }
        }

        private void handleRunJob(RunJobMessage message) {
            JqLog.d("running job %s", message.getJobHolder().getClass().getSimpleName());
            JobHolder jobHolder = message.getJobHolder();
            int result = jobHolder.safeRun(jobHolder.getRunCount(), this.timer);
            RunJobResultMessage resultMessage = this.factory.obtain(RunJobResultMessage.class);
            resultMessage.setJobHolder(jobHolder);
            resultMessage.setResult(result);
            resultMessage.setWorker(this);
            this.parentMessageQueue.post(resultMessage);
        }
    }
}

