/*
 * Decompiled with CFR 0.152.
 */
package com.binaryfork.spanny;

import android.support.annotation.NonNull;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.style.ImageSpan;

public class Spanny
extends SpannableStringBuilder {
    private int flag = 33;

    public Spanny() {
        super((CharSequence)"");
    }

    public Spanny(CharSequence text) {
        super(text);
    }

    public Spanny(CharSequence text, Object ... spans) {
        super(text);
        for (Object span : spans) {
            this.setSpan(span, 0, this.length());
        }
    }

    public Spanny(CharSequence text, Object span) {
        super(text);
        this.setSpan(span, 0, text.length());
    }

    public Spanny append(CharSequence text, Object ... spans) {
        this.append(text);
        for (Object span : spans) {
            this.setSpan(span, this.length() - text.length(), this.length());
        }
        return this;
    }

    public Spanny append(CharSequence text, Object span) {
        this.append(text);
        this.setSpan(span, this.length() - text.length(), this.length());
        return this;
    }

    public Spanny append(CharSequence text, ImageSpan imageSpan) {
        text = "." + text;
        this.append(text);
        this.setSpan(imageSpan, this.length() - text.length(), this.length() - text.length() + 1);
        return this;
    }

    @NonNull
    public Spanny append(@NonNull CharSequence text) {
        super.append(text);
        return this;
    }

    @Deprecated
    public Spanny appendText(CharSequence text) {
        this.append(text);
        return this;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    private void setSpan(Object span, int start, int end) {
        this.setSpan(span, start, end, this.flag);
    }

    public Spanny findAndSpan(CharSequence textToSpan, GetSpan getSpan) {
        int lastIndex = 0;
        while (lastIndex != -1) {
            lastIndex = this.toString().indexOf(textToSpan.toString(), lastIndex);
            if (lastIndex == -1) continue;
            this.setSpan(getSpan.getSpan(), lastIndex, lastIndex + textToSpan.length());
            lastIndex += textToSpan.length();
        }
        return this;
    }

    public static SpannableString spanText(CharSequence text, Object ... spans) {
        SpannableString spannableString = new SpannableString(text);
        for (Object span : spans) {
            spannableString.setSpan(span, 0, text.length(), 33);
        }
        return spannableString;
    }

    public static SpannableString spanText(CharSequence text, Object span) {
        SpannableString spannableString = new SpannableString(text);
        spannableString.setSpan(span, 0, text.length(), 33);
        return spannableString;
    }

    public static interface GetSpan {
        public Object getSpan();
    }
}

