/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ui.textview.span;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.style.ImageSpan;

public class ZixieTextImageSpan
extends ImageSpan {
    private static final int DEFAULT_MARGIN = 12;
    private int mMargin = 12;

    public ZixieTextImageSpan(Context context, int drawableRes) {
        super(context, drawableRes);
    }

    public ZixieTextImageSpan(Context context, int drawableRes, int margin) {
        super(context, drawableRes);
        this.mMargin = margin;
    }

    public ZixieTextImageSpan(Context context, Bitmap map) {
        super(context, map);
    }

    public ZixieTextImageSpan(Context context, Bitmap map, int margin) {
        super(context, map);
        this.mMargin = margin;
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        try {
            Paint.FontMetricsInt paintFm = paint.getFontMetricsInt();
            int textHeight = paintFm.descent - paintFm.ascent;
            Drawable b = this.getDrawable();
            int sourceBitmapWidth = b.getBounds().width();
            int sourceBitmapHeight = b.getBounds().height();
            int newBitmapWidth = sourceBitmapWidth * textHeight / sourceBitmapHeight;
            return newBitmapWidth + 1 + this.mMargin * 2;
        }
        catch (Exception e) {
            return super.getSize(paint, text, start, end, fm);
        }
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        try {
            Drawable drawable = this.getDrawable();
            Bitmap b = ((BitmapDrawable)drawable).getBitmap();
            Paint.FontMetricsInt fm = paint.getFontMetricsInt();
            int textHeight = fm.descent - fm.ascent;
            int sourceBitmapWidth = b.getWidth();
            int sourceBitmapHeight = b.getHeight();
            int newBitmapWidth = sourceBitmapWidth * textHeight / sourceBitmapHeight;
            Bitmap bitmapResized = Bitmap.createScaledBitmap((Bitmap)b, (int)newBitmapWidth, (int)textHeight, (boolean)false);
            canvas.save();
            float transY = y + (fm.descent + fm.ascent) / 2 - textHeight / 2;
            canvas.drawBitmap(bitmapResized, (float)((int)x + this.mMargin), transY, paint);
            canvas.save();
            canvas.restore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

