/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ui.textview.expandable;

import android.content.Context;
import android.support.v7.widget.AppCompatTextView;
import android.text.Spanned;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.util.AttributeSet;
import android.widget.TextView;
import com.bihe0832.android.lib.text.TextFactoryUtils;
import com.bihe0832.android.lib.ui.textview.ext.TextViewExtKt;

public class TextViewWithHTML
extends AppCompatTextView {
    public TextViewWithHTML(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public TextViewWithHTML(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setText(CharSequence htmlText, TextView.BufferType type) {
        Spanned html = TextFactoryUtils.getSpannedTextByHtml((String)htmlText.toString());
        ClickableSpan[] spans = (ClickableSpan[])html.getSpans(0, html.length(), ClickableSpan.class);
        if (spans != null && spans.length > 0) {
            this.setMovementMethod(LinkMovementMethod.getInstance());
        }
        super.setText((CharSequence)html, type);
    }

    public void setHTMLText(CharSequence htmlText) {
        this.setText(htmlText, TextView.BufferType.NORMAL);
    }

    public void setFormatText(String format, Object ... args) {
        TextViewExtKt.setText((TextView)this, format, args);
    }
}

