/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.okhttp.wrapper.interceptor;

import android.text.TextUtils;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.okhttp.wrapper.OkHttpWrapper;
import com.bihe0832.android.lib.okhttp.wrapper.interceptor.data.AAFRequestDataRepository;
import com.bihe0832.android.lib.okhttp.wrapper.interceptor.data.RequestContentDataRecord;
import com.bihe0832.android.lib.okhttp.wrapper.interceptor.data.RequestRecord;
import com.bihe0832.android.lib.okhttp.wrapper.interceptor.data.RequestTraceTimeRecord;
import com.bihe0832.android.lib.thread.ThreadManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J,\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J6\u0010#\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J \u0010$\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J(\u0010%\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\b2\u000e\u0010'\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010(H\u0016J\u0018\u0010*\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\bH\u0016J\u0006\u0010+\u001a\u00020\u0014J\u0006\u0010,\u001a\u00020\bJ\u0006\u0010-\u001a\u00020\bJ\u0010\u0010.\u001a\u00020\u00142\u0006\u0010/\u001a\u000200H\u0016J\u0012\u0010.\u001a\u00020\u00142\b\u0010/\u001a\u0004\u0018\u000101H\u0016J\u0018\u00102\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u00106\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010:\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010;\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010<\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010@\u001a\u00020\u00142\u0006\u0010A\u001a\u00020\bH\u0002J\u001a\u0010B\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010C\u001a\u0004\u0018\u00010DH\u0016J\u0010\u0010E\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0001X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/bihe0832/android/lib/okhttp/wrapper/interceptor/AAFOkHttpNetworkEventListener;", "Lokhttp3/EventListener;", "enableTrace", "", "enableLog", "listener", "(ZZLokhttp3/EventListener;)V", "TAG", "", "getEnableLog", "()Z", "getEnableTrace", "hasLog", "getListener", "()Lokhttp3/EventListener;", "mNetworkContentRequestID", "mNetworkTraceRequestID", "mRequestTraceTimeRecord", "Lcom/bihe0832/android/lib/okhttp/wrapper/interceptor/data/RequestTraceTimeRecord;", "callEnd", "", "call", "Lokhttp3/Call;", "callFailed", "ioe", "Ljava/io/IOException;", "callStart", "canTrace", "connectEnd", "inetSocketAddress", "Ljava/net/InetSocketAddress;", "proxy", "Ljava/net/Proxy;", "protocol", "Lokhttp3/Protocol;", "connectFailed", "connectStart", "dnsEnd", "domainName", "inetAddressList", "", "Ljava/net/InetAddress;", "dnsStart", "doLogAction", "getNetworkContentRequestID", "getNetworkTraceRequestID", "logRequest", "record", "Lcom/bihe0832/android/lib/okhttp/wrapper/interceptor/data/RequestContentDataRecord;", "Lcom/bihe0832/android/lib/okhttp/wrapper/interceptor/data/RequestRecord;", "requestBodyEnd", "byteCount", "", "requestBodyStart", "requestHeadersEnd", "request", "Lokhttp3/Request;", "requestHeadersStart", "responseBodyEnd", "responseBodyStart", "responseHeadersEnd", "response", "Lokhttp3/Response;", "responseHeadersStart", "saveEvent", "eventName", "secureConnectEnd", "handshake", "Lokhttp3/Handshake;", "secureConnectStart", "LibOkhttpWrapper_release"})
public class AAFOkHttpNetworkEventListener
extends EventListener {
    private final boolean enableTrace;
    private final boolean enableLog;
    @Nullable
    private final EventListener listener;
    @NotNull
    private final String TAG;
    @Nullable
    private RequestTraceTimeRecord mRequestTraceTimeRecord;
    @NotNull
    private String mNetworkTraceRequestID;
    @NotNull
    private String mNetworkContentRequestID;
    private boolean hasLog;

    public AAFOkHttpNetworkEventListener(boolean enableTrace, boolean enableLog, @Nullable EventListener listener) {
        this.enableTrace = enableTrace;
        this.enableLog = enableLog;
        this.listener = listener;
        this.TAG = "AAFRequest";
        this.mNetworkTraceRequestID = "";
        this.mNetworkContentRequestID = "";
    }

    public /* synthetic */ AAFOkHttpNetworkEventListener(boolean bl, boolean bl2, EventListener eventListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        this(bl, bl2, eventListener);
    }

    protected final boolean getEnableTrace() {
        return this.enableTrace;
    }

    protected final boolean getEnableLog() {
        return this.enableLog;
    }

    @Nullable
    protected final EventListener getListener() {
        return this.listener;
    }

    public boolean canTrace(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        return this.enableTrace;
    }

    @NotNull
    public final String getNetworkTraceRequestID() {
        return this.mNetworkTraceRequestID;
    }

    @NotNull
    public final String getNetworkContentRequestID() {
        return this.mNetworkContentRequestID;
    }

    public void callStart(@NotNull Call call) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            super.callStart(call);
            this.mNetworkTraceRequestID = OkHttpWrapper.INSTANCE.generateRequestID();
            if (this.canTrace(call)) {
                String string = call.request().url().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"call.request().url().toString()");
                String string2 = call.request().method();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"call.request().method()");
                this.mRequestTraceTimeRecord = OkHttpWrapper.INSTANCE.getRecord(this.mNetworkTraceRequestID, string, string2).getRecordTraceTimeData();
            }
            String string = RequestTraceTimeRecord.EVENT_CALL_START;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EVENT_CALL_START");
            this.saveEvent(string);
            EventListener eventListener = this.listener;
            if (eventListener == null) break block1;
            eventListener.callStart(call);
        }
    }

    public void dnsStart(@NotNull Call call, @NotNull String domainName) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
            super.dnsStart(call, domainName);
            String string = RequestTraceTimeRecord.EVENT_DNS_START;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EVENT_DNS_START");
            this.saveEvent(string);
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.dnsStart(call, domainName);
        }
    }

    public void dnsEnd(@NotNull Call call, @NotNull String domainName, @Nullable List<InetAddress> inetAddressList) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
            super.dnsEnd(call, domainName, inetAddressList);
            String string = RequestTraceTimeRecord.EVENT_DNS_END;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EVENT_DNS_END");
            this.saveEvent(string);
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.dnsEnd(call, domainName, inetAddressList);
        }
    }

    public void connectStart(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
            Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
            super.connectStart(call, inetSocketAddress, proxy);
            String string = RequestTraceTimeRecord.EVENT_CONNECT_START;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EVENT_CONNECT_START");
            this.saveEvent(string);
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.connectStart(call, inetSocketAddress, proxy);
        }
    }

    public void secureConnectStart(@NotNull Call call) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            super.secureConnectStart(call);
            String string = RequestTraceTimeRecord.EVENT_SECURE_CONNECT_START;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EVENT_SECURE_CONNECT_START");
            this.saveEvent(string);
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.secureConnectStart(call);
        }
    }

    public void secureConnectEnd(@NotNull Call call, @Nullable Handshake handshake) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            super.secureConnectEnd(call, handshake);
            String string = RequestTraceTimeRecord.EVENT_SECURE_CONNECT_END;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EVENT_SECURE_CONNECT_END");
            this.saveEvent(string);
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.secureConnectEnd(call, handshake);
        }
    }

    public void connectEnd(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @Nullable Proxy proxy, @Nullable Protocol protocol) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
            super.connectEnd(call, inetSocketAddress, proxy, protocol);
            String string = RequestTraceTimeRecord.EVENT_CONNECT_END;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EVENT_CONNECT_END");
            this.saveEvent(string);
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.connectEnd(call, inetSocketAddress, proxy, protocol);
        }
    }

    public void connectFailed(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @Nullable Proxy proxy, @Nullable Protocol protocol, @Nullable IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
        super.connectFailed(call, inetSocketAddress, proxy, protocol, ioe);
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.connectFailed(call, inetSocketAddress, proxy, protocol, ioe);
        }
        this.doLogAction();
    }

    public void requestHeadersStart(@NotNull Call call) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            super.requestHeadersStart(call);
            String string = RequestTraceTimeRecord.EVENT_REQUEST_HEADERS_START;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EVENT_REQUEST_HEADERS_START");
            this.saveEvent(string);
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.requestHeadersStart(call);
        }
    }

    public void requestHeadersEnd(@NotNull Call call, @NotNull Request request) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            super.requestHeadersEnd(call, request);
            String string = RequestTraceTimeRecord.EVENT_REQUEST_HEADERS_END;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EVENT_REQUEST_HEADERS_END");
            this.saveEvent(string);
            String string2 = request.header("AAF-Content-Request-Id");
            if (string2 != null) {
                String contentRequesetID = string2;
                boolean bl = false;
                if (!TextUtils.isEmpty((CharSequence)contentRequesetID)) {
                    ZLog.d((String)this.TAG, (String)("Request ID bind contentRequestId:" + contentRequesetID + ", traceID:" + this.mNetworkTraceRequestID));
                    this.mNetworkContentRequestID = contentRequesetID;
                    if (this.canTrace(call)) {
                        RequestTraceTimeRecord requestTraceTimeRecord = this.mRequestTraceTimeRecord;
                        if (requestTraceTimeRecord != null) {
                            requestTraceTimeRecord.setContentRequestId(this.mNetworkContentRequestID);
                        }
                    }
                    AAFRequestDataRepository.INSTANCE.getNetworkContentDataRecordByContentID(this.mNetworkContentRequestID).setMTraceRequestId(this.mNetworkTraceRequestID);
                }
            }
            EventListener eventListener = this.listener;
            if (eventListener == null) break block4;
            eventListener.requestHeadersEnd(call, request);
        }
    }

    public void requestBodyStart(@NotNull Call call) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            super.requestBodyStart(call);
            String string = RequestTraceTimeRecord.EVENT_REQUEST_BODY_START;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EVENT_REQUEST_BODY_START");
            this.saveEvent(string);
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.requestBodyStart(call);
        }
    }

    public void requestBodyEnd(@NotNull Call call, long byteCount) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            super.requestBodyEnd(call, byteCount);
            String string = RequestTraceTimeRecord.EVENT_REQUEST_BODY_END;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EVENT_REQUEST_BODY_END");
            this.saveEvent(string);
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.requestBodyEnd(call, byteCount);
        }
    }

    public void responseHeadersStart(@NotNull Call call) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            super.responseHeadersStart(call);
            String string = RequestTraceTimeRecord.EVENT_RESPONSE_HEADERS_START;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EVENT_RESPONSE_HEADERS_START");
            this.saveEvent(string);
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.responseHeadersStart(call);
        }
    }

    public void responseHeadersEnd(@NotNull Call call, @NotNull Response response) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            super.responseHeadersEnd(call, response);
            String string = RequestTraceTimeRecord.EVENT_RESPONSE_HEADERS_END;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EVENT_RESPONSE_HEADERS_END");
            this.saveEvent(string);
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.responseHeadersEnd(call, response);
        }
    }

    public void responseBodyStart(@NotNull Call call) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            super.responseBodyStart(call);
            String string = RequestTraceTimeRecord.EVENT_RESPONSE_BODY_START;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EVENT_RESPONSE_BODY_START");
            this.saveEvent(string);
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.responseBodyStart(call);
        }
    }

    public void responseBodyEnd(@NotNull Call call, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.responseBodyEnd(call, byteCount);
        String string = RequestTraceTimeRecord.EVENT_RESPONSE_BODY_END;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EVENT_RESPONSE_BODY_END");
        this.saveEvent(string);
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.responseBodyEnd(call, byteCount);
        }
        ThreadManager.getInstance().start(() -> AAFOkHttpNetworkEventListener.responseBodyEnd$lambda-1(this), 500L);
    }

    public void callEnd(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.callEnd(call);
        String string = RequestTraceTimeRecord.EVENT_CALL_END;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EVENT_CALL_END");
        this.saveEvent(string);
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.callEnd(call);
        }
        this.doLogAction();
    }

    public final synchronized void doLogAction() {
        if (!this.hasLog) {
            this.hasLog = true;
            if (this.enableLog) {
                if (this.enableTrace) {
                    this.logRequest(OkHttpWrapper.INSTANCE.getRecord(this.mNetworkTraceRequestID));
                } else {
                    this.logRequest(AAFRequestDataRepository.INSTANCE.getNetworkContentDataRecordByContentID(this.mNetworkContentRequestID));
                }
            }
        }
    }

    public void logRequest(@NotNull RequestContentDataRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        ZLog.d((String)this.TAG, (String)record.toString());
    }

    public void logRequest(@Nullable RequestRecord record) {
        ZLog.d((String)this.TAG, (String)String.valueOf(record));
    }

    public void callFailed(@NotNull Call call, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        super.callFailed(call, ioe);
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.callFailed(call, ioe);
        }
        this.doLogAction();
    }

    private final void saveEvent(String eventName) {
        block1: {
            if (!this.enableTrace) break block1;
            ZLog.d((String)this.TAG, (String)eventName);
            RequestTraceTimeRecord requestTraceTimeRecord = this.mRequestTraceTimeRecord;
            if (requestTraceTimeRecord != null) {
                requestTraceTimeRecord.saveEvent(eventName);
            }
        }
    }

    private static final void responseBodyEnd$lambda-1(AAFOkHttpNetworkEventListener this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.doLogAction();
    }
}

