/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.lifecycle;

import android.app.Application;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.ProcessLifecycleOwner;
import android.content.Context;
import com.bihe0832.android.lib.aaf.tools.AAFException;
import com.bihe0832.android.lib.config.Config;
import com.bihe0832.android.lib.lifecycle.ActivityObserver;
import com.bihe0832.android.lib.lifecycle.ApplicationObserver;
import com.bihe0832.android.lib.lifecycle.LifecycleHelper;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u001eH\u0002J\u0016\u0010\u001f\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eH\u0002J\u0006\u0010 \u001a\u00020\u0006J\u0006\u0010!\u001a\u00020\u0006J\u0006\u0010\"\u001a\u00020\u0006J\u0006\u0010#\u001a\u00020\u0006J\u0006\u0010$\u001a\u00020\u0012J\u0006\u0010%\u001a\u00020\u0012J\u0006\u0010&\u001a\u00020\u0006J\u0006\u0010'\u001a\u00020\u0012J\u0006\u0010(\u001a\u00020\u0006J\u000e\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+J\u0018\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\bJ \u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+2\u0006\u0010-\u001a\u00020\u000f2\b\u0010,\u001a\u0004\u0018\u00010\bJ\u000e\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0006J\b\u00100\u001a\u00020\u0019H\u0002J\b\u00101\u001a\u00020\u0019H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\r\u001a\u0004\b\u0011\u0010\u0013R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/bihe0832/android/lib/lifecycle/LifecycleHelper;", "", "()V", "applicationContext", "Landroid/content/Context;", "currentStartTime", "", "currentTimeInterface", "Lcom/bihe0832/android/lib/lifecycle/LifecycleHelper$ZixieTimeInterface;", "currentVersion", "getCurrentVersion", "()J", "currentVersion$delegate", "Lkotlin/Lazy;", "hasInit", "", "hasUpdatedStartTime", "isFirstStart", "", "()I", "isFirstStart$delegate", "lastStartTime", "lastStartVersion", "recordUsedInfo", "addValueOnce", "", "key", "", "doActionWithCheck", "action", "Lkotlin/Function0;", "doActionWithCheckReturnLong", "getAPPCurrentStartTime", "getAPPInstalledTime", "getAPPLastStartTime", "getAPPLastVersion", "getAPPUsedDays", "getAPPUsedTimes", "getCurrentTime", "getCurrentVersionUsedTimes", "getVersionInstalledTime", "init", "application", "Landroid/app/Application;", "timeInterface", "needRecord", "updateAPPCurrentStartTime", "offset", "updateNewVersion", "updateUsedInfo", "ZixieTimeInterface", "LibLifecycle_release"})
public final class LifecycleHelper {
    private static Context applicationContext;
    private static boolean hasInit;
    private static long lastStartVersion;
    private static long lastStartTime;
    private static long currentStartTime;
    private static boolean recordUsedInfo;
    private static final Lazy currentVersion$delegate;
    private static ZixieTimeInterface currentTimeInterface;
    private static boolean hasUpdatedStartTime;
    @NotNull
    private static final Lazy isFirstStart$delegate;
    public static final LifecycleHelper INSTANCE;

    private final long getCurrentVersion() {
        Lazy lazy = currentVersion$delegate;
        LifecycleHelper lifecycleHelper = this;
        Object var3_3 = null;
        boolean bl = false;
        return ((Number)lazy.getValue()).longValue();
    }

    public final synchronized void init(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        this.init(application, true, null);
    }

    public final synchronized void init(@NotNull Application application, @Nullable ZixieTimeInterface timeInterface) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        this.init(application, true, timeInterface);
    }

    public final synchronized void init(@NotNull Application application, boolean needRecord, @Nullable ZixieTimeInterface timeInterface) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        applicationContext = application.getApplicationContext();
        currentTimeInterface = timeInterface;
        recordUsedInfo = needRecord;
        if (!hasInit) {
            currentStartTime = this.getCurrentTime();
            LifecycleOwner lifecycleOwner = ProcessLifecycleOwner.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)lifecycleOwner, (String)"ProcessLifecycleOwner.get()");
            lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)ApplicationObserver.INSTANCE);
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)ActivityObserver.INSTANCE);
            if (recordUsedInfo) {
                if (Config.hasInit()) {
                    lastStartVersion = Config.readConfig((String)"zixieLastStartedVersion", (long)0L);
                    lastStartTime = Config.readConfig((String)"zixieAppLastStartTime", (long)0L);
                    this.updateNewVersion();
                    this.updateUsedInfo();
                } else {
                    throw (Throwable)new AAFException("please please init Config module first");
                }
            }
        }
    }

    public final long getCurrentTime() {
        ZixieTimeInterface zixieTimeInterface = currentTimeInterface;
        return zixieTimeInterface != null ? zixieTimeInterface.getCurrentTime() : System.currentTimeMillis();
    }

    public final long getAPPCurrentStartTime() {
        return currentStartTime;
    }

    public final void updateAPPCurrentStartTime(long offset) {
        currentStartTime += offset;
        if (hasUpdatedStartTime) {
            throw (Throwable)new AAFException("please check start time has updated more once");
        }
        hasUpdatedStartTime = true;
    }

    public final long getAPPInstalledTime() {
        return this.doActionWithCheckReturnLong((Function0<Long>)((Function0)getAPPInstalledTime.1.INSTANCE));
    }

    public final long getVersionInstalledTime() {
        return this.doActionWithCheckReturnLong((Function0<Long>)((Function0)getVersionInstalledTime.1.INSTANCE));
    }

    public final long getAPPLastStartTime() {
        return this.doActionWithCheckReturnLong((Function0<Long>)((Function0)getAPPLastStartTime.1.INSTANCE));
    }

    public final long getAPPLastVersion() {
        return this.doActionWithCheckReturnLong((Function0<Long>)((Function0)getAPPLastVersion.1.INSTANCE));
    }

    public final int getAPPUsedDays() {
        return (int)this.doActionWithCheckReturnLong((Function0<Long>)((Function0)getAPPUsedDays.1.INSTANCE));
    }

    public final int getAPPUsedTimes() {
        return (int)this.doActionWithCheckReturnLong((Function0<Long>)((Function0)getAPPUsedTimes.1.INSTANCE));
    }

    public final int getCurrentVersionUsedTimes() {
        return (int)this.doActionWithCheckReturnLong((Function0<Long>)((Function0)getCurrentVersionUsedTimes.1.INSTANCE));
    }

    private final void updateNewVersion() {
        this.doActionWithCheck((Function0<Unit>)((Function0)updateNewVersion.1.INSTANCE));
    }

    private final void updateUsedInfo() {
        this.doActionWithCheck((Function0<Unit>)((Function0)updateUsedInfo.1.INSTANCE));
    }

    public final int isFirstStart() {
        Lazy lazy = isFirstStart$delegate;
        LifecycleHelper lifecycleHelper = this;
        Object var3_3 = null;
        boolean bl = false;
        return ((Number)lazy.getValue()).intValue();
    }

    private final void addValueOnce(String key) {
        Config.writeConfig((String)key, (int)(Config.readConfig((String)key, (int)0) + 1));
    }

    private final void doActionWithCheck(Function0<Unit> action) {
        if (!recordUsedInfo) {
            throw (Throwable)new AAFException("LifecycleHelper has closed record used info");
        }
        action.invoke();
    }

    private final long doActionWithCheckReturnLong(Function0<Long> action) {
        if (recordUsedInfo) {
            return ((Number)action.invoke()).longValue();
        }
        throw (Throwable)new AAFException("LifecycleHelper has closed record used info");
    }

    private LifecycleHelper() {
    }

    static {
        LifecycleHelper lifecycleHelper;
        INSTANCE = lifecycleHelper = new LifecycleHelper();
        recordUsedInfo = true;
        currentVersion$delegate = LazyKt.lazy((Function0)currentVersion.2.INSTANCE);
        isFirstStart$delegate = LazyKt.lazy((Function0)isFirstStart.2.INSTANCE);
    }

    public static final /* synthetic */ long access$getLastStartTime$p(LifecycleHelper $this) {
        LifecycleHelper lifecycleHelper = $this;
        return lastStartTime;
    }

    public static final /* synthetic */ void access$setLastStartTime$p(LifecycleHelper $this, long l) {
        LifecycleHelper lifecycleHelper = $this;
        lastStartTime = l;
    }

    public static final /* synthetic */ long access$getLastStartVersion$p(LifecycleHelper $this) {
        LifecycleHelper lifecycleHelper = $this;
        return lastStartVersion;
    }

    public static final /* synthetic */ void access$setLastStartVersion$p(LifecycleHelper $this, long l) {
        LifecycleHelper lifecycleHelper = $this;
        lastStartVersion = l;
    }

    public static final /* synthetic */ long access$getCurrentVersion$p(LifecycleHelper $this) {
        return $this.getCurrentVersion();
    }

    public static final /* synthetic */ long access$getCurrentStartTime$p(LifecycleHelper $this) {
        LifecycleHelper lifecycleHelper = $this;
        return currentStartTime;
    }

    public static final /* synthetic */ void access$setCurrentStartTime$p(LifecycleHelper $this, long l) {
        LifecycleHelper lifecycleHelper = $this;
        currentStartTime = l;
    }

    public static final /* synthetic */ void access$addValueOnce(LifecycleHelper $this, String key) {
        $this.addValueOnce(key);
    }

    public static final /* synthetic */ Context access$getApplicationContext$p(LifecycleHelper $this) {
        LifecycleHelper lifecycleHelper = $this;
        return applicationContext;
    }

    public static final /* synthetic */ void access$setApplicationContext$p(LifecycleHelper $this, Context context) {
        LifecycleHelper lifecycleHelper = $this;
        applicationContext = context;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/bihe0832/android/lib/lifecycle/LifecycleHelper$ZixieTimeInterface;", "", "getCurrentTime", "", "LibLifecycle_release"})
    public static interface ZixieTimeInterface {
        public long getCurrentTime();
    }
}

