/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.network.ping;

import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.network.ping.PingThreshold;
import com.bihe0832.android.lib.network.ping.PingUtil;

public class PingResult {
    public String addr;
    public int avgDelay;
    public int min = Integer.MAX_VALUE;
    public int max = Integer.MIN_VALUE;
    public double lossRate;
    public double highDelayRate;
    public int numSent = 0;
    public int numReceived = 0;
    public int numHighDelay = 0;
    public int sumDelay = 0;
    public boolean isPingRouter = false;
    public String pingResultDesc = "";
    public int pingResultFlag = -1;
    private final String STATUS_ROUTER_WEEK = "\u8def\u7531\u5668\u4e0d\u7a33\u5b9a";
    private final String STATUS_ROUTER_NORMAL = "\u8def\u7531\u5668\u7a33\u5b9a";

    public PingResult(String _addr, int _avgDelay, double _lossRate, boolean _isPingRouter) {
        if (_addr == null || _addr.trim().equals("")) {
            ZLog.d((String)"PingResult\u7684\u6784\u9020\u51fd\u6570\u4f20\u5165\u4e86\u7a7aIP\u5730\u5740");
        } else {
            this.addr = _addr.trim();
        }
        this.avgDelay = _avgDelay;
        this.lossRate = _lossRate;
        this.isPingRouter = _isPingRouter;
    }

    public PingResult(String _addr, int _avgDelay, double _lossRate, double _highDelayRate, boolean _isPingRouter) {
        if (_addr == null || _addr.trim().equals("")) {
            ZLog.d((String)"PingResult\u7684\u6784\u9020\u51fd\u6570\u4f20\u5165\u4e86\u7a7aIP\u5730\u5740");
        } else {
            this.addr = _addr.trim();
        }
        this.avgDelay = _avgDelay;
        this.lossRate = _lossRate;
        this.highDelayRate = _highDelayRate;
        this.isPingRouter = _isPingRouter;
    }

    public void freshStat(PingThreshold pingThreshold) {
        this.avgDelay = this.sumDelay / this.numSent;
        this.highDelayRate = 100.0 * ((double)this.numHighDelay / (double)this.numSent);
        this.lossRate = 100.0 * ((double)(this.numSent - this.numReceived) / (double)this.numSent);
        if (this.isPingRouter) {
            this.pingResultDesc = this.getPingResultDesc(pingThreshold);
        }
    }

    private String getPingResultDesc(PingThreshold pingThreshold) {
        if (this.avgDelay >= pingThreshold.getAvgMax() || PingUtil.compareDouble(this.highDelayRate, pingThreshold.getHighDelayRateMax()) >= 0 || PingUtil.compareDouble(this.lossRate, pingThreshold.getLossRateMax()) >= 0) {
            this.pingResultFlag = 2;
            return this.STATUS_ROUTER_WEEK;
        }
        this.pingResultFlag = 1;
        return this.STATUS_ROUTER_NORMAL;
    }
}

