/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.UserHandle;
import android.os.ZygoteStartFailedEx;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;

public class Process {
    public static final String LOG_TAG = "Process";
    public static final String ZYGOTE_SOCKET = "zygote";
    public static final String ANDROID_SHARED_MEDIA = "com.android.process.media";
    public static final String GOOGLE_SHARED_APP_CONTENT = "com.google.process.content";
    public static final int SYSTEM_UID = 1000;
    public static final int PHONE_UID = 1001;
    public static final int SHELL_UID = 2000;
    public static final int LOG_UID = 1007;
    public static final int WIFI_UID = 1010;
    public static final int MEDIA_UID = 1013;
    public static final int DRM_UID = 1019;
    public static final int VPN_UID = 1016;
    public static final int NFC_UID = 1027;
    public static final int BLUETOOTH_UID = 1002;
    public static final int MEDIA_RW_GID = 1023;
    public static final int PACKAGE_INFO_GID = 1032;
    public static final int FIRST_APPLICATION_UID = 10000;
    public static final int LAST_APPLICATION_UID = 19999;
    public static final int FIRST_ISOLATED_UID = 99000;
    public static final int LAST_ISOLATED_UID = 99999;
    public static final int FIRST_SHARED_APPLICATION_GID = 50000;
    public static final int LAST_SHARED_APPLICATION_GID = 59999;
    public static final int THREAD_PRIORITY_DEFAULT = 0;
    public static final int THREAD_PRIORITY_LOWEST = 19;
    public static final int THREAD_PRIORITY_BACKGROUND = 10;
    public static final int THREAD_PRIORITY_FOREGROUND = -2;
    public static final int THREAD_PRIORITY_DISPLAY = -4;
    public static final int THREAD_PRIORITY_URGENT_DISPLAY = -8;
    public static final int THREAD_PRIORITY_AUDIO = -16;
    public static final int THREAD_PRIORITY_URGENT_AUDIO = -19;
    public static final int THREAD_PRIORITY_MORE_FAVORABLE = -1;
    public static final int THREAD_PRIORITY_LESS_FAVORABLE = 1;
    public static final int SCHED_OTHER = 0;
    public static final int SCHED_FIFO = 1;
    public static final int SCHED_RR = 2;
    public static final int SCHED_BATCH = 3;
    public static final int SCHED_IDLE = 5;
    public static final int THREAD_GROUP_DEFAULT = -1;
    public static final int THREAD_GROUP_BG_NONINTERACTIVE = 0;
    public static final int THREAD_GROUP_FOREGROUND = 1;
    public static final int THREAD_GROUP_SYSTEM = 2;
    public static final int THREAD_GROUP_AUDIO_APP = 3;
    public static final int THREAD_GROUP_AUDIO_SYS = 4;
    public static final int SIGNAL_QUIT = 3;
    public static final int SIGNAL_KILL = 9;
    public static final int SIGNAL_USR1 = 10;
    static LocalSocket sZygoteSocket;
    static DataInputStream sZygoteInputStream;
    static BufferedWriter sZygoteWriter;
    static boolean sPreviousZygoteOpenFailed;
    static final int ZYGOTE_RETRY_MILLIS = 500;
    public static final int PROC_TERM_MASK = 255;
    public static final int PROC_ZERO_TERM = 0;
    public static final int PROC_SPACE_TERM = 32;
    public static final int PROC_TAB_TERM = 9;
    public static final int PROC_COMBINE = 256;
    public static final int PROC_PARENS = 512;
    public static final int PROC_QUOTES = 1024;
    public static final int PROC_OUT_STRING = 4096;
    public static final int PROC_OUT_LONG = 8192;
    public static final int PROC_OUT_FLOAT = 16384;

    public static final ProcessStartResult start(String processClass, String niceName, int uid, int gid, int[] gids, int debugFlags, int mountExternal, int targetSdkVersion, String seInfo, String[] zygoteArgs) {
        try {
            return Process.startViaZygote(processClass, niceName, uid, gid, gids, debugFlags, mountExternal, targetSdkVersion, seInfo, zygoteArgs);
        }
        catch (ZygoteStartFailedEx ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void openZygoteSocketIfNeeded() throws ZygoteStartFailedEx {
        int retryCount = sPreviousZygoteOpenFailed ? 0 : 10;
        for (int retry = 0; sZygoteSocket == null && retry < retryCount + 1; ++retry) {
            if (retry > 0) {
                try {
                    Log.i((String)"Zygote", (String)"Zygote not up yet, sleeping...");
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                sZygoteSocket = new LocalSocket();
                sZygoteSocket.connect(new LocalSocketAddress(ZYGOTE_SOCKET, LocalSocketAddress.Namespace.RESERVED));
                sZygoteInputStream = new DataInputStream(sZygoteSocket.getInputStream());
                sZygoteWriter = new BufferedWriter(new OutputStreamWriter(sZygoteSocket.getOutputStream()), 256);
                Log.i((String)"Zygote", (String)"Process: zygote socket opened");
                sPreviousZygoteOpenFailed = false;
                break;
            }
            catch (IOException ex) {
                if (sZygoteSocket != null) {
                    try {
                        sZygoteSocket.close();
                    }
                    catch (IOException ex2) {
                        Log.e((String)LOG_TAG, (String)"I/O exception on close after exception", (Throwable)ex2);
                    }
                }
                sZygoteSocket = null;
                continue;
            }
        }
        if (sZygoteSocket == null) {
            sPreviousZygoteOpenFailed = true;
            throw new ZygoteStartFailedEx("connect failed");
        }
    }

    public static ProcessStartResult zygoteSendArgsAndGetResult(ArrayList<String> args) throws ZygoteStartFailedEx {
        Process.openZygoteSocketIfNeeded();
        try {
            sZygoteWriter.write(Integer.toString(args.size()));
            sZygoteWriter.newLine();
            int sz = args.size();
            for (int i = 0; i < sz; ++i) {
                String arg = args.get(i);
                if (arg.indexOf(10) >= 0) {
                    throw new ZygoteStartFailedEx("embedded newlines not allowed");
                }
                sZygoteWriter.write(arg);
                sZygoteWriter.newLine();
            }
            sZygoteWriter.flush();
            ProcessStartResult result = new ProcessStartResult();
            result.pid = sZygoteInputStream.readInt();
            if (result.pid < 0) {
                throw new ZygoteStartFailedEx("fork() failed");
            }
            result.usingWrapper = sZygoteInputStream.readBoolean();
            return result;
        }
        catch (IOException ex) {
            try {
                if (sZygoteSocket != null) {
                    sZygoteSocket.close();
                }
            }
            catch (IOException ex2) {
                Log.e((String)LOG_TAG, (String)"I/O exception on routine close", (Throwable)ex2);
            }
            sZygoteSocket = null;
            throw new ZygoteStartFailedEx(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessStartResult startViaZygote(String processClass, String niceName, int uid, int gid, int[] gids, int debugFlags, int mountExternal, int targetSdkVersion, String seInfo, String[] extraArgs) throws ZygoteStartFailedEx {
        Class<Process> clazz = Process.class;
        synchronized (Process.class) {
            ArrayList<String> argsForZygote = new ArrayList<String>();
            // ** MonitorExit[var10_10] (shouldn't be in output)
            return Process.zygoteSendArgsAndGetResult(argsForZygote);
        }
    }

    public static final native long getElapsedCpuTime();

    public static final int myPid() {
        return 0;
    }

    public static final int myPpid() {
        return 0;
    }

    public static final int myTid() {
        return 0;
    }

    public static final int myUid() {
        return 0;
    }

    public static final UserHandle myUserHandle() {
        return new UserHandle(null);
    }

    public static final boolean isIsolated() {
        return true;
    }

    public static final native int getUidForName(String var0);

    public static final native int getGidForName(String var0);

    public static final int getUidForPid(int pid) {
        String[] procStatusLabels = new String[]{"Uid:"};
        long[] procStatusValues = new long[]{-1L};
        Process.readProcLines("/proc/" + pid + "/status", procStatusLabels, procStatusValues);
        return (int)procStatusValues[0];
    }

    public static final int getParentPid(int pid) {
        String[] procStatusLabels = new String[]{"PPid:"};
        long[] procStatusValues = new long[]{-1L};
        Process.readProcLines("/proc/" + pid + "/status", procStatusLabels, procStatusValues);
        return (int)procStatusValues[0];
    }

    public static final int getThreadGroupLeader(int tid) {
        String[] procStatusLabels = new String[]{"Tgid:"};
        long[] procStatusValues = new long[]{-1L};
        Process.readProcLines("/proc/" + tid + "/status", procStatusLabels, procStatusValues);
        return (int)procStatusValues[0];
    }

    public static final native void setThreadPriority(int var0, int var1) throws IllegalArgumentException, SecurityException;

    public static final native void setCanSelfBackground(boolean var0);

    public static final native void setThreadGroup(int var0, int var1) throws IllegalArgumentException, SecurityException;

    public static final native void setProcessGroup(int var0, int var1) throws IllegalArgumentException, SecurityException;

    public static final native int getProcessGroup(int var0) throws IllegalArgumentException, SecurityException;

    public static final native void setThreadPriority(int var0) throws IllegalArgumentException, SecurityException;

    public static final native int getThreadPriority(int var0) throws IllegalArgumentException;

    public static final native void setThreadScheduler(int var0, int var1, int var2) throws IllegalArgumentException;

    @Deprecated
    public static final boolean supportsProcesses() {
        return true;
    }

    public static final native boolean setOomAdj(int var0, int var1);

    public static final native boolean setSwappiness(int var0, boolean var1);

    public static final native void setArgV0(String var0);

    public static final void killProcess(int pid) {
        Process.sendSignal(pid, 9);
    }

    public static final native int setUid(int var0);

    public static final native int setGid(int var0);

    public static final native void sendSignal(int var0, int var1);

    public static final void killProcessQuiet(int pid) {
        Process.sendSignalQuiet(pid, 9);
    }

    public static final native void sendSignalQuiet(int var0, int var1);

    public static final native long getFreeMemory();

    public static final native long getTotalMemory();

    public static final native void readProcLines(String var0, String[] var1, long[] var2);

    public static final native int[] getPids(String var0, int[] var1);

    public static final native boolean readProcFile(String var0, int[] var1, String[] var2, long[] var3, float[] var4);

    public static final native boolean parseProcLine(byte[] var0, int var1, int var2, int[] var3, String[] var4, long[] var5, float[] var6);

    public static final native int[] getPidsForCommands(String[] var0);

    public static final native long getPss(int var0);

    public static final class ProcessStartResult {
        public int pid;
        public boolean usingWrapper;
    }
}

