/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class ReflectPackageParser {
    public static final int INSTALL_SUCCEEDED = 1;
    public static final int INSTALL_FAILED_INVALID_APK = -2;
    public static final int INSTALL_FAILED_INVALID_URI = -3;
    public static final int INSTALL_FAILED_INSUFFICIENT_STORAGE = -4;
    public static final int INSTALL_FAILED_DUPLICATE_PACKAGE = -5;
    public static final int INSTALL_FAILED_NO_SHARED_USER = -6;
    public static final int INSTALL_FAILED_UPDATE_INCOMPATIBLE = -7;
    public static final int INSTALL_FAILED_SHARED_USER_INCOMPATIBLE = -8;
    public static final int INSTALL_FAILED_MISSING_SHARED_LIBRARY = -9;
    public static final int INSTALL_FAILED_REPLACE_COULDNT_DELETE = -10;
    public static final int INSTALL_FAILED_DEXOPT = -11;
    public static final int INSTALL_FAILED_OLDER_SDK = -12;
    public static final int INSTALL_FAILED_CONFLICTING_PROVIDER = -13;
    public static final int INSTALL_FAILED_NEWER_SDK = -14;
    public static final int INSTALL_FAILED_TEST_ONLY = -15;
    public static final int INSTALL_FAILED_CPU_ABI_INCOMPATIBLE = -16;
    public static final int INSTALL_FAILED_MISSING_FEATURE = -17;
    public static final int INSTALL_FAILED_CONTAINER_ERROR = -18;
    public static final int INSTALL_FAILED_INVALID_INSTALL_LOCATION = -19;
    public static final int INSTALL_FAILED_MEDIA_UNAVAILABLE = -20;
    public static final int INSTALL_FAILED_VERIFICATION_TIMEOUT = -21;
    public static final int INSTALL_FAILED_VERIFICATION_FAILURE = -22;
    public static final int INSTALL_FAILED_PACKAGE_CHANGED = -23;
    public static final int INSTALL_PARSE_FAILED_NOT_APK = -100;
    public static final int INSTALL_PARSE_FAILED_BAD_MANIFEST = -101;
    public static final int INSTALL_PARSE_FAILED_UNEXPECTED_EXCEPTION = -102;
    public static final int INSTALL_PARSE_FAILED_NO_CERTIFICATES = -103;
    public static final int INSTALL_PARSE_FAILED_INCONSISTENT_CERTIFICATES = -104;
    public static final int INSTALL_PARSE_FAILED_CERTIFICATE_ENCODING = -105;
    public static final int INSTALL_PARSE_FAILED_BAD_PACKAGE_NAME = -106;
    public static final int INSTALL_PARSE_FAILED_BAD_SHARED_USER_ID = -107;
    public static final int INSTALL_PARSE_FAILED_MANIFEST_MALFORMED = -108;
    public static final int INSTALL_PARSE_FAILED_MANIFEST_EMPTY = -109;
    public static final int INSTALL_FAILED_INTERNAL_ERROR = -110;
    public int err = 1;
    public Class cls = null;
    public Constructor con = null;
    public Method p_method = null;
    public Resources res = null;
    public AssetManager assmgr = null;

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.assmgr != null) {
            this.assmgr.close();
        }
    }

    public PackageInfo parserPcakge(String path, int flag) throws Exception {
        Field field2;
        Object o;
        ArrayList requestedPermissions;
        this.err = 1;
        if (this.cls == null) {
            this.cls = Class.forName("android.content.pm.PackageParser");
        }
        if (this.con == null) {
            this.con = this.cls.getConstructor(String.class);
        }
        if (this.p_method == null) {
            this.p_method = this.cls.getDeclaredMethod("parsePackage", File.class, String.class, DisplayMetrics.class, Integer.TYPE);
        }
        Object obj = this.con.newInstance(path);
        Method me_get = this.cls.getMethod("getParseError", new Class[0]);
        DisplayMetrics metrics = new DisplayMetrics();
        metrics.setToDefaults();
        Object obj_res = null;
        try {
            obj_res = this.p_method.invoke(obj, new File(path), path, metrics, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.err = (Integer)me_get.invoke(obj, new Object[0]);
        if (obj_res == null) {
            return null;
        }
        Class<?> cl = obj_res.getClass();
        Field field = cl.getDeclaredField("applicationInfo");
        Field field_versionName = cl.getDeclaredField("mVersionName");
        Field field_versionCode = cl.getDeclaredField("mVersionCode");
        ApplicationInfo ai = (ApplicationInfo)field.get(obj_res);
        String version = (String)field_versionName.get(obj_res);
        int version_code = field_versionCode.getInt(obj_res);
        PackageInfo info = new PackageInfo();
        info.applicationInfo = ai;
        info.versionName = version;
        info.versionCode = version_code;
        info.packageName = ai.packageName;
        if ((flag & 0x1000) > 0 && (requestedPermissions = (ArrayList)(o = (field2 = cl.getDeclaredField("requestedPermissions")).get(obj_res))) != null) {
            int size = requestedPermissions.size();
            if (size > 0) {
                info.requestedPermissions = new String[size];
            }
            for (int i = 0; i < size; ++i) {
                info.requestedPermissions[i] = (String)requestedPermissions.get(i);
            }
        }
        return info;
    }

    public String getString(Context context, String path, int id) throws Exception {
        if (this.res == null) {
            this.getResource(context, path);
        }
        if (this.res == null) {
            return null;
        }
        return this.res.getString(id);
    }

    public void close() {
        if (this.res != null) {
            this.res = null;
        }
        if (this.assmgr != null) {
            this.assmgr.close();
            this.assmgr = null;
        }
    }

    public Bitmap getDrawableBitmap(Context context, String path, int id) throws Exception {
        if (this.res == null) {
            this.getResource(context, path);
        }
        if (this.res == null) {
            return null;
        }
        Drawable icon = this.res.getDrawable(id);
        BitmapDrawable localBitmapDrawable = (BitmapDrawable)icon;
        Bitmap bitmap = localBitmapDrawable.getBitmap();
        return bitmap;
    }

    public byte[] getDrwableBites(Context context, String path, int id) throws Exception {
        Bitmap bitmap = this.getDrawableBitmap(context, path, id);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        byte[] bytes = baos.toByteArray();
        try {
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        bitmap.recycle();
        return bytes;
    }

    public ApplicationInfo parserPackage(String path) throws Exception {
        this.err = 1;
        if (this.cls == null) {
            this.cls = Class.forName("android.content.pm.PackageParser");
        }
        if (this.con == null) {
            this.con = this.cls.getConstructor(String.class);
        }
        if (this.p_method == null) {
            this.p_method = this.cls.getDeclaredMethod("parsePackage", File.class, String.class, DisplayMetrics.class, Integer.TYPE);
        }
        Object obj = this.con.newInstance(path);
        Method me_get = this.cls.getMethod("getParseError", new Class[0]);
        DisplayMetrics metrics = new DisplayMetrics();
        metrics.setToDefaults();
        Object obj_res = null;
        try {
            obj_res = this.p_method.invoke(obj, new File(path), path, metrics, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (obj_res == null) {
            this.err = (Integer)me_get.invoke(obj, new Object[0]);
            return null;
        }
        Class<?> cl = obj_res.getClass();
        Field field = cl.getDeclaredField("applicationInfo");
        ApplicationInfo info = (ApplicationInfo)field.get(obj_res);
        return info;
    }

    public void getResource(Context context, String path) throws Exception {
        if (this.res != null) {
            return;
        }
        Resources pRes = context.getResources();
        if (this.assmgr == null) {
            this.assmgr = (AssetManager)AssetManager.class.newInstance();
            Method method1 = AssetManager.class.getDeclaredMethod("addAssetPath", String.class);
            method1.invoke((Object)this.assmgr, path);
        }
        this.res = new Resources(this.assmgr, pRes.getDisplayMetrics(), pRes.getConfiguration());
    }

    public static Bitmap getResourceDrawable(Context context, String path, int id) throws Exception {
        if (id == 0) {
            return null;
        }
        Resources pRes = context.getResources();
        AssetManager assmgr = (AssetManager)AssetManager.class.newInstance();
        Method method1 = AssetManager.class.getDeclaredMethod("addAssetPath", String.class);
        method1.invoke((Object)assmgr, path);
        Resources res = new Resources(assmgr, pRes.getDisplayMetrics(), pRes.getConfiguration());
        Drawable icon = res.getDrawable(id);
        BitmapDrawable localBitmapDrawable = (BitmapDrawable)icon;
        Bitmap bitmap = localBitmapDrawable.getBitmap();
        assmgr.close();
        return bitmap;
    }

    public static Drawable getDrawable(Context context, String path, int id) throws Exception {
        if (id == 0) {
            return null;
        }
        Resources pRes = context.getResources();
        AssetManager assmgr = (AssetManager)AssetManager.class.newInstance();
        Method method1 = AssetManager.class.getDeclaredMethod("addAssetPath", String.class);
        method1.invoke((Object)assmgr, path);
        Resources res = new Resources(assmgr, pRes.getDisplayMetrics(), pRes.getConfiguration());
        Drawable icon = res.getDrawable(id);
        return icon;
    }

    public static byte[] getDrawableBytes(Context context, String path, int id) throws Exception {
        Bitmap bitmap = ReflectPackageParser.getResourceDrawable(context, path, id);
        if (bitmap == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        byte[] bytes = baos.toByteArray();
        try {
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        bitmap.recycle();
        return bytes;
    }
}

