/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ace.editor;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.view.ActionMode;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.webkit.ClientCertRequest;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.HttpAuthHandler;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.PermissionRequest;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.SafeBrowsingResponse;
import android.webkit.SslErrorHandler;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.RequiresApi;
import androidx.core.view.NestedScrollingChild;
import androidx.core.view.NestedScrollingChildHelper;
import com.bihe0832.android.lib.ace.editor.AceSelectionActionHelper;
import com.bihe0832.android.lib.ace.editor.R;
import com.bihe0832.android.lib.text.ClipboardUtil;
import com.bihe0832.android.lib.ui.view.ext.ViewExtKt;
import com.bihe0832.android.lib.utils.ConvertUtils;
import com.bihe0832.android.lib.utils.apk.APKUtils;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import com.bihe0832.android.lib.utils.os.DisplayUtil;

class AceWebView
extends WebView
implements NestedScrollingChild {
    private int[] mLastTouch = new int[2];
    private int mLastY;
    private long mLastTouchDownEvent;
    private boolean mHasMoveEvent;
    private final int[] mScrollOffset = new int[2];
    private final int[] mScrollConsumed = new int[2];
    private int mNestedOffsetY;
    private final int mActionModeOffsetLeft;
    private NestedScrollingChildHelper mChildHelper;
    private View.OnLongClickListener mWrappedLongClickListener = null;
    private final Handler mHandler;
    private WebChromeClient mWrappedWebChromeClient = new WebChromeClient();
    private WebViewClient mWrappedWebViewClient = new WebViewClient();
    private AceSelectionActionHelper mSelectionHelper;
    private final DisplayMetrics mMetrics;
    private final ClipboardManager mClipboard;
    private boolean mReadOnly;
    private boolean mHasPaste;
    private static final int SELECTION_CHANGED_MESSAGE = 0;
    private Selection mLastSelection;
    private boolean mSelectionEvent;
    private final WebChromeClient mWebChromeClient = new WebChromeClient(){

        public void onProgressChanged(WebView view, int newProgress) {
            AceWebView.this.mWrappedWebChromeClient.onProgressChanged(view, newProgress);
        }

        public void onReceivedTitle(WebView view, String title) {
            AceWebView.this.mWrappedWebChromeClient.onReceivedTitle(view, title);
        }

        public void onReceivedIcon(WebView view, Bitmap icon) {
            AceWebView.this.mWrappedWebChromeClient.onReceivedIcon(view, icon);
        }

        public void onReceivedTouchIconUrl(WebView view, String url, boolean precomposed) {
            AceWebView.this.mWrappedWebChromeClient.onReceivedTouchIconUrl(view, url, precomposed);
        }

        public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
            AceWebView.this.mWrappedWebChromeClient.onShowCustomView(view, callback);
        }

        public void onShowCustomView(View view, int requestedOrientation, WebChromeClient.CustomViewCallback callback) {
            AceWebView.this.mWrappedWebChromeClient.onShowCustomView(view, requestedOrientation, callback);
        }

        public void onHideCustomView() {
            AceWebView.this.mWrappedWebChromeClient.onHideCustomView();
        }

        public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
            return AceWebView.this.mWrappedWebChromeClient.onCreateWindow(view, isDialog, isUserGesture, resultMsg);
        }

        public void onRequestFocus(WebView view) {
            AceWebView.this.mWrappedWebChromeClient.onRequestFocus(view);
        }

        public void onCloseWindow(WebView window) {
            AceWebView.this.mWrappedWebChromeClient.onCloseWindow(window);
        }

        public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
            return AceWebView.this.mWrappedWebChromeClient.onJsAlert(view, url, message, result);
        }

        public boolean onJsConfirm(WebView view, String url, String message, JsResult result) {
            return AceWebView.this.mWrappedWebChromeClient.onJsConfirm(view, url, message, result);
        }

        public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
            return AceWebView.this.mWrappedWebChromeClient.onJsPrompt(view, url, message, defaultValue, result);
        }

        public boolean onJsBeforeUnload(WebView view, String url, String message, JsResult result) {
            return AceWebView.this.mWrappedWebChromeClient.onJsBeforeUnload(view, url, message, result);
        }

        public void onExceededDatabaseQuota(String url, String databaseIdentifier, long quota, long estimatedDatabaseSize, long totalQuota, WebStorage.QuotaUpdater quotaUpdater) {
            AceWebView.this.mWrappedWebChromeClient.onExceededDatabaseQuota(url, databaseIdentifier, quota, estimatedDatabaseSize, totalQuota, quotaUpdater);
        }

        public void onReachedMaxAppCacheSize(long requiredStorage, long quota, WebStorage.QuotaUpdater quotaUpdater) {
            AceWebView.this.mWrappedWebChromeClient.onReachedMaxAppCacheSize(requiredStorage, quota, quotaUpdater);
        }

        public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
            AceWebView.this.mWrappedWebChromeClient.onGeolocationPermissionsShowPrompt(origin, callback);
        }

        public void onGeolocationPermissionsHidePrompt() {
            AceWebView.this.mWrappedWebChromeClient.onGeolocationPermissionsHidePrompt();
        }

        @RequiresApi(api=21)
        public void onPermissionRequest(PermissionRequest request) {
            AceWebView.this.mWrappedWebChromeClient.onPermissionRequest(request);
        }

        @RequiresApi(api=21)
        public void onPermissionRequestCanceled(PermissionRequest request) {
            AceWebView.this.mWrappedWebChromeClient.onPermissionRequestCanceled(request);
        }

        public boolean onJsTimeout() {
            return AceWebView.this.mWrappedWebChromeClient.onJsTimeout();
        }

        public void onConsoleMessage(String message, int lineNumber, String sourceID) {
            AceWebView.this.filterAceMessage(message);
            AceWebView.this.mWrappedWebChromeClient.onConsoleMessage(message, lineNumber, sourceID);
        }

        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
            AceWebView.this.filterAceMessage(consoleMessage.message());
            return AceWebView.this.mWrappedWebChromeClient.onConsoleMessage(consoleMessage);
        }

        public Bitmap getDefaultVideoPoster() {
            return AceWebView.this.mWrappedWebChromeClient.getDefaultVideoPoster();
        }

        public View getVideoLoadingProgressView() {
            return AceWebView.this.mWrappedWebChromeClient.getVideoLoadingProgressView();
        }

        public void getVisitedHistory(ValueCallback<String[]> callback) {
            AceWebView.this.mWrappedWebChromeClient.getVisitedHistory(callback);
        }

        @TargetApi(value=21)
        public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
            return AceWebView.this.mWrappedWebChromeClient.onShowFileChooser(webView, filePathCallback, fileChooserParams);
        }
    };
    private final WebViewClient mWebViewClient = new WebViewClient(){

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return AceWebView.this.mWrappedWebViewClient.shouldOverrideUrlLoading(view, url);
        }

        @TargetApi(value=24)
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            return AceWebView.this.mWrappedWebViewClient.shouldOverrideUrlLoading(view, request);
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            if (Build.VERSION.SDK_INT < 19) {
                try {
                    Thread.sleep(350L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            AceWebView.this.mWrappedWebViewClient.onPageStarted(view, url, favicon);
        }

        public void onPageFinished(WebView view, String url) {
            AceWebView.this.mWrappedWebViewClient.onPageFinished(view, url);
        }

        public void onLoadResource(WebView view, String url) {
            AceWebView.this.mWrappedWebViewClient.onLoadResource(view, url);
        }

        @TargetApi(value=23)
        public void onPageCommitVisible(WebView view, String url) {
            AceWebView.this.mWrappedWebViewClient.onPageCommitVisible(view, url);
        }

        public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
            return AceWebView.this.mWrappedWebViewClient.shouldInterceptRequest(view, url);
        }

        @TargetApi(value=21)
        public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
            return AceWebView.this.mWrappedWebViewClient.shouldInterceptRequest(view, request);
        }

        public void onTooManyRedirects(WebView view, Message cancelMsg, Message continueMsg) {
            AceWebView.this.mWrappedWebViewClient.onTooManyRedirects(view, cancelMsg, continueMsg);
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            AceWebView.this.mWrappedWebViewClient.onReceivedError(view, errorCode, description, failingUrl);
        }

        @TargetApi(value=23)
        public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
            AceWebView.this.mWrappedWebViewClient.onReceivedError(view, request, error);
        }

        @TargetApi(value=23)
        public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
            AceWebView.this.mWrappedWebViewClient.onReceivedHttpError(view, request, errorResponse);
        }

        public void onFormResubmission(WebView view, Message dontResend, Message resend) {
            AceWebView.this.mWrappedWebViewClient.onFormResubmission(view, dontResend, resend);
        }

        public void doUpdateVisitedHistory(WebView view, String url, boolean isReload) {
            AceWebView.this.mWrappedWebViewClient.doUpdateVisitedHistory(view, url, isReload);
        }

        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
            AceWebView.this.mWrappedWebViewClient.onReceivedSslError(view, handler, error);
        }

        @TargetApi(value=21)
        public void onReceivedClientCertRequest(WebView view, ClientCertRequest request) {
            AceWebView.this.mWrappedWebViewClient.onReceivedClientCertRequest(view, request);
        }

        public void onReceivedHttpAuthRequest(WebView view, HttpAuthHandler handler, String host, String realm) {
            AceWebView.this.mWrappedWebViewClient.onReceivedHttpAuthRequest(view, handler, host, realm);
        }

        public boolean shouldOverrideKeyEvent(WebView view, KeyEvent event) {
            return AceWebView.this.mWrappedWebViewClient.shouldOverrideKeyEvent(view, event);
        }

        public void onUnhandledKeyEvent(WebView view, KeyEvent event) {
            AceWebView.this.mWrappedWebViewClient.onUnhandledKeyEvent(view, event);
        }

        public void onScaleChanged(WebView view, float oldScale, float newScale) {
            AceWebView.this.mWrappedWebViewClient.onScaleChanged(view, oldScale, newScale);
        }

        public void onReceivedLoginRequest(WebView view, String realm, String account, String args) {
            AceWebView.this.mWrappedWebViewClient.onReceivedLoginRequest(view, realm, account, args);
        }

        @TargetApi(value=26)
        public boolean onRenderProcessGone(WebView view, RenderProcessGoneDetail detail) {
            return AceWebView.this.mWrappedWebViewClient.onRenderProcessGone(view, detail);
        }

        @TargetApi(value=27)
        public void onSafeBrowsingHit(WebView view, WebResourceRequest request, int threatType, SafeBrowsingResponse callback) {
            AceWebView.this.mWrappedWebViewClient.onSafeBrowsingHit(view, request, threatType, callback);
        }
    };

    public AceWebView(Context context) {
        super(context);
        DisplayUtil.resetDensity((Activity)ViewExtKt.getActivity((View)this), (float)ConvertUtils.parseFloat((String)context.getResources().getString(R.string.custom_density), (float)360.0f));
        this.mMetrics = context.getResources().getDisplayMetrics();
        this.mActionModeOffsetLeft = (int)(64.0f * this.mMetrics.density);
        this.mClipboard = (ClipboardManager)context.getSystemService("clipboard");
        this.mChildHelper = new NestedScrollingChildHelper((View)this);
        this.mHandler = new Handler(new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                switch (msg.what) {
                    case 0: {
                        if (AceWebView.this.mSelectionHelper == null) break;
                        AceWebView.this.mSelectionEvent = true;
                        Rect r = new Rect();
                        AceWebView.this.getWindowVisibleDisplayFrame(r);
                        AceWebView.this.mLastSelection = (Selection)msg.obj;
                        boolean xVisible = !(((AceWebView)AceWebView.this).mLastSelection.x1 <= 0 && ((AceWebView)AceWebView.this).mLastSelection.x2 <= 0 || ((AceWebView)AceWebView.this).mLastSelection.x1 >= r.width() && ((AceWebView)AceWebView.this).mLastSelection.x2 >= r.width());
                        boolean yVisible = !(((AceWebView)AceWebView.this).mLastSelection.y1 <= 0 && ((AceWebView)AceWebView.this).mLastSelection.y2 <= 0 || ((AceWebView)AceWebView.this).mLastSelection.y1 >= r.height() && ((AceWebView)AceWebView.this).mLastSelection.y2 >= r.height());
                        AceWebView.this.mSelectionHelper.hasSelection(((AceWebView)AceWebView.this).mLastSelection.selected);
                        if ((((AceWebView)AceWebView.this).mLastSelection.selected || AceWebView.this.mHasPaste) && xVisible && yVisible) {
                            AceWebView.this.mSelectionHelper.show(AceWebView.this.getRootView(), Math.max(0, ((AceWebView)AceWebView.this).mLastSelection.x1 - AceWebView.this.mActionModeOffsetLeft), ((AceWebView)AceWebView.this).mLastSelection.y1);
                            break;
                        }
                        AceWebView.this.mSelectionHelper.dismiss();
                    }
                }
                return false;
            }
        });
        this.setNestedScrollingEnabled(true);
        this.initWebViewSettings();
    }

    private void initWebViewSettings() {
        if (BuildUtils.INSTANCE.getSDK_INT() >= 11) {
            this.removeJavascriptInterface("searchBoxJavaBridge_");
            this.removeJavascriptInterface("accessibility");
            this.removeJavascriptInterface("accessibilityTraversal");
            this.getSettings().setDisplayZoomControls(false);
        }
        this.setHTMLSupport(this.getSettings());
        this.resetCacheType(this.getSettings());
        if (Build.VERSION.SDK_INT >= 16) {
            this.configureActionMode();
        }
        super.setWebChromeClient(this.mWebChromeClient);
        super.setWebViewClient(this.mWebViewClient);
        this.setUserAgentSupport(this.getSettings());
    }

    private void setUserAgentSupport(WebSettings webSettings) {
        String userAgent = webSettings.getUserAgentString();
        String myAgent = " " + this.getUserAgentString();
        userAgent = TextUtils.isEmpty((CharSequence)userAgent) ? myAgent : (userAgent.endsWith("/") ? userAgent + myAgent : userAgent + "/" + myAgent);
        webSettings.setUserAgentString(userAgent);
    }

    protected String getUserAgentString() {
        return " ZixieVersion/" + APKUtils.getAppVersionName((Context)this.getContext()) + "/" + APKUtils.getAppVersionCode((Context)this.getContext()) + "/" + "android" + "/";
    }

    private void setHTMLSupport(WebSettings webSetting) {
        webSetting.setJavaScriptEnabled(true);
        webSetting.setAllowFileAccess(true);
        webSetting.setSupportMultipleWindows(false);
        webSetting.setPluginState(WebSettings.PluginState.ON_DEMAND);
        webSetting.setUseWideViewPort(true);
        webSetting.setLoadWithOverviewMode(true);
        if (BuildUtils.INSTANCE.getSDK_INT() > 21) {
            webSetting.setMixedContentMode(0);
        }
        webSetting.setSupportZoom(true);
        webSetting.setBuiltInZoomControls(true);
        webSetting.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        webSetting.supportMultipleWindows();
        webSetting.setNeedInitialFocus(true);
        webSetting.setJavaScriptCanOpenWindowsAutomatically(true);
        webSetting.setLoadsImagesAutomatically(true);
        webSetting.setDefaultTextEncodingName("UTF-8");
    }

    private void resetCacheType(WebSettings webSetting) {
        String cacheDirPath = this.getContext().getApplicationContext().getFilesDir().getAbsolutePath() + "/acewebcache";
        webSetting.setCacheMode(-1);
        webSetting.setDomStorageEnabled(true);
        webSetting.setDatabaseEnabled(true);
        webSetting.setDatabasePath(cacheDirPath);
        webSetting.setAppCachePath(cacheDirPath);
        webSetting.setAppCacheEnabled(true);
        webSetting.setAppCacheMaxSize(Long.MAX_VALUE);
    }

    @TargetApi(value=23)
    private void configureActionMode() {
        this.setClickable(false);
        this.setLongClickable(false);
        this.setHapticFeedbackEnabled(false);
        this.mSelectionHelper = new AceSelectionActionHelper(ViewExtKt.getActivity((View)this));
        this.mSelectionHelper.setOnSelectionItemPressedListener(new AceSelectionActionHelper.OnSelectionItemPressed(){

            @Override
            public void onSearchClick() {
                AceWebView.this.loadUrl("javascript: ace_get_selected_text('');");
            }

            @Override
            public void onSelectAllClick() {
                AceWebView.this.loadUrl("javascript: ace_select_all();");
            }

            @Override
            public void onPasteClick() {
                String s = new String(Base64.encode((byte[])ClipboardUtil.pasteFromClipboard((Context)AceWebView.this.getContext()).getBytes(), (int)2));
                AceWebView.this.loadUrl("javascript: ace_paste('" + s + "');");
            }

            @Override
            public void onCopyClick() {
                AceWebView.this.loadUrl("javascript: ace_copy(false);");
                AceWebView.this.mHasPaste = true;
            }

            @Override
            public void onCutClick() {
                AceWebView.this.loadUrl("javascript: ace_copy(true);");
                AceWebView.this.mHasPaste = true;
            }
        });
        super.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                AceWebView.this.showKeyboard();
                AceWebView.this.loadUrl("javascript: ace_request_focus();");
                AceWebView.this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        AceWebView.this.loadUrl("javascript: ace_select_word();");
                        AceWebView.this.requestFocus();
                    }
                }, 50L);
                AceWebView.this.mSelectionEvent = false;
                AceWebView.this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (!AceWebView.this.mSelectionEvent) {
                            AceWebView.this.showActionModeAtLastLocation();
                        }
                    }
                }, 450L);
                if (AceWebView.this.mWrappedLongClickListener != null) {
                    AceWebView.this.mWrappedLongClickListener.onLongClick(view);
                }
                return true;
            }
        });
    }

    void setReadOnly(boolean readOnly) {
        this.mReadOnly = readOnly;
        if (this.mSelectionHelper != null) {
            this.mSelectionHelper.setReadOnly(readOnly);
        }
    }

    public void setWebViewClient(WebViewClient client) {
        this.mWrappedWebViewClient = client;
    }

    public void setWebChromeClient(WebChromeClient client) {
        this.mWrappedWebChromeClient = client;
    }

    public final void setOnLongClickListener(View.OnLongClickListener l) {
        this.mWrappedLongClickListener = l;
    }

    public ActionMode startActionMode(ActionMode.Callback callback) {
        if (Build.VERSION.SDK_INT >= 16) {
            return null;
        }
        return super.startActionMode(callback);
    }

    public ActionMode startActionMode(ActionMode.Callback callback, int type) {
        if (Build.VERSION.SDK_INT >= 16) {
            return null;
        }
        return super.startActionMode(callback, type);
    }

    private boolean isKeyboardVisible() {
        Rect r = new Rect();
        this.getWindowVisibleDisplayFrame(r);
        return (float)this.getRootView().getHeight() - (float)r.height() / this.mMetrics.density > 200.0f;
    }

    public boolean dispatchKeyEventPreIme(KeyEvent event) {
        if (this.mSelectionHelper != null && this.mSelectionHelper.isShowing() && event.getKeyCode() == 4) {
            this.mHasPaste = true;
            this.mSelectionHelper.dismiss();
            return !this.isKeyboardVisible();
        }
        return super.dispatchKeyEventPreIme(event);
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        InputConnection inputConnection = super.onCreateInputConnection(outAttrs);
        outAttrs.imeOptions = 0;
        outAttrs.inputType = 0;
        return inputConnection;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent ev) {
        boolean returnValue = false;
        MotionEvent event = MotionEvent.obtain((MotionEvent)ev);
        int action = ev.getActionMasked();
        if (action == 0) {
            this.mNestedOffsetY = 0;
        }
        this.mLastTouch[0] = (int)event.getX();
        this.mLastTouch[1] = (int)event.getY();
        event.offsetLocation(0.0f, (float)this.mNestedOffsetY);
        switch (action) {
            case 2: {
                int deltaY = this.mLastY - this.mLastTouch[1];
                if (this.dispatchNestedPreScroll(0, deltaY, this.mScrollConsumed, this.mScrollOffset)) {
                    deltaY -= this.mScrollConsumed[1];
                    this.mLastY = this.mLastTouch[1] - this.mScrollOffset[1];
                    event.offsetLocation(0.0f, (float)(-this.mScrollOffset[1]));
                    this.mNestedOffsetY += this.mScrollOffset[1];
                }
                returnValue = super.onTouchEvent(event);
                if (this.dispatchNestedScroll(0, this.mScrollOffset[1], 0, deltaY, this.mScrollOffset)) {
                    event.offsetLocation(0.0f, (float)this.mScrollOffset[1]);
                    this.mNestedOffsetY += this.mScrollOffset[1];
                    this.mLastY -= this.mScrollOffset[1];
                }
                this.mHasMoveEvent = true;
                break;
            }
            case 0: {
                returnValue = super.onTouchEvent(event);
                this.mLastY = this.mLastTouch[1];
                this.startNestedScroll(2);
                this.mLastTouchDownEvent = System.currentTimeMillis();
                this.mHasMoveEvent = false;
                break;
            }
            case 1: 
            case 3: {
                long delta = System.currentTimeMillis() - this.mLastTouchDownEvent;
                returnValue = super.onTouchEvent(event);
                this.stopNestedScroll();
                if (this.mSelectionHelper != null && !this.mHasMoveEvent && delta < (long)ViewConfiguration.getTapTimeout() && this.mSelectionHelper.isShowing()) {
                    this.mSelectionHelper.dismiss();
                }
                if (this.mHasMoveEvent || action != 1) break;
                this.showKeyboard();
                if (!this.mHasPaste) break;
                this.mSelectionEvent = false;
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (!AceWebView.this.mSelectionEvent) {
                            AceWebView.this.showActionModeAtLastLocation();
                        }
                    }
                }, 450L);
            }
        }
        return returnValue;
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.mChildHelper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.mChildHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.mChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    private void showKeyboard() {
        InputMethodManager imm;
        if (!this.mReadOnly && (imm = (InputMethodManager)this.getContext().getSystemService("input_method")) != null) {
            imm.showSoftInput((View)this, 1);
        }
    }

    private void showActionModeAtLastLocation() {
        int[] xy = new int[2];
        this.getLocationOnScreen(xy);
        this.mSelectionHelper.show((View)this, xy[0] + this.mLastTouch[0] - this.mActionModeOffsetLeft, xy[1] + this.mLastTouch[1]);
    }

    private void filterAceMessage(String msg) {
        if (msg.startsWith("edt:s:")) {
            if (this.mSelectionHelper == null) {
                return;
            }
            String[] v = msg.replaceFirst("edt:s:", "").split(";");
            boolean selected = Boolean.valueOf(v[0]);
            int[] location = new int[2];
            this.getLocationInWindow(location);
            int screenX = Float.valueOf(v[1]).intValue();
            int screenY = Float.valueOf(v[2]).intValue();
            float padding = this.mMetrics.density * 0.2f / 3.5f;
            int x1 = Float.valueOf(v[3]).intValue();
            int y1 = Float.valueOf(v[4]).intValue() + (int)((float)Float.valueOf(v[7]).intValue() * padding);
            int x2 = Float.valueOf(v[5]).intValue();
            int y2 = Float.valueOf(v[6]).intValue() + (int)((float)Float.valueOf(v[9]).intValue() * padding);
            x1 = this.getRootView().getWidth() * x1 / screenX + location[0];
            y1 = this.getRootView().getHeight() * y1 / screenY + location[1] - this.mSelectionHelper.getDefaultHeight();
            x2 = this.getRootView().getWidth() * x2 / screenX + location[0];
            y2 = this.getRootView().getHeight() * y2 / screenY + location[1] - this.mSelectionHelper.getDefaultHeight();
            this.mHandler.removeMessages(0);
            Message message = Message.obtain((Handler)this.mHandler);
            message.what = 0;
            message.obj = new Selection(selected, x1, y1, x2, y2);
            message.sendToTarget();
        } else if (msg.startsWith("edt:copy:")) {
            String s = msg.replaceFirst("edt:copy:", "");
            if (!TextUtils.isEmpty((CharSequence)s)) {
                s = new String(Base64.decode((String)s, (int)2));
                ClipData clip = ClipData.newPlainText((CharSequence)((Object)((Object)this)).getClass().getSimpleName(), (CharSequence)s);
                this.mClipboard.setPrimaryClip(clip);
            }
        } else if (msg.startsWith("edt:seltext:")) {
            if (this.mSelectionHelper == null) {
                return;
            }
            String s = msg.replaceFirst("edt:seltext:", "");
            int action = Integer.valueOf(s.substring(0, s.indexOf(58)));
            if (!TextUtils.isEmpty((CharSequence)(s = s.substring(s.indexOf(58) + 1)))) {
                s = new String(Base64.decode((String)s, (int)2));
            } else {
                String string2 = "";
            }
        }
    }

    private static class Selection {
        final boolean selected;
        final int x1;
        final int y1;
        final int x2;
        final int y2;

        private Selection(boolean selected, int x1, int y1, int x2, int y2) {
            this.selected = selected;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }
    }
}

