/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.framework.log;

import android.text.TextUtils;
import com.bihe0832.android.framework.log.LoggerFile;
import com.bihe0832.android.lib.log.ZLog;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0006\u0010\u000b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0004J\u0006\u0010\u000e\u001a\u00020\tJ\u0006\u0010\u000f\u001a\u00020\tJ(\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0004J&\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0004J\u0016\u0010\u0015\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004J.\u0010\u0015\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/bihe0832/android/framework/log/LoggerTrace;", "", "()V", "TRACE_MODULE_NAME", "", "mTraceList", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/bihe0832/android/framework/log/LoggerTrace$LoggerInfo;", "logToFile", "", "msg", "openLog", "reset", "tag", "sendLog", "showResult", "currentInfo", "needLog", "", "needDuration", "needFile", "tracePoint", "info", "LoggerInfo", "Framework_release"})
public final class LoggerTrace {
    @NotNull
    public static final LoggerTrace INSTANCE = new LoggerTrace();
    @NotNull
    private static final String TRACE_MODULE_NAME = "Trace";
    @NotNull
    private static final CopyOnWriteArrayList<LoggerInfo> mTraceList = new CopyOnWriteArrayList();

    private LoggerTrace() {
    }

    private final void showResult(LoggerInfo currentInfo, boolean needLog, boolean needDuration, boolean needFile) {
        long duration;
        int index = mTraceList.indexOf(currentInfo);
        long l = duration = index > 0 ? currentInfo.getLogTime() - mTraceList.get(index - 1).getLogTime() : 0L;
        if (needFile) {
            this.logToFile("Action at " + currentInfo.getLogTime() + " used " + duration + " for " + currentInfo.getTag() + " ,msg is : " + currentInfo.getMsg());
        } else if (needDuration) {
            ZLog.d((String)TRACE_MODULE_NAME, (String)("Action at " + currentInfo.getLogTime() + " used " + duration + " for " + currentInfo.getTag() + " ,msg is : " + currentInfo.getMsg()));
        } else if (needLog) {
            ZLog.d((String)TRACE_MODULE_NAME, (String)("Action at " + currentInfo.getLogTime() + " for " + currentInfo.getTag() + " ,msg is : " + currentInfo.getMsg()));
        }
    }

    public final synchronized void tracePoint(@NotNull String tag, @NotNull String info, boolean needLog, boolean needDuration, boolean needFile) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        LoggerInfo it = new LoggerInfo(tag, info);
        boolean bl = false;
        mTraceList.add(it);
        INSTANCE.showResult(it, needLog, needDuration, needFile);
    }

    public final void showResult(@NotNull String tag, boolean needLog, boolean needDuration, boolean needFile) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        ZLog.d((String)TRACE_MODULE_NAME, (String)("------------------ Action showResult for " + tag + " start ------------------"));
        Iterable $this$forEach$iv = mTraceList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LoggerInfo it = (LoggerInfo)element$iv;
            boolean bl = false;
            if (TextUtils.isEmpty((CharSequence)tag)) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                INSTANCE.showResult(it, needLog, needDuration, needFile);
                continue;
            }
            if (!Intrinsics.areEqual((Object)tag, (Object)it.getTag())) continue;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            INSTANCE.showResult(it, needLog, needDuration, needFile);
        }
        ZLog.d((String)TRACE_MODULE_NAME, (String)("------------------ Action showResult for " + tag + " end ------------------"));
    }

    public final void tracePoint(@NotNull String tag, @NotNull String info) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.tracePoint(tag, info, false, true, false);
    }

    public final void tracePoint(@NotNull String info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.tracePoint("Default", info, false, true, false);
    }

    public final void showResult(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.showResult(tag, false, false, true);
    }

    public final void showResult() {
        this.showResult("", false, false, true);
    }

    public final synchronized void reset(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.showResult(tag, false, false, true);
        for (LoggerInfo num : mTraceList) {
            if (!Intrinsics.areEqual((Object)num.getTag(), (Object)tag)) continue;
            mTraceList.remove(num);
        }
    }

    private final void logToFile(String msg) {
        LoggerFile.INSTANCE.log(LoggerFile.INSTANCE.getZixieFileLogPathByModule(TRACE_MODULE_NAME), msg);
    }

    public final void openLog() {
        LoggerFile.INSTANCE.openLog(LoggerFile.INSTANCE.getZixieFileLogPathByModule(TRACE_MODULE_NAME));
    }

    public final void sendLog() {
        LoggerFile.INSTANCE.sendLog(LoggerFile.INSTANCE.getZixieFileLogPathByModule(TRACE_MODULE_NAME));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/bihe0832/android/framework/log/LoggerTrace$LoggerInfo;", "", "tag", "", "msg", "(Ljava/lang/String;Ljava/lang/String;)V", "logTime", "", "getLogTime", "()J", "setLogTime", "(J)V", "getMsg", "()Ljava/lang/String;", "setMsg", "(Ljava/lang/String;)V", "getTag", "setTag", "Framework_release"})
    private static final class LoggerInfo {
        @NotNull
        private String tag;
        @NotNull
        private String msg;
        private long logTime;

        public LoggerInfo(@NotNull String tag, @NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            this.tag = tag;
            this.msg = msg;
            this.logTime = System.currentTimeMillis();
        }

        public /* synthetic */ LoggerInfo(String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string2 = "";
            }
            if ((n & 2) != 0) {
                string3 = "";
            }
            this(string2, string3);
        }

        @NotNull
        public final String getTag() {
            return this.tag;
        }

        public final void setTag(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.tag = string2;
        }

        @NotNull
        public final String getMsg() {
            return this.msg;
        }

        public final void setMsg(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.msg = string2;
        }

        public final long getLogTime() {
            return this.logTime;
        }

        public final void setLogTime(long l) {
            this.logTime = l;
        }

        public LoggerInfo() {
            this(null, null, 3, null);
        }
    }
}

