/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.framework.router;

import android.content.Context;
import android.net.Uri;
import com.bihe0832.android.framework.log.LoggerFile;
import com.bihe0832.android.lib.router.RouterContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/bihe0832/android/framework/router/RouterInterrupt;", "", "()V", "MODULE_NAME_ROUTER", "", "getMODULE_NAME_ROUTER", "()Ljava/lang/String;", "getRouterLogPath", "init", "", "process", "Lcom/bihe0832/android/framework/router/RouterInterrupt$RouterProcess;", "logRouterToFile", "msg", "RouterProcess", "Framework_release"})
public final class RouterInterrupt {
    @NotNull
    private static final String MODULE_NAME_ROUTER = "Router";
    public static final RouterInterrupt INSTANCE;

    @NotNull
    public final String getMODULE_NAME_ROUTER() {
        return MODULE_NAME_ROUTER;
    }

    public final synchronized void init(@NotNull RouterProcess process) {
        Intrinsics.checkParameterIsNotNull((Object)process, (String)"process");
        RouterContext.INSTANCE.setGlobalRouterCallback(new RouterContext.RouterCallback(process){
            final /* synthetic */ RouterProcess $process;

            public void afterOpen(@NotNull Context context, @NotNull Uri uri) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
                this.$process.afterOpen(context, uri);
            }

            public boolean beforeOpen(@NotNull Context context, @NotNull Uri uri) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
                RouterInterrupt.INSTANCE.logRouterToFile("beforeOpen ->" + uri);
                if (this.$process.needInterrupt(uri) || this.$process.needLogin(uri)) {
                    RouterInterrupt.INSTANCE.logRouterToFile("needInterrupt uri ->" + uri);
                    bl = this.$process.doInterrupt(uri);
                } else {
                    bl = false;
                }
                return bl;
            }

            public void error(@NotNull Context context, @NotNull Uri uri, @NotNull Throwable e) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$process.error(context, uri, e);
            }

            public void notFound(@NotNull Context context, @NotNull Uri uri) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
                this.$process.notFound(context, uri);
            }
            {
                this.$process = $captured_local_variable$0;
            }
        });
    }

    public final void logRouterToFile(@NotNull String msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        LoggerFile.INSTANCE.log(this.getRouterLogPath(), msg);
    }

    @NotNull
    public final String getRouterLogPath() {
        return LoggerFile.INSTANCE.getZixieFileLogPathByModule(MODULE_NAME_ROUTER);
    }

    private RouterInterrupt() {
    }

    static {
        RouterInterrupt routerInterrupt;
        INSTANCE = routerInterrupt = new RouterInterrupt();
        MODULE_NAME_ROUTER = MODULE_NAME_ROUTER;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H&J \u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0018\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/bihe0832/android/framework/router/RouterInterrupt$RouterProcess;", "", "afterOpen", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "doInterrupt", "", "error", "e", "", "needInterrupt", "needLogin", "notFound", "Framework_release"})
    public static interface RouterProcess {
        public boolean needLogin(@NotNull Uri var1);

        public boolean needInterrupt(@NotNull Uri var1);

        public boolean doInterrupt(@NotNull Uri var1);

        public void afterOpen(@NotNull Context var1, @NotNull Uri var2);

        public void notFound(@NotNull Context var1, @NotNull Uri var2);

        public void error(@NotNull Context var1, @NotNull Uri var2, @NotNull Throwable var3);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void afterOpen(RouterProcess $this, @NotNull Context context, @NotNull Uri uri) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
                INSTANCE.logRouterToFile("afterOpen ->" + uri);
            }

            public static void notFound(RouterProcess $this, @NotNull Context context, @NotNull Uri uri) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
                INSTANCE.logRouterToFile("notFound ->" + uri);
            }

            public static void error(RouterProcess $this, @NotNull Context context, @NotNull Uri uri, @NotNull Throwable e) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                INSTANCE.logRouterToFile("error ->" + uri);
            }
        }
    }
}

