/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.common.debug.audio.card;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.bihe0832.android.common.debug.R;
import com.bihe0832.android.common.debug.audio.card.AudioData;
import com.bihe0832.android.lib.adapter.CardBaseHolder;
import com.bihe0832.android.lib.adapter.CardBaseModule;
import com.bihe0832.android.lib.audio.wav.WaveFileReader;
import com.bihe0832.android.lib.file.FileUtils;
import com.bihe0832.android.lib.utils.time.DateUtil;
import java.io.File;

public class AudioHolder
extends CardBaseHolder {
    public AudioHolder(View itemView, Context context) {
        super(itemView, context);
    }

    public void initView() {
    }

    @SuppressLint(value={"SetTextI18n"})
    public void initData(CardBaseModule item) {
        AudioData data = (AudioData)item;
        String filePath = data.filePath;
        File file = new File(filePath);
        String title = FileUtils.INSTANCE.getFileName(filePath) + "  |  " + DateUtil.getDateEN((long)file.lastModified());
        ((TextView)this.getView(R.id.audio_title)).setText((CharSequence)title);
        WaveFileReader waveFileReader = new WaveFileReader(filePath);
        if (waveFileReader.isSuccess()) {
            String fileLength = "\u6587\u4ef6\u5927\u5c0f\uff1a" + FileUtils.INSTANCE.getFileLength(file.length());
            ((TextView)this.getView(R.id.audio_desc)).setText((CharSequence)(fileLength + "\uff0c" + waveFileReader.toShowString() + "\uff0c" + data.amplitude));
            TextView result = (TextView)this.getView(R.id.audio_recognise);
            if (TextUtils.isEmpty((CharSequence)data.recogniseResult)) {
                result.setVisibility(8);
            } else {
                result.setText((CharSequence)data.recogniseResult);
                result.setVisibility(0);
            }
            this.addOnLongClickListener(R.id.audio_icon);
            this.addOnLongClickListener(R.id.audio_title);
            this.addOnLongClickListener(R.id.audio_desc);
            this.addOnClickListener(R.id.audio_icon);
            this.addOnClickListener(R.id.audio_title);
            this.addOnClickListener(R.id.audio_desc);
        } else {
            ((TextView)this.getView(R.id.audio_desc)).setText((CharSequence)"\u97f3\u9891\u6587\u4ef6\u5f02\u5e38\uff0c\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u97f3\u9891\u683c\u5f0f");
        }
    }
}

