/*
 * Decompiled with CFR 0.152.
 */
package com.bignerdranch.android.multiselector;

import android.animation.AnimatorInflater;
import android.animation.StateListAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.StateSet;
import android.util.TypedValue;
import android.view.View;
import com.bignerdranch.android.multiselector.MultiSelector;
import com.bignerdranch.android.multiselector.MultiSelectorBindingHolder;
import com.bignerdranch.android.multiselector.R;
import com.bignerdranch.android.multiselector.SelectableHolder;

public class SwappingHolder
extends MultiSelectorBindingHolder
implements SelectableHolder {
    private MultiSelector mMultiSelector;
    private boolean mIsSelectable = false;
    private Drawable mSelectionModeBackgroundDrawable;
    private Drawable mDefaultModeBackgroundDrawable;
    private StateListAnimator mSelectionModeStateListAnimator;
    private StateListAnimator mDefaultModeStateListAnimator;

    public SwappingHolder(View itemView, MultiSelector multiSelector) {
        super(itemView, multiSelector);
        this.mMultiSelector = multiSelector;
        if (Build.VERSION.SDK_INT >= 21) {
            this.setSelectionModeStateListAnimator(SwappingHolder.getRaiseStateListAnimator(itemView.getContext()));
            this.setDefaultModeStateListAnimator(itemView.getStateListAnimator());
        }
        this.setSelectionModeBackgroundDrawable(SwappingHolder.getAccentStateDrawable(itemView.getContext()));
        this.setDefaultModeBackgroundDrawable(itemView.getBackground());
    }

    public SwappingHolder(View itemView) {
        this(itemView, null);
    }

    private static Drawable getAccentStateDrawable(Context context) {
        TypedValue typedValue = new TypedValue();
        Resources.Theme theme = context.getTheme();
        theme.resolveAttribute(R.attr.colorAccent, typedValue, true);
        ColorDrawable colorDrawable = new ColorDrawable(typedValue.data);
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16843518}, (Drawable)colorDrawable);
        stateListDrawable.addState(StateSet.WILD_CARD, null);
        return stateListDrawable;
    }

    private static StateListAnimator getRaiseStateListAnimator(Context context) {
        if (Build.VERSION.SDK_INT >= 21) {
            return AnimatorInflater.loadStateListAnimator((Context)context, (int)R.anim.raise);
        }
        return null;
    }

    public Drawable getSelectionModeBackgroundDrawable() {
        return this.mSelectionModeBackgroundDrawable;
    }

    public void setSelectionModeBackgroundDrawable(Drawable selectionModeBackgroundDrawable) {
        this.mSelectionModeBackgroundDrawable = selectionModeBackgroundDrawable;
        if (this.mIsSelectable) {
            this.itemView.setBackgroundDrawable(selectionModeBackgroundDrawable);
        }
    }

    public Drawable getDefaultModeBackgroundDrawable() {
        return this.mDefaultModeBackgroundDrawable;
    }

    public void setDefaultModeBackgroundDrawable(Drawable defaultModeBackgroundDrawable) {
        this.mDefaultModeBackgroundDrawable = defaultModeBackgroundDrawable;
        if (!this.mIsSelectable) {
            this.itemView.setBackgroundDrawable(this.mDefaultModeBackgroundDrawable);
        }
    }

    public StateListAnimator getSelectionModeStateListAnimator() {
        return this.mSelectionModeStateListAnimator;
    }

    public void setSelectionModeStateListAnimator(StateListAnimator selectionModeStateListAnimator) {
        this.mSelectionModeStateListAnimator = selectionModeStateListAnimator;
    }

    public void setSelectionModeStateListAnimator(int resId) {
        if (Build.VERSION.SDK_INT >= 21) {
            StateListAnimator animator = AnimatorInflater.loadStateListAnimator((Context)this.itemView.getContext(), (int)resId);
            this.setSelectionModeStateListAnimator(animator);
        }
    }

    public StateListAnimator getDefaultModeStateListAnimator() {
        return this.mDefaultModeStateListAnimator;
    }

    public void setDefaultModeStateListAnimator(int resId) {
        if (Build.VERSION.SDK_INT >= 21) {
            StateListAnimator animator = AnimatorInflater.loadStateListAnimator((Context)this.itemView.getContext(), (int)resId);
            this.setDefaultModeStateListAnimator(animator);
        }
    }

    public void setDefaultModeStateListAnimator(StateListAnimator defaultModeStateListAnimator) {
        this.mDefaultModeStateListAnimator = defaultModeStateListAnimator;
    }

    @Override
    public boolean isActivated() {
        return this.itemView.isActivated();
    }

    @Override
    public void setActivated(boolean isActivated) {
        this.itemView.setActivated(isActivated);
    }

    @Override
    public boolean isSelectable() {
        return this.mIsSelectable;
    }

    @Override
    public void setSelectable(boolean isSelectable) {
        boolean changed = isSelectable != this.mIsSelectable;
        this.mIsSelectable = isSelectable;
        if (changed) {
            this.refreshChrome();
        }
    }

    private void refreshChrome() {
        Drawable backgroundDrawable = this.mIsSelectable ? this.mSelectionModeBackgroundDrawable : this.mDefaultModeBackgroundDrawable;
        this.itemView.setBackgroundDrawable(backgroundDrawable);
        if (backgroundDrawable != null) {
            backgroundDrawable.jumpToCurrentState();
        }
        if (Build.VERSION.SDK_INT >= 21) {
            StateListAnimator animator = this.mIsSelectable ? this.mSelectionModeStateListAnimator : this.mDefaultModeStateListAnimator;
            this.itemView.setStateListAnimator(animator);
            if (animator != null) {
                animator.jumpToCurrentState();
            }
        }
    }
}

