/*
 * Decompiled with CFR 0.152.
 */
package com.bigbangbutton.editcodeview;

import android.text.Editable;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import com.bigbangbutton.editcodeview.EditCodeView;

class EditCodeInputConnection
extends BaseInputConnection {
    private Editable editable;
    private int textLength;

    EditCodeInputConnection(View targetView, boolean fullEditor, int textLength) {
        super(targetView, fullEditor);
        EditCodeView view = (EditCodeView)targetView;
        this.textLength = textLength;
        this.editable = view.getEditable();
    }

    public Editable getEditable() {
        return this.editable;
    }

    public boolean sendKeyEvent(KeyEvent event) {
        if (event.getAction() == 0) {
            if (event.getKeyCode() >= 7 && event.getKeyCode() <= 16) {
                char c = event.getKeyCharacterMap().getNumber(event.getKeyCode());
                this.commitText(String.valueOf(c), 1);
            } else if (event.getKeyCode() == 67) {
                this.deleteSurroundingText(1, 0);
            }
        }
        return super.sendKeyEvent(event);
    }

    public boolean commitText(CharSequence text, int newCursorPosition) {
        return this.editable.length() + text.length() <= this.textLength && super.commitText(text.subSequence(0, 1), newCursorPosition);
    }

    public boolean setComposingText(CharSequence text, int newCursorPosition) {
        if (text.length() > this.textLength) {
            text = text.subSequence(0, this.textLength);
        }
        return super.setComposingText(text, newCursorPosition);
    }

    public boolean setComposingRegion(int start, int end) {
        return super.setComposingRegion(start, end);
    }

    public boolean finishComposingText() {
        return super.finishComposingText();
    }
}

