/*
 * Decompiled with CFR 0.152.
 */
package com.bigbangbutton.editcodeview;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import com.bigbangbutton.editcodeview.EditCodeInputConnection;
import com.bigbangbutton.editcodeview.EditCodeListener;
import com.bigbangbutton.editcodeview.EditCodeWatcher;
import com.bigbangbutton.editcodeview.R;

public class EditCodeView
extends View
implements View.OnClickListener,
View.OnFocusChangeListener {
    private static final int DEFAULT_CODE_LENGTH = 4;
    private static final String DEFAULT_CODE_MASK = "*";
    private static final String DEFAULT_CODE_SYMBOL = "0";
    private static final String DEFAULT_REGEX = "[^0-9]";
    private static final float DEFAULT_REDUCTION_SCALE = 0.5f;
    private final CodeTextWatcher textWatcher = new CodeTextWatcher();
    private InputMethodManager inputmethodmanager;
    private EditCodeInputConnection editCodeInputConnection;
    private EditCodeListener editCodeListener;
    private EditCodeWatcher editCodeWatcher;
    private Editable editable;
    private Paint textPaint;
    private Paint underlinePaint;
    private Paint cursorPaint;
    private float textSize;
    private float textPosY;
    private int textColor;
    private float sectionWidth;
    private int codeLength;
    private float symbolWidth;
    private float symbolMaskedWidth;
    private float underlineHorizontalPadding;
    private float underlineReductionScale;
    private float underlineStrokeWidth;
    private int underlineBaseColor;
    private int underlineSelectedColor;
    private int underlineFilledColor;
    private int underlineCursorColor;
    private float underlinePosY;
    private int fontStyle;
    private boolean cursorEnabled;
    private boolean codeHiddenMode;
    private boolean isSelected;
    private String codeHiddenMask;
    private Rect textBounds = new Rect();
    private Runnable cursorAnimation = new Runnable(){

        @Override
        public void run() {
            int color2 = EditCodeView.this.cursorPaint.getColor() == EditCodeView.this.underlineSelectedColor ? EditCodeView.this.underlineCursorColor : EditCodeView.this.underlineSelectedColor;
            EditCodeView.this.cursorPaint.setColor(color2);
            EditCodeView.this.invalidate();
            EditCodeView.this.postDelayed(EditCodeView.this.cursorAnimation, 500L);
        }
    };

    public EditCodeView(Context context) {
        super(context);
        this.init(context, null);
    }

    public EditCodeView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public EditCodeView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        this.initDefaultAttrs(context);
        this.initCustomAttrs(context, attrs);
        this.initPaints();
        this.initViewsOptions(context);
        if (this.isInEditMode()) {
            this.editModePreview();
        }
    }

    private void initDefaultAttrs(Context context) {
        Resources resources = context.getResources();
        this.underlineReductionScale = 0.5f;
        this.underlineStrokeWidth = resources.getDimension(R.dimen.underline_stroke_width);
        this.underlineBaseColor = ContextCompat.getColor((Context)context, (int)R.color.underline_base_color);
        this.underlineFilledColor = ContextCompat.getColor((Context)context, (int)R.color.underline_filled_color);
        this.underlineCursorColor = ContextCompat.getColor((Context)context, (int)R.color.underline_cursor_color);
        this.underlineSelectedColor = ContextCompat.getColor((Context)context, (int)R.color.underline_selected_color);
        this.textSize = resources.getDimension(R.dimen.code_text_size);
        this.textColor = ContextCompat.getColor((Context)context, (int)R.color.text_main_color);
        this.codeLength = 4;
        this.codeHiddenMask = DEFAULT_CODE_MASK;
    }

    private void initCustomAttrs(Context context, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return;
        }
        TypedArray attributes = context.obtainStyledAttributes(attributeSet, R.styleable.EditCodeView);
        this.underlineStrokeWidth = attributes.getDimension(R.styleable.EditCodeView_underlineStroke, this.underlineStrokeWidth);
        this.underlineReductionScale = attributes.getFloat(R.styleable.EditCodeView_underlineReductionScale, this.underlineReductionScale);
        this.underlineBaseColor = attributes.getColor(R.styleable.EditCodeView_underlineBaseColor, this.underlineBaseColor);
        this.underlineSelectedColor = attributes.getColor(R.styleable.EditCodeView_underlineSelectedColor, this.underlineSelectedColor);
        this.underlineFilledColor = attributes.getColor(R.styleable.EditCodeView_underlineFilledColor, this.underlineFilledColor);
        this.underlineCursorColor = attributes.getColor(R.styleable.EditCodeView_underlineCursorColor, this.underlineCursorColor);
        this.cursorEnabled = attributes.getBoolean(R.styleable.EditCodeView_underlineCursorEnabled, this.cursorEnabled);
        this.textSize = attributes.getDimension(R.styleable.EditCodeView_textSize, this.textSize);
        this.textColor = attributes.getColor(R.styleable.EditCodeView_textColor, this.textColor);
        this.fontStyle = attributes.getInt(R.styleable.EditCodeView_fontStyle, this.fontStyle);
        this.codeLength = attributes.getInt(R.styleable.EditCodeView_codeLength, 4);
        this.codeHiddenMode = attributes.getBoolean(R.styleable.EditCodeView_codeHiddenMode, this.codeHiddenMode);
        String mask = attributes.getString(R.styleable.EditCodeView_codeHiddenMask);
        if (mask != null && mask.length() > 0) {
            this.codeHiddenMask = mask.substring(0, 1);
        }
        attributes.recycle();
    }

    private void editModePreview() {
        for (int i = 0; i < this.codeLength; ++i) {
            if (this.codeHiddenMode) {
                this.editable.append((CharSequence)this.codeHiddenMask);
                continue;
            }
            this.editable.append((CharSequence)DEFAULT_CODE_SYMBOL);
        }
    }

    private void initPaints() {
        this.textPaint = new Paint();
        this.textPaint.setColor(this.textColor);
        this.textPaint.setTextSize(this.textSize);
        this.textPaint.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)this.fontStyle));
        this.textPaint.setAntiAlias(true);
        this.underlinePaint = new Paint();
        this.underlinePaint.setColor(this.underlineBaseColor);
        this.underlinePaint.setStrokeWidth(this.underlineStrokeWidth);
        this.cursorPaint = new Paint();
        this.cursorPaint.setColor(this.underlineBaseColor);
        this.cursorPaint.setStrokeWidth(this.underlineStrokeWidth);
    }

    private void initViewsOptions(Context context) {
        this.setOnClickListener(this);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setOnFocusChangeListener(this);
        this.inputmethodmanager = (InputMethodManager)context.getSystemService("input_method");
        this.editable = Editable.Factory.getInstance().newEditable((CharSequence)"");
        this.editable.setSpan((Object)this.textWatcher, 0, this.editable.length(), 18);
        Selection.setSelection((Spannable)this.editable, (int)0);
        this.editCodeInputConnection = new EditCodeInputConnection(this, true, this.codeLength);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.measureSizes(w, h);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    protected void onDraw(Canvas canvas) {
        this.drawUnderline(canvas);
        this.drawText(canvas);
    }

    public void onFocusChange(View v, boolean hasFocus) {
        this.setSelected(hasFocus);
        if (hasFocus) {
            if (this.cursorEnabled) {
                this.post(this.cursorAnimation);
            }
            this.showKeyboard();
        } else {
            if (this.cursorEnabled) {
                this.removeCallbacks(this.cursorAnimation);
            }
            this.hideKeyboard();
        }
    }

    private void drawText(Canvas canvas) {
        if (this.codeHiddenMode) {
            char[] symbol = new char[]{this.codeHiddenMask.charAt(0)};
            for (int i = 0; i < this.editable.length(); ++i) {
                float textPosX = this.sectionWidth * (float)i + this.sectionWidth / 2.0f - this.symbolMaskedWidth / 2.0f;
                canvas.drawText(symbol, 0, 1, textPosX, this.textPosY, this.textPaint);
            }
        } else {
            for (int i = 0; i < this.editable.length(); ++i) {
                char[] symbol = new char[]{this.editable.charAt(i)};
                float textPosX = this.sectionWidth * (float)i + this.sectionWidth / 2.0f - this.symbolWidth / 2.0f;
                canvas.drawText(symbol, 0, 1, textPosX, this.textPosY, this.textPaint);
            }
        }
    }

    private void drawUnderline(Canvas canvas) {
        for (int i = 0; i < this.codeLength; ++i) {
            float startPosX = this.sectionWidth * (float)i + this.underlineHorizontalPadding;
            float endPosX = startPosX + this.sectionWidth - this.underlineHorizontalPadding * 2.0f;
            if (this.cursorEnabled && this.isSelected && this.editable.length() == i) {
                canvas.drawLine(startPosX, this.underlinePosY, endPosX, this.underlinePosY, this.cursorPaint);
                continue;
            }
            if (this.editable.length() <= i && this.isSelected) {
                this.underlinePaint.setColor(this.underlineSelectedColor);
            } else if (this.editable.length() <= i && !this.isSelected) {
                this.underlinePaint.setColor(this.underlineBaseColor);
            } else {
                this.underlinePaint.setColor(this.underlineFilledColor);
            }
            canvas.drawLine(startPosX, this.underlinePosY, endPosX, this.underlinePosY, this.underlinePaint);
        }
    }

    private void measureSizes(int viewWidth, int viewHeight) {
        if (this.underlineReductionScale > 1.0f) {
            this.underlineReductionScale = 1.0f;
        }
        if (this.underlineReductionScale < 0.0f) {
            this.underlineReductionScale = 0.0f;
        }
        if (this.codeLength <= 0) {
            throw new IllegalArgumentException("Code length must be over than zero");
        }
        this.symbolWidth = this.textPaint.measureText(DEFAULT_CODE_SYMBOL);
        this.symbolMaskedWidth = this.textPaint.measureText(this.codeHiddenMask);
        this.textPaint.getTextBounds(DEFAULT_CODE_SYMBOL, 0, 1, this.textBounds);
        this.sectionWidth = viewWidth / this.codeLength;
        this.underlinePosY = viewHeight - this.getPaddingBottom();
        this.underlineHorizontalPadding = this.sectionWidth * this.underlineReductionScale / 2.0f;
        this.textPosY = viewHeight / 2 + this.textBounds.height() / 2;
    }

    private int measureHeight(int measureSpec) {
        int size = (int)((float)(this.getPaddingBottom() + this.getPaddingTop() + this.textBounds.height()) + this.textSize + this.underlineStrokeWidth);
        return EditCodeView.resolveSizeAndState((int)size, (int)measureSpec, (int)0);
    }

    private int measureWidth(int measureSpec) {
        int size = (int)(((float)(this.getPaddingLeft() + this.getPaddingRight()) + this.textSize) * (float)this.codeLength * 2.0f);
        return EditCodeView.resolveSizeAndState((int)size, (int)measureSpec, (int)0);
    }

    public void setEditCodeListener(EditCodeListener EditCodeListener2) {
        this.editCodeListener = EditCodeListener2;
    }

    public void setCode(@NonNull String code) {
        code = code.replaceAll(DEFAULT_REGEX, "");
        this.editCodeInputConnection.setComposingText(code, 0);
    }

    public void clearCode() {
        this.editCodeInputConnection.setComposingText("", 0);
    }

    public String getCode() {
        return this.editable.toString();
    }

    public void setReductionScale(float scale) {
        if (scale > 1.0f) {
            scale = 1.0f;
        }
        if (scale < 0.0f) {
            scale = 0.0f;
        }
        this.underlineReductionScale = scale;
        this.invalidate();
    }

    public void setCodeHiddenMode(boolean hiddenMode) {
        this.codeHiddenMode = hiddenMode;
        this.invalidate();
    }

    public void setUnderlineBaseColor(@ColorInt int colorId) {
        this.underlineBaseColor = colorId;
        this.invalidate();
    }

    public void setUnderlineFilledColor(@ColorInt int colorId) {
        this.underlineFilledColor = colorId;
        this.invalidate();
    }

    public void setUnderlineSelectedColor(@ColorInt int colorId) {
        this.underlineSelectedColor = colorId;
        this.invalidate();
    }

    public void setUnderlineCursorColor(@ColorInt int colorId) {
        this.underlineCursorColor = colorId;
        this.invalidate();
    }

    public void setTextColor(@ColorInt int colorId) {
        this.textColor = colorId;
        this.invalidate();
    }

    public void setUnderlineStrokeWidth(float underlineStrokeWidth) {
        this.underlineStrokeWidth = underlineStrokeWidth;
        this.invalidate();
    }

    public void setCodeLength(int length) {
        this.codeLength = length;
        this.editCodeInputConnection = new EditCodeInputConnection(this, true, this.codeLength);
        this.editable.clear();
        this.inputmethodmanager.restartInput((View)this);
        this.invalidate();
    }

    public void setEditCodeWatcher(EditCodeWatcher editCodeWatcher) {
        this.editCodeWatcher = editCodeWatcher;
    }

    public void showKeyboard() {
        this.inputmethodmanager.showSoftInput((View)this, 0);
    }

    public void hideKeyboard() {
        this.inputmethodmanager.hideSoftInputFromWindow(this.getWindowToken(), 0);
    }

    public void onClick(View v) {
        this.showKeyboard();
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        outAttrs.inputType = 2;
        outAttrs.imeOptions = 6;
        outAttrs.initialSelStart = 0;
        return this.editCodeInputConnection;
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
        this.invalidate();
    }

    protected Editable getEditable() {
        return this.editable;
    }

    public boolean onCheckIsTextEditor() {
        return true;
    }

    private class CodeTextWatcher
    implements TextWatcher {
        private CodeTextWatcher() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            EditCodeView.this.invalidate();
            if (EditCodeView.this.editCodeWatcher != null) {
                EditCodeView.this.editCodeWatcher.onCodeChanged(s.toString());
            }
            if (EditCodeView.this.editable.length() == EditCodeView.this.codeLength && EditCodeView.this.editCodeListener != null) {
                EditCodeView.this.editCodeListener.onCodeReady(EditCodeView.this.editable.toString());
            }
        }
    }
}

