/*
 * Decompiled with CFR 0.152.
 */
package com.beloo.widget.chipslayoutmanager.util.log;

import com.beloo.widget.chipslayoutmanager.util.log.LogWrapper;
import com.beloo.widget.chipslayoutmanager.util.log.SilentLog;
import java.util.HashSet;
import java.util.Set;

public class Log {
    private static LogSwitcher logSwitcher = new LogSwitcher();
    private static LogWrapper log = new SilentLog();

    public static int d(String tag, String msg) {
        return log.d(tag, msg);
    }

    public static int v(String tag, String msg) {
        return log.v(tag, msg);
    }

    public static int w(String tag, String msg) {
        return log.w(tag, msg);
    }

    public static int i(String tag, String msg) {
        return log.i(tag, msg);
    }

    public static int e(String tag, String msg) {
        return log.e(tag, msg);
    }

    public static int d(String tag, String msg, int logCode) {
        return logSwitcher.isEnabled(logCode) ? Log.d(tag, msg) : 0;
    }

    public static int v(String tag, String msg, int logCode) {
        return logSwitcher.isEnabled(logCode) ? Log.v(tag, msg) : 0;
    }

    public static int w(String tag, String msg, int logCode) {
        return logSwitcher.isEnabled(logCode) ? Log.w(tag, msg) : 0;
    }

    public static int i(String tag, String msg, int logCode) {
        return logSwitcher.isEnabled(logCode) ? Log.i(tag, msg) : 0;
    }

    public static void with(LogSwitcher logSwitcher) {
        Log.logSwitcher = logSwitcher;
    }

    public static class LogSwitcher {
        private Set<Integer> enabledLogs = new HashSet<Integer>();

        boolean isEnabled(int logCode) {
            return this.enabledLogs.contains(logCode);
        }

        public LogSwitcher with(int logCode) {
            this.enabledLogs.add(logCode);
            return this;
        }

        public LogSwitcher without(int logCode) {
            this.enabledLogs.remove(logCode);
            return this;
        }
    }
}

