/*
 * Decompiled with CFR 0.152.
 */
package com.beloo.widget.chipslayoutmanager.util.log;

import android.util.SparseArray;
import android.view.View;
import com.beloo.widget.chipslayoutmanager.anchor.AnchorViewState;
import com.beloo.widget.chipslayoutmanager.util.log.IFillLogger;
import com.beloo.widget.chipslayoutmanager.util.log.Log;
import java.util.Locale;

class FillLogger
implements IFillLogger {
    private SparseArray<View> viewCache;
    private int requestedItems;
    private int recycledItems;
    private int startCacheSize;
    private int recycledSize;

    FillLogger(SparseArray<View> viewCache) {
        this.viewCache = viewCache;
    }

    @Override
    public void onStartLayouter(int startPosition) {
        this.requestedItems = 0;
        this.recycledItems = 0;
        this.startCacheSize = this.viewCache.size();
        Log.d("fillWithLayouter", "start position = " + startPosition, 3);
        Log.d("fillWithLayouter", "cached items = " + this.startCacheSize, 3);
    }

    @Override
    public void onItemRequested() {
        ++this.requestedItems;
    }

    @Override
    public void onItemRecycled() {
        ++this.recycledItems;
    }

    @Override
    public void onFinishedLayouter() {
        Log.d("fillWithLayouter", String.format(Locale.getDefault(), "reattached items = %d : requested items = %d recycledItems = %d", this.startCacheSize - this.viewCache.size(), this.requestedItems, this.recycledItems), 3);
    }

    @Override
    public void onAfterLayouter() {
        this.recycledSize = this.viewCache.size();
    }

    @Override
    public void onRemovedAndRecycled(int position) {
        Log.d("fillWithLayouter", " recycle position =" + this.viewCache.keyAt(position), 3);
        ++this.recycledSize;
    }

    @Override
    public void onAfterRemovingViews() {
        Log.d("fillWithLayouter", "recycled count = " + this.recycledSize, 3);
    }

    @Override
    public void onBeforeLayouter(AnchorViewState anchorView) {
        if (anchorView.getAnchorViewRect() != null) {
            Log.d("fill", "anchorPos " + anchorView.getPosition(), 3);
            Log.d("fill", "anchorTop " + anchorView.getAnchorViewRect().top, 3);
        }
    }
}

