/*
 * Decompiled with CFR 0.152.
 */
package com.beloo.widget.chipslayoutmanager.layouter.breaker;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.beloo.widget.chipslayoutmanager.cache.IViewCacheStorage;
import com.beloo.widget.chipslayoutmanager.layouter.breaker.BackwardBreakerContract;
import com.beloo.widget.chipslayoutmanager.layouter.breaker.CacheRowBreaker;
import com.beloo.widget.chipslayoutmanager.layouter.breaker.ForwardBreakerContract;
import com.beloo.widget.chipslayoutmanager.layouter.breaker.IBreakerFactory;
import com.beloo.widget.chipslayoutmanager.layouter.breaker.ILayoutRowBreaker;
import com.beloo.widget.chipslayoutmanager.layouter.breaker.IRowBreaker;
import com.beloo.widget.chipslayoutmanager.layouter.breaker.MaxViewsBreaker;

public class DecoratorBreakerFactory
implements IBreakerFactory {
    private IBreakerFactory breakerFactory;
    private IViewCacheStorage cacheStorage;
    private IRowBreaker rowBreaker;
    @Nullable
    private Integer maxViewsInRow;

    public DecoratorBreakerFactory(@NonNull IViewCacheStorage cacheStorage, @NonNull IRowBreaker rowBreaker, @Nullable Integer maxViewsInRow, @NonNull IBreakerFactory breakerFactory) {
        this.cacheStorage = cacheStorage;
        this.rowBreaker = rowBreaker;
        this.maxViewsInRow = maxViewsInRow;
        this.breakerFactory = breakerFactory;
    }

    @Override
    public ILayoutRowBreaker createBackwardRowBreaker() {
        ILayoutRowBreaker breaker = this.breakerFactory.createBackwardRowBreaker();
        breaker = new BackwardBreakerContract(this.rowBreaker, new CacheRowBreaker(this.cacheStorage, breaker));
        if (this.maxViewsInRow != null) {
            breaker = new MaxViewsBreaker(this.maxViewsInRow, breaker);
        }
        return breaker;
    }

    @Override
    public ILayoutRowBreaker createForwardRowBreaker() {
        ILayoutRowBreaker breaker = this.breakerFactory.createForwardRowBreaker();
        breaker = new ForwardBreakerContract(this.rowBreaker, breaker);
        if (this.maxViewsInRow != null) {
            breaker = new MaxViewsBreaker(this.maxViewsInRow, breaker);
        }
        return breaker;
    }
}

