/*
 * Decompiled with CFR 0.152.
 */
package com.beloo.widget.chipslayoutmanager.layouter;

import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.beloo.widget.chipslayoutmanager.ChipsLayoutManager;
import com.beloo.widget.chipslayoutmanager.anchor.AnchorViewState;
import com.beloo.widget.chipslayoutmanager.cache.IViewCacheStorage;
import com.beloo.widget.chipslayoutmanager.gravity.IGravityModifiersFactory;
import com.beloo.widget.chipslayoutmanager.gravity.IRowStrategy;
import com.beloo.widget.chipslayoutmanager.gravity.SkipLastRowStrategy;
import com.beloo.widget.chipslayoutmanager.layouter.AbstractLayouter;
import com.beloo.widget.chipslayoutmanager.layouter.DecrementalPositionIterator;
import com.beloo.widget.chipslayoutmanager.layouter.ICanvas;
import com.beloo.widget.chipslayoutmanager.layouter.ILayouter;
import com.beloo.widget.chipslayoutmanager.layouter.ILayouterCreator;
import com.beloo.widget.chipslayoutmanager.layouter.ILayouterListener;
import com.beloo.widget.chipslayoutmanager.layouter.IncrementalPositionIterator;
import com.beloo.widget.chipslayoutmanager.layouter.breaker.IBreakerFactory;
import com.beloo.widget.chipslayoutmanager.layouter.criteria.ICriteriaFactory;
import com.beloo.widget.chipslayoutmanager.layouter.placer.IPlacerFactory;
import java.util.ArrayList;
import java.util.List;

public class LayouterFactory {
    private ChipsLayoutManager layoutManager;
    private IViewCacheStorage cacheStorage;
    private List<ILayouterListener> layouterListeners = new ArrayList<ILayouterListener>();
    private IBreakerFactory breakerFactory;
    private ICriteriaFactory criteriaFactory;
    private IPlacerFactory placerFactory;
    private IGravityModifiersFactory gravityModifiersFactory;
    private IRowStrategy rowStrategy;
    private ILayouterCreator layouterCreator;

    LayouterFactory(ChipsLayoutManager layoutManager, ILayouterCreator layouterCreator, IBreakerFactory breakerFactory, ICriteriaFactory criteriaFactory, IPlacerFactory placerFactory, IGravityModifiersFactory gravityModifiersFactory, IRowStrategy rowStrategy) {
        this.layouterCreator = layouterCreator;
        this.cacheStorage = layoutManager.getViewPositionsStorage();
        this.layoutManager = layoutManager;
        this.breakerFactory = breakerFactory;
        this.criteriaFactory = criteriaFactory;
        this.placerFactory = placerFactory;
        this.gravityModifiersFactory = gravityModifiersFactory;
        this.rowStrategy = rowStrategy;
    }

    public void addLayouterListener(@Nullable ILayouterListener layouterListener) {
        if (layouterListener != null) {
            this.layouterListeners.add(layouterListener);
        }
    }

    private AbstractLayouter.Builder createBackwardBuilder() {
        return this.layouterCreator.createBackwardBuilder();
    }

    private AbstractLayouter.Builder createForwardBuilder() {
        return this.layouterCreator.createForwardBuilder();
    }

    private Rect createOffsetRectForBackwardLayouter(@NonNull AnchorViewState anchorRect) {
        return this.layouterCreator.createOffsetRectForBackwardLayouter(anchorRect);
    }

    private Rect createOffsetRectForForwardLayouter(AnchorViewState anchorRect) {
        return this.layouterCreator.createOffsetRectForForwardLayouter(anchorRect);
    }

    private ICanvas createCanvas() {
        return this.layoutManager.getCanvas();
    }

    @NonNull
    private AbstractLayouter.Builder fillBasicBuilder(AbstractLayouter.Builder builder) {
        return builder.layoutManager(this.layoutManager).canvas(this.createCanvas()).childGravityResolver(this.layoutManager.getChildGravityResolver()).cacheStorage(this.cacheStorage).gravityModifiersFactory(this.gravityModifiersFactory).addLayouterListeners(this.layouterListeners);
    }

    @Nullable
    public final ILayouter getBackwardLayouter(@NonNull AnchorViewState anchorRect) {
        return this.fillBasicBuilder(this.createBackwardBuilder()).offsetRect(this.createOffsetRectForBackwardLayouter(anchorRect)).breaker(this.breakerFactory.createBackwardRowBreaker()).finishingCriteria(this.criteriaFactory.getBackwardFinishingCriteria()).rowStrategy(this.rowStrategy).placer(this.placerFactory.getAtStartPlacer()).positionIterator(new DecrementalPositionIterator(this.layoutManager.getItemCount())).build();
    }

    @NonNull
    public final ILayouter getForwardLayouter(@NonNull AnchorViewState anchorRect) {
        return this.fillBasicBuilder(this.createForwardBuilder()).offsetRect(this.createOffsetRectForForwardLayouter(anchorRect)).breaker(this.breakerFactory.createForwardRowBreaker()).finishingCriteria(this.criteriaFactory.getForwardFinishingCriteria()).rowStrategy(new SkipLastRowStrategy(this.rowStrategy, !this.layoutManager.isStrategyAppliedWithLastRow())).placer(this.placerFactory.getAtEndPlacer()).positionIterator(new IncrementalPositionIterator(this.layoutManager.getItemCount())).build();
    }

    @NonNull
    public final ILayouter buildForwardLayouter(@NonNull ILayouter layouter) {
        AbstractLayouter abstractLayouter = (AbstractLayouter)layouter;
        abstractLayouter.setFinishingCriteria(this.criteriaFactory.getForwardFinishingCriteria());
        abstractLayouter.setPlacer(this.placerFactory.getAtEndPlacer());
        return abstractLayouter;
    }

    @NonNull
    public final ILayouter buildBackwardLayouter(@NonNull ILayouter layouter) {
        AbstractLayouter abstractLayouter = (AbstractLayouter)layouter;
        abstractLayouter.setFinishingCriteria(this.criteriaFactory.getBackwardFinishingCriteria());
        abstractLayouter.setPlacer(this.placerFactory.getAtStartPlacer());
        return abstractLayouter;
    }
}

