/*
 * Decompiled with CFR 0.152.
 */
package com.beloo.widget.chipslayoutmanager.layouter;

import android.graphics.Rect;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Pair;
import android.view.View;
import com.beloo.widget.chipslayoutmanager.ChipsLayoutManager;
import com.beloo.widget.chipslayoutmanager.IBorder;
import com.beloo.widget.chipslayoutmanager.cache.IViewCacheStorage;
import com.beloo.widget.chipslayoutmanager.gravity.IChildGravityResolver;
import com.beloo.widget.chipslayoutmanager.gravity.IGravityModifier;
import com.beloo.widget.chipslayoutmanager.gravity.IGravityModifiersFactory;
import com.beloo.widget.chipslayoutmanager.gravity.IRowStrategy;
import com.beloo.widget.chipslayoutmanager.layouter.AbstractPositionIterator;
import com.beloo.widget.chipslayoutmanager.layouter.ILayouter;
import com.beloo.widget.chipslayoutmanager.layouter.ILayouterListener;
import com.beloo.widget.chipslayoutmanager.layouter.Item;
import com.beloo.widget.chipslayoutmanager.layouter.breaker.ILayoutRowBreaker;
import com.beloo.widget.chipslayoutmanager.layouter.criteria.IFinishingCriteria;
import com.beloo.widget.chipslayoutmanager.layouter.placer.IPlacer;
import com.beloo.widget.chipslayoutmanager.util.AssertionUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class AbstractLayouter
implements ILayouter,
IBorder {
    private int currentViewWidth;
    private int currentViewHeight;
    private int currentViewPosition;
    List<Pair<Rect, View>> rowViews = new LinkedList<Pair<Rect, View>>();
    int viewBottom;
    int viewTop;
    int viewRight;
    int viewLeft;
    private int rowSize = 0;
    private int previousRowSize;
    private boolean isRowCompleted;
    @NonNull
    private ChipsLayoutManager layoutManager;
    @NonNull
    private IViewCacheStorage cacheStorage;
    @NonNull
    private IBorder border;
    @NonNull
    private IChildGravityResolver childGravityResolver;
    @NonNull
    private IFinishingCriteria finishingCriteria;
    @NonNull
    private IPlacer placer;
    @NonNull
    private ILayoutRowBreaker breaker;
    @NonNull
    private IRowStrategy rowStrategy;
    private Set<ILayouterListener> layouterListeners = new HashSet<ILayouterListener>();
    @NonNull
    private IGravityModifiersFactory gravityModifiersFactory;
    @NonNull
    private AbstractPositionIterator positionIterator;

    AbstractLayouter(Builder builder) {
        this.layoutManager = builder.layoutManager;
        this.cacheStorage = builder.cacheStorage;
        this.border = builder.border;
        this.childGravityResolver = builder.childGravityResolver;
        this.finishingCriteria = builder.finishingCriteria;
        this.placer = builder.placer;
        this.viewTop = ((Builder)builder).offsetRect.top;
        this.viewBottom = ((Builder)builder).offsetRect.bottom;
        this.viewRight = ((Builder)builder).offsetRect.right;
        this.viewLeft = ((Builder)builder).offsetRect.left;
        this.layouterListeners = builder.layouterListeners;
        this.breaker = builder.breaker;
        this.gravityModifiersFactory = builder.gravityModifiersFactory;
        this.rowStrategy = builder.rowStrategy;
        this.positionIterator = builder.positionIterator;
    }

    void setFinishingCriteria(@NonNull IFinishingCriteria finishingCriteria) {
        this.finishingCriteria = finishingCriteria;
    }

    @Override
    public AbstractPositionIterator positionIterator() {
        return this.positionIterator;
    }

    public boolean isRowCompleted() {
        return this.isRowCompleted;
    }

    @Override
    public List<Item> getCurrentRowItems() {
        LinkedList<Item> items = new LinkedList<Item>();
        LinkedList<Pair<Rect, View>> mutableRowViews = new LinkedList<Pair<Rect, View>>(this.rowViews);
        if (this.isReverseOrder()) {
            Collections.reverse(mutableRowViews);
        }
        for (Pair pair : mutableRowViews) {
            items.add(new Item((Rect)pair.first, this.layoutManager.getPosition((View)pair.second)));
        }
        return items;
    }

    public final int getCurrentViewPosition() {
        return this.currentViewPosition;
    }

    final IViewCacheStorage getCacheStorage() {
        return this.cacheStorage;
    }

    @Override
    public void addLayouterListener(ILayouterListener layouterListener) {
        if (layouterListener != null) {
            this.layouterListeners.add(layouterListener);
        }
    }

    @Override
    public void removeLayouterListener(ILayouterListener layouterListener) {
        this.layouterListeners.remove(layouterListener);
    }

    private void notifyLayouterListeners() {
        for (ILayouterListener layouterListener : this.layouterListeners) {
            layouterListener.onLayoutRow(this);
        }
    }

    @Override
    public final int getPreviousRowSize() {
        return this.previousRowSize;
    }

    private void calculateView(View view) {
        this.currentViewHeight = this.layoutManager.getDecoratedMeasuredHeight(view);
        this.currentViewWidth = this.layoutManager.getDecoratedMeasuredWidth(view);
        this.currentViewPosition = this.layoutManager.getPosition(view);
    }

    @Override
    @CallSuper
    public final boolean placeView(View view) {
        this.layoutManager.measureChildWithMargins(view, 0, 0);
        this.calculateView(view);
        if (this.canNotBePlacedInCurrentRow()) {
            this.isRowCompleted = true;
            this.layoutRow();
        }
        if (this.isFinishedLayouting()) {
            return false;
        }
        ++this.rowSize;
        Rect rect = this.createViewRect(view);
        this.rowViews.add((Pair<Rect, View>)new Pair((Object)rect, (Object)view));
        return true;
    }

    public final boolean isFinishedLayouting() {
        return this.finishingCriteria.isFinishedLayouting(this);
    }

    public final boolean canNotBePlacedInCurrentRow() {
        return this.breaker.isRowBroke(this);
    }

    abstract Rect createViewRect(View var1);

    abstract boolean isReverseOrder();

    abstract void onPreLayout();

    abstract void onAfterLayout();

    abstract boolean isAttachedViewFromNewRow(View var1);

    abstract void onInterceptAttachView(View var1);

    void setPlacer(@NonNull IPlacer placer) {
        this.placer = placer;
    }

    @Override
    @CallSuper
    public final boolean onAttachView(View view) {
        this.calculateView(view);
        if (this.isAttachedViewFromNewRow(view)) {
            this.notifyLayouterListeners();
            this.rowSize = 0;
        }
        this.onInterceptAttachView(view);
        if (this.isFinishedLayouting()) {
            return false;
        }
        ++this.rowSize;
        this.layoutManager.attachView(view);
        return true;
    }

    @Override
    public final void layoutRow() {
        this.onPreLayout();
        if (this.rowViews.size() > 0) {
            this.rowStrategy.applyStrategy(this, this.getCurrentRowItems());
        }
        for (Pair<Rect, View> rowViewRectPair : this.rowViews) {
            Rect viewRect = (Rect)rowViewRectPair.first;
            View view = (View)rowViewRectPair.second;
            viewRect = this.applyChildGravity(view, viewRect);
            this.placer.addView(view);
            this.layoutManager.layoutDecorated(view, viewRect.left, viewRect.top, viewRect.right, viewRect.bottom);
        }
        this.onAfterLayout();
        this.notifyLayouterListeners();
        this.previousRowSize = this.rowSize;
        this.rowSize = 0;
        this.rowViews.clear();
        this.isRowCompleted = false;
    }

    private Rect applyChildGravity(View view, Rect viewRect) {
        int viewGravity = this.childGravityResolver.getItemGravity(this.getLayoutManager().getPosition(view));
        IGravityModifier gravityModifier = this.gravityModifiersFactory.getGravityModifier(viewGravity);
        return gravityModifier.modifyChildRect(this.getStartRowBorder(), this.getEndRowBorder(), viewRect);
    }

    @NonNull
    public ChipsLayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    @Override
    public int getRowSize() {
        return this.rowSize;
    }

    @Override
    public int getViewTop() {
        return this.viewTop;
    }

    public abstract int getStartRowBorder();

    public abstract int getEndRowBorder();

    @Override
    public Rect getRowRect() {
        return new Rect(this.getCanvasLeftBorder(), this.getViewTop(), this.getCanvasRightBorder(), this.getViewBottom());
    }

    @Override
    public int getViewBottom() {
        return this.viewBottom;
    }

    final Rect getOffsetRect() {
        return new Rect(this.viewLeft, this.viewTop, this.viewRight, this.viewBottom);
    }

    public final int getViewLeft() {
        return this.viewLeft;
    }

    public final int getViewRight() {
        return this.viewRight;
    }

    public final int getCurrentViewWidth() {
        return this.currentViewWidth;
    }

    public final int getCurrentViewHeight() {
        return this.currentViewHeight;
    }

    public abstract int getRowLength();

    @Override
    public final int getCanvasRightBorder() {
        return this.border.getCanvasRightBorder();
    }

    @Override
    public final int getCanvasBottomBorder() {
        return this.border.getCanvasBottomBorder();
    }

    @Override
    public final int getCanvasLeftBorder() {
        return this.border.getCanvasLeftBorder();
    }

    @Override
    public final int getCanvasTopBorder() {
        return this.border.getCanvasTopBorder();
    }

    public static abstract class Builder {
        private ChipsLayoutManager layoutManager;
        private IViewCacheStorage cacheStorage;
        private IBorder border;
        private IChildGravityResolver childGravityResolver;
        private IFinishingCriteria finishingCriteria;
        private IPlacer placer;
        private ILayoutRowBreaker breaker;
        private Rect offsetRect;
        private HashSet<ILayouterListener> layouterListeners = new HashSet();
        private IGravityModifiersFactory gravityModifiersFactory;
        private IRowStrategy rowStrategy;
        private AbstractPositionIterator positionIterator;

        Builder() {
        }

        @NonNull
        public Builder offsetRect(@NonNull Rect offsetRect) {
            this.offsetRect = offsetRect;
            return this;
        }

        @NonNull
        public final Builder layoutManager(@NonNull ChipsLayoutManager layoutManager) {
            this.layoutManager = layoutManager;
            return this;
        }

        @NonNull
        final Builder cacheStorage(@NonNull IViewCacheStorage cacheStorage) {
            this.cacheStorage = cacheStorage;
            return this;
        }

        @NonNull
        Builder rowStrategy(IRowStrategy rowStrategy) {
            this.rowStrategy = rowStrategy;
            return this;
        }

        @NonNull
        final Builder canvas(@NonNull IBorder border) {
            this.border = border;
            return this;
        }

        @NonNull
        final Builder gravityModifiersFactory(@NonNull IGravityModifiersFactory gravityModifiersFactory) {
            this.gravityModifiersFactory = gravityModifiersFactory;
            return this;
        }

        @NonNull
        final Builder childGravityResolver(@NonNull IChildGravityResolver childGravityResolver) {
            this.childGravityResolver = childGravityResolver;
            return this;
        }

        @NonNull
        final Builder finishingCriteria(@NonNull IFinishingCriteria finishingCriteria) {
            this.finishingCriteria = finishingCriteria;
            return this;
        }

        @NonNull
        public final Builder placer(@NonNull IPlacer placer) {
            this.placer = placer;
            return this;
        }

        @NonNull
        final Builder addLayouterListener(@Nullable ILayouterListener layouterListener) {
            if (layouterListener != null) {
                this.layouterListeners.add(layouterListener);
            }
            return this;
        }

        @NonNull
        final Builder breaker(@NonNull ILayoutRowBreaker breaker) {
            AssertionUtils.assertNotNull(breaker, "breaker shouldn't be null");
            this.breaker = breaker;
            return this;
        }

        @NonNull
        final Builder addLayouterListeners(@NonNull List<ILayouterListener> layouterListeners) {
            this.layouterListeners.addAll(layouterListeners);
            return this;
        }

        @NonNull
        public Builder positionIterator(AbstractPositionIterator positionIterator) {
            this.positionIterator = positionIterator;
            return this;
        }

        @NonNull
        protected abstract AbstractLayouter createLayouter();

        public final AbstractLayouter build() {
            if (this.layoutManager == null) {
                throw new IllegalStateException("layoutManager can't be null, call #layoutManager()");
            }
            if (this.breaker == null) {
                throw new IllegalStateException("breaker can't be null, call #breaker()");
            }
            if (this.border == null) {
                throw new IllegalStateException("border can't be null, call #border()");
            }
            if (this.cacheStorage == null) {
                throw new IllegalStateException("cacheStorage can't be null, call #cacheStorage()");
            }
            if (this.rowStrategy == null) {
                throw new IllegalStateException("rowStrategy can't be null, call #rowStrategy()");
            }
            if (this.offsetRect == null) {
                throw new IllegalStateException("offsetRect can't be null, call #offsetRect()");
            }
            if (this.finishingCriteria == null) {
                throw new IllegalStateException("finishingCriteria can't be null, call #finishingCriteria()");
            }
            if (this.placer == null) {
                throw new IllegalStateException("placer can't be null, call #placer()");
            }
            if (this.gravityModifiersFactory == null) {
                throw new IllegalStateException("gravityModifiersFactory can't be null, call #gravityModifiersFactory()");
            }
            if (this.childGravityResolver == null) {
                throw new IllegalStateException("childGravityResolver can't be null, call #childGravityResolver()");
            }
            if (this.positionIterator == null) {
                throw new IllegalStateException("positionIterator can't be null, call #positionIterator()");
            }
            return this.createLayouter();
        }
    }
}

