/*
 * Decompiled with CFR 0.152.
 */
package com.beloo.widget.chipslayoutmanager.anchor;

import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.beloo.widget.chipslayoutmanager.ChildViewsIterable;
import com.beloo.widget.chipslayoutmanager.anchor.AbstractAnchorFactory;
import com.beloo.widget.chipslayoutmanager.anchor.AnchorViewState;
import com.beloo.widget.chipslayoutmanager.layouter.ICanvas;

public class RowsAnchorFactory
extends AbstractAnchorFactory {
    private ChildViewsIterable childViews;

    public RowsAnchorFactory(RecyclerView.LayoutManager lm, ICanvas canvas) {
        super(lm, canvas);
        this.childViews = new ChildViewsIterable(lm);
    }

    @Override
    public AnchorViewState getAnchor() {
        AnchorViewState minPosView = AnchorViewState.getNotFoundState();
        int minPosition = Integer.MAX_VALUE;
        int minTop = Integer.MAX_VALUE;
        for (View view : this.childViews) {
            AnchorViewState anchorViewState = this.createAnchorState(view);
            int pos = this.lm.getPosition(view);
            int top = this.lm.getDecoratedTop(view);
            Rect viewRect = new Rect(anchorViewState.getAnchorViewRect());
            if (!this.getCanvas().isInside(viewRect) || anchorViewState.isRemoving()) continue;
            if (minPosition > pos) {
                minPosition = pos;
                minPosView = anchorViewState;
            }
            if (minTop <= top) continue;
            minTop = top;
        }
        if (!minPosView.isNotFoundState()) {
            minPosView.getAnchorViewRect().top = minTop;
            minPosView.setPosition(minPosition);
        }
        return minPosView;
    }

    @Override
    public void resetRowCoordinates(AnchorViewState anchorView) {
        if (!anchorView.isNotFoundState()) {
            Rect rect = anchorView.getAnchorViewRect();
            rect.left = this.getCanvas().getCanvasLeftBorder();
            rect.right = this.getCanvas().getCanvasRightBorder();
        }
    }
}

