/*
 * Decompiled with CFR 0.152.
 */
package com.begentgroup.xmlparser;

import com.begentgroup.xmlparser.ClassInfoTable;
import com.begentgroup.xmlparser.FieldInfo;
import com.begentgroup.xmlparser.SimpleParseException;
import com.begentgroup.xmlparser.Utils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;

class XMLGenerator {
    static HashMap<Class, ClassInfoTable> tables = new HashMap();
    static FieldInfo sObjectInfo = new FieldInfo();
    static FieldInfo sPrimitiveInfo = new FieldInfo();
    String result;

    public XMLGenerator(String element, Object object) {
        int type = Utils.getClassType(object.getClass());
        FieldInfo info = new FieldInfo();
        if (type == 1 || type == 2) {
            return;
        }
        info.fieldType = type;
        this.result = this.generatingXML(element, object, info);
    }

    public String generatingXML(String element, Object object, FieldInfo info) {
        StringBuilder sb = new StringBuilder();
        FieldInfo childInfo = null;
        switch (info.fieldType) {
            case 0: {
                sb.append("<" + element + ">" + object + "</" + element + ">\n\r");
                break;
            }
            case 1: {
                if (info.componentType == 1 || info.componentType == 2) {
                    return "";
                }
                if (info.componentType == 0) {
                    childInfo = sPrimitiveInfo;
                } else if (info.componentType == 3) {
                    childInfo = sObjectInfo;
                }
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    Object value = Array.get(object, i);
                    sb.append(this.generatingXML(element, value, childInfo));
                }
                break;
            }
            case 2: {
                if (info.componentType == 1 || info.componentType == 2) {
                    return "";
                }
                if (info.componentType == 0) {
                    childInfo = sPrimitiveInfo;
                } else if (info.componentType == 3) {
                    childInfo = sObjectInfo;
                }
                Collection collection = (Collection)object;
                for (Object value : collection) {
                    sb.append(this.generatingXML(element, value, childInfo));
                }
                break;
            }
            case 3: {
                Object v;
                FieldInfo cinfo;
                ClassInfoTable table = tables.get(object.getClass());
                if (table == null) {
                    table = Utils.makeClassInfoTable(object.getClass());
                    tables.put(object.getClass(), table);
                }
                sb.append("<" + element);
                for (Field f : table.fields) {
                    cinfo = table.fieldInfos.get(Utils.getFieldName(f));
                    if (cinfo.annotationType != 1 || cinfo.fieldType != 0) continue;
                    v = null;
                    try {
                        v = f.get(object);
                        if (v == null) continue;
                        sb.append(" " + cinfo.name + "= \"" + v + "\"");
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                sb.append(">\n\r");
                for (Field f : table.fields) {
                    cinfo = table.fieldInfos.get(Utils.getFieldName(f));
                    if (cinfo.annotationType == 1 || cinfo.annotationType == 3) continue;
                    v = null;
                    try {
                        v = f.get(object);
                        if (v == null) continue;
                        sb.append(this.generatingXML(cinfo.name, v, cinfo));
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                        throw new SimpleParseException(e.getMessage(), e);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        throw new SimpleParseException(e.getMessage(), e);
                    }
                }
                sb.append("</" + element + ">\n\r");
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.result;
    }

    static {
        XMLGenerator.sObjectInfo.fieldType = 3;
        XMLGenerator.sPrimitiveInfo.fieldType = 0;
    }
}

