/*
 * Decompiled with CFR 0.152.
 */
package com.begentgroup.xmlparser;

import com.begentgroup.xmlparser.Attribute;
import com.begentgroup.xmlparser.ClassInfoTable;
import com.begentgroup.xmlparser.DefaultValueField;
import com.begentgroup.xmlparser.Element;
import com.begentgroup.xmlparser.Exclusion;
import com.begentgroup.xmlparser.FieldInfo;
import com.begentgroup.xmlparser.SerializedName;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;

class Utils {
    public static final int CLASS_NOT_FIXED = -1;
    public static final int CLASS_PRIMITIVE = 0;
    public static final int CLASS_ARRAY = 1;
    public static final int CLASS_COLLECTION = 2;
    public static final int CLASS_OBJECT = 3;

    Utils() {
    }

    public static int getClassType(Class clazz) {
        if (clazz.isPrimitive() || clazz == Integer.class || clazz == Long.class || clazz == Short.class || clazz == String.class || clazz == Character.class || clazz == Boolean.class || clazz == Float.class || clazz == Double.class) {
            return 0;
        }
        if (clazz.isArray()) {
            return 1;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return 2;
        }
        return 3;
    }

    public static ClassInfoTable makeClassInfoTable(Class<? extends Object> clazz) {
        ClassInfoTable table = new ClassInfoTable();
        for (Field field : table.fields = clazz.getDeclaredFields()) {
            String name;
            FieldInfo info = new FieldInfo();
            field.setAccessible(true);
            info.f = field;
            info.fieldType = Utils.getClassType(field.getType());
            if (field.getAnnotation(Exclusion.class) != null) {
                info.annotationType = 3;
            } else if (field.getAnnotation(Attribute.class) != null) {
                info.annotationType = 1;
            } else if (field.getAnnotation(Element.class) != null) {
                info.annotationType = 2;
            }
            switch (info.fieldType) {
                case 1: {
                    info.component = field.getType().getComponentType();
                    info.componentType = Utils.getClassType(info.component);
                    break;
                }
                case 2: {
                    info.component = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                    info.componentType = Utils.getClassType(info.component);
                }
            }
            if (Utils.isDefaultValueField(field)) {
                table.defaultField = info;
                continue;
            }
            info.name = name = Utils.getFieldName(field);
            table.fieldInfos.put(name, info);
        }
        return table;
    }

    public static String getFieldName(Field field) {
        String value;
        String name = field.getName();
        SerializedName sn = field.getAnnotation(SerializedName.class);
        if (sn != null && (value = sn.value()) != null) {
            name = value;
        }
        return name;
    }

    public static boolean isDefaultValueField(Field field) {
        DefaultValueField dv = field.getAnnotation(DefaultValueField.class);
        return dv != null;
    }
}

