/*
 * Decompiled with CFR 0.152.
 */
package com.begentgroup.xmlparser;

import com.begentgroup.xmlparser.ArrayData;
import com.begentgroup.xmlparser.ClassInfoTable;
import com.begentgroup.xmlparser.DataUnit;
import com.begentgroup.xmlparser.FieldInfo;
import com.begentgroup.xmlparser.SimpleParseException;
import com.begentgroup.xmlparser.Utils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.Stack;
import org.xml.sax.Attributes;

class DataCollector {
    public static HashMap<Class, ClassInfoTable> sClassInfo = new HashMap();
    public static Object sNullObject = new Object();
    Stack<DataUnit> mStack = new Stack();

    public DataCollector(String elementName, Object object, Class clazz, int level) {
        this.pushDataUnit(elementName, clazz, object, level);
    }

    public void startElement(String tag, Attributes attributes, int level) {
        if (this.mStack.size() == 0) {
            return;
        }
        DataUnit unit = this.mStack.peek();
        if (unit.level + 1 == level) {
            try {
                FieldInfo fi = unit.tables.fieldInfos.get(tag);
                if (fi == null) {
                    return;
                }
                Field f = fi.f;
                f.setAccessible(true);
                switch (fi.fieldType) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        Class childClass = fi.component;
                        if (fi.componentType != 3) break;
                        Object obj = childClass.newInstance();
                        ArrayData ad = unit.arrayData.get(fi.name);
                        ad.array.add(obj);
                        this.pushDataUnit(tag, childClass, obj, level);
                        break;
                    }
                    case 2: {
                        Class cc = fi.component;
                        if (fi.componentType != 3) break;
                        Object obj = cc.newInstance();
                        Collection collection = (Collection)f.get(unit.mObject);
                        collection.add(obj);
                        this.pushDataUnit(tag, cc, obj, level);
                        break;
                    }
                    case 3: {
                        Object value = f.getType().newInstance();
                        f.set(unit.mObject, value);
                        this.pushDataUnit(tag, f.getType(), value, level);
                    }
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        unit = this.mStack.peek();
        if (unit.level == level) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String qName = attributes.getQName(i);
                FieldInfo fi = unit.tables.fieldInfos.get(qName);
                if (fi == null) continue;
                Field f = fi.f;
                f.setAccessible(true);
                this.setPrimitiveValue(unit.mObject, f, attributes.getValue(i));
            }
        }
    }

    public void endElement(String tag, String content, int level) {
        if (this.mStack.size() == 0) {
            return;
        }
        DataUnit unit = this.mStack.peek();
        if (unit.level == level && unit.elementName.equals(tag)) {
            HashMap<String, ArrayData> arrayData = unit.arrayData;
            Set<String> keys = arrayData.keySet();
            for (String key : keys) {
                ArrayData ad = arrayData.get(key);
                Field f = ad.field;
                Class<?> cc = f.getType().getComponentType();
                ArrayList al = ad.array;
                Object values = Array.newInstance(cc, al.size());
                for (int i = 0; i < al.size(); ++i) {
                    this.setArrayValue(values, i, al.get(i), cc);
                }
                try {
                    f.set(unit.mObject, values);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            if (unit.defaultNameField != null) {
                this.setPrimitiveValue(unit.mObject, unit.defaultNameField.f, content);
            }
            this.mStack.pop();
        } else if (unit.level + 1 == level) {
            try {
                FieldInfo fi = unit.tables.fieldInfos.get(tag);
                if (fi == null) {
                    return;
                }
                Field f = fi.f;
                int type = fi.fieldType;
                switch (type) {
                    case 0: {
                        this.setPrimitiveValue(unit.mObject, f, content);
                        break;
                    }
                    case 1: {
                        if (fi.componentType != 0) break;
                        ArrayList al = unit.arrayData.get((Object)fi.name).array;
                        this.setCollectionValue(al, fi.component, content);
                        break;
                    }
                    case 2: {
                        if (fi.componentType != 0) break;
                        Collection collection = (Collection)f.get(unit.mObject);
                        this.setCollectionValue(collection, fi.component, content);
                        break;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new SimpleParseException(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new SimpleParseException(e.getMessage(), e);
            }
        }
    }

    public void pushDataUnit(String elementName, Class clazz, Object object, int level) {
        DataUnit childUnit = new DataUnit();
        childUnit.elementName = elementName;
        childUnit.clazz = clazz;
        childUnit.mObject = object;
        childUnit.level = level;
        ClassInfoTable table = sClassInfo.get(clazz);
        if (table == null) {
            table = Utils.makeClassInfoTable(clazz);
            sClassInfo.put(clazz, table);
        }
        childUnit.tables = table;
        if (object.getClass() == clazz && Utils.getClassType(clazz) == 3) {
            Field[] fields;
            for (Field field : fields = table.fields) {
                if (Utils.isDefaultValueField(field)) {
                    childUnit.defaultNameField = table.defaultField;
                    continue;
                }
                String name = Utils.getFieldName(field);
                FieldInfo fi = table.fieldInfos.get(name);
                int type = fi.fieldType;
                if (type == 2) {
                    try {
                        Object value = field.getType().newInstance();
                        field.set(object, value);
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (type != 1) continue;
                ArrayData ad = new ArrayData();
                ad.field = field;
                childUnit.arrayData.put(name, ad);
            }
        }
        this.mStack.push(childUnit);
    }

    public boolean setPrimitiveValue(Object obj, Field f, String value) {
        if (value == null || value.equals("")) {
            return false;
        }
        try {
            if (f.getType() == Integer.TYPE) {
                f.setInt(obj, Integer.parseInt(value));
            } else if (f.getType() == Integer.class) {
                f.set(obj, Integer.parseInt(value));
            } else if (f.getType() == Boolean.TYPE) {
                f.setBoolean(obj, Boolean.parseBoolean(value));
            } else if (f.getType() == Boolean.class) {
                f.set(obj, Boolean.parseBoolean(value));
            } else if (f.getType() == Byte.TYPE) {
                f.setByte(obj, Byte.parseByte(value));
            } else if (f.getType() == Byte.class) {
                f.set(obj, Byte.parseByte(value));
            } else if (f.getType() == Character.TYPE) {
                f.setChar(obj, value.charAt(0));
            } else if (f.getType() == Character.class) {
                f.set(obj, Character.valueOf(value.charAt(0)));
            } else if (f.getType() == Double.TYPE) {
                f.setDouble(obj, Double.parseDouble(value));
            } else if (f.getType() == Double.class) {
                f.set(obj, Double.parseDouble(value));
            } else if (f.getType() == Float.TYPE) {
                f.setFloat(obj, Float.parseFloat(value));
            } else if (f.getType() == Float.class) {
                f.set(obj, Float.valueOf(Float.parseFloat(value)));
            } else if (f.getType() == Long.TYPE) {
                f.setLong(obj, Long.parseLong(value));
            } else if (f.getType() == Long.class) {
                f.set(obj, Long.parseLong(value));
            } else if (f.getType() == Short.TYPE) {
                f.setShort(obj, Short.parseShort(value));
            } else if (f.getType() == Short.class) {
                f.set(obj, Short.parseShort(value));
            } else if (f.getType() == String.class) {
                f.set(obj, value);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            throw new SimpleParseException(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new SimpleParseException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new SimpleParseException(e.getMessage(), e);
        }
        return true;
    }

    private boolean setCollectionValue(Collection collection, Class gc, String value) {
        if (value == null || value.equals("")) {
            return false;
        }
        try {
            if (gc == Integer.TYPE || gc == Integer.class) {
                collection.add(Integer.parseInt(value));
            } else if (gc == Boolean.TYPE || gc == Boolean.class) {
                collection.add(Boolean.parseBoolean(value));
            } else if (gc == Byte.TYPE || gc == Byte.class) {
                collection.add(Byte.parseByte(value));
            } else if (gc == Character.TYPE || gc == Character.class) {
                collection.add(Character.valueOf(value.charAt(0)));
            } else if (gc == Double.TYPE || gc == Double.class) {
                collection.add(Double.parseDouble(value));
            } else if (gc == Float.TYPE || gc == Float.class) {
                collection.add(Float.valueOf(Float.parseFloat(value)));
            } else if (gc == Long.TYPE || gc == Long.class) {
                collection.add(Long.parseLong(value));
            } else if (gc == Short.TYPE || gc == Short.class) {
                collection.add(Short.parseShort(value));
            } else if (gc == String.class) {
                collection.add(value);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            throw new SimpleParseException(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new SimpleParseException(e.getMessage(), e);
        }
        return true;
    }

    private void setArrayValue(Object array, int index, Object value, Class cc) {
        if (cc == Integer.TYPE) {
            Array.setInt(array, index, (Integer)value);
        } else if (cc == Boolean.TYPE) {
            Array.setBoolean(array, index, (Boolean)value);
        } else if (cc == Byte.TYPE) {
            Array.setChar(array, index, ((Character)value).charValue());
        } else if (cc == Double.TYPE) {
            Array.setDouble(array, index, (Double)value);
        } else if (cc == Float.TYPE) {
            Array.setFloat(array, index, ((Float)value).floatValue());
        } else if (cc == Long.TYPE) {
            Array.setLong(array, index, (Long)value);
        } else if (cc == Short.TYPE) {
            Array.setShort(array, index, (Short)value);
        } else {
            Array.set(array, index, value);
        }
    }
}

