/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.file;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.apache.cordova.CordovaResourceApi;
import org.apache.cordova.file.DirectoryManager;
import org.apache.cordova.file.EncodingException;
import org.apache.cordova.file.FileExistsException;
import org.apache.cordova.file.Filesystem;
import org.apache.cordova.file.InvalidModificationException;
import org.apache.cordova.file.LocalFilesystemURL;
import org.apache.cordova.file.NoModificationAllowedException;
import org.apache.cordova.file.TypeMismatchException;
import org.json.JSONException;
import org.json.JSONObject;

public class LocalFilesystem
extends Filesystem {
    private final Context context;

    public LocalFilesystem(String name, Context context, CordovaResourceApi resourceApi, File fsRoot) {
        super(Uri.fromFile((File)fsRoot).buildUpon().appendEncodedPath("").build(), name, resourceApi);
        this.context = context;
    }

    public String filesystemPathForFullPath(String fullPath) {
        return new File(this.rootUri.getPath(), fullPath).toString();
    }

    @Override
    public String filesystemPathForURL(LocalFilesystemURL url) {
        return this.filesystemPathForFullPath(url.path);
    }

    private String fullPathForFilesystemPath(String absolutePath) {
        if (absolutePath != null && absolutePath.startsWith(this.rootUri.getPath())) {
            return absolutePath.substring(this.rootUri.getPath().length() - 1);
        }
        return null;
    }

    @Override
    public Uri toNativeUri(LocalFilesystemURL inputURL) {
        return this.nativeUriForFullPath(inputURL.path);
    }

    @Override
    public LocalFilesystemURL toLocalUri(Uri inputURL) {
        if (!"file".equals(inputURL.getScheme())) {
            return null;
        }
        File f = new File(inputURL.getPath());
        Uri resolvedUri = Uri.fromFile((File)f);
        String rootUriNoTrailingSlash = this.rootUri.getEncodedPath();
        rootUriNoTrailingSlash = rootUriNoTrailingSlash.substring(0, rootUriNoTrailingSlash.length() - 1);
        if (!resolvedUri.getEncodedPath().startsWith(rootUriNoTrailingSlash)) {
            return null;
        }
        String subPath = resolvedUri.getEncodedPath().substring(rootUriNoTrailingSlash.length());
        if (!subPath.isEmpty()) {
            subPath = subPath.substring(1);
        }
        Uri.Builder b = new Uri.Builder().scheme("cdvfile").authority("localhost").path(this.name);
        if (!subPath.isEmpty()) {
            b.appendEncodedPath(subPath);
        }
        if (f.isDirectory() || inputURL.getPath().endsWith("/")) {
            b.appendEncodedPath("");
        }
        return LocalFilesystemURL.parse(b.build());
    }

    @Override
    public LocalFilesystemURL URLforFilesystemPath(String path) {
        return this.localUrlforFullPath(this.fullPathForFilesystemPath(path));
    }

    @Override
    public JSONObject getFileForLocalURL(LocalFilesystemURL inputURL, String path, JSONObject options, boolean directory) throws FileExistsException, IOException, TypeMismatchException, EncodingException, JSONException {
        boolean create = false;
        boolean exclusive = false;
        if (options != null && (create = options.optBoolean("create"))) {
            exclusive = options.optBoolean("exclusive");
        }
        if (path.contains(":")) {
            throw new EncodingException("This path has an invalid \":\" in it.");
        }
        if (directory && !path.endsWith("/")) {
            path = path + "/";
        }
        LocalFilesystemURL requestedURL = path.startsWith("/") ? this.localUrlforFullPath(LocalFilesystem.normalizePath(path)) : this.localUrlforFullPath(LocalFilesystem.normalizePath(inputURL.path + "/" + path));
        File fp = new File(this.filesystemPathForURL(requestedURL));
        if (create) {
            if (exclusive && fp.exists()) {
                throw new FileExistsException("create/exclusive fails");
            }
            if (directory) {
                fp.mkdir();
            } else {
                fp.createNewFile();
            }
            if (!fp.exists()) {
                throw new FileExistsException("create fails");
            }
        } else {
            if (!fp.exists()) {
                throw new FileNotFoundException("path does not exist");
            }
            if (directory) {
                if (fp.isFile()) {
                    throw new TypeMismatchException("path doesn't exist or is file");
                }
            } else if (fp.isDirectory()) {
                throw new TypeMismatchException("path doesn't exist or is directory");
            }
        }
        return this.makeEntryForURL(requestedURL);
    }

    @Override
    public boolean removeFileAtLocalURL(LocalFilesystemURL inputURL) throws InvalidModificationException {
        File fp = new File(this.filesystemPathForURL(inputURL));
        if (fp.isDirectory() && fp.list().length > 0) {
            throw new InvalidModificationException("You can't delete a directory that is not empty.");
        }
        return fp.delete();
    }

    @Override
    public boolean exists(LocalFilesystemURL inputURL) {
        File fp = new File(this.filesystemPathForURL(inputURL));
        return fp.exists();
    }

    @Override
    public long getFreeSpaceInBytes() {
        return DirectoryManager.getFreeSpaceInBytes(this.rootUri.getPath());
    }

    @Override
    public boolean recursiveRemoveFileAtLocalURL(LocalFilesystemURL inputURL) throws FileExistsException {
        File directory = new File(this.filesystemPathForURL(inputURL));
        return this.removeDirRecursively(directory);
    }

    protected boolean removeDirRecursively(File directory) throws FileExistsException {
        if (directory.isDirectory()) {
            for (File file : directory.listFiles()) {
                this.removeDirRecursively(file);
            }
        }
        if (!directory.delete()) {
            throw new FileExistsException("could not delete: " + directory.getName());
        }
        return true;
    }

    @Override
    public LocalFilesystemURL[] listChildren(LocalFilesystemURL inputURL) throws FileNotFoundException {
        File fp = new File(this.filesystemPathForURL(inputURL));
        if (!fp.exists()) {
            throw new FileNotFoundException();
        }
        File[] files = fp.listFiles();
        if (files == null) {
            return null;
        }
        LocalFilesystemURL[] entries = new LocalFilesystemURL[files.length];
        for (int i = 0; i < files.length; ++i) {
            entries[i] = this.URLforFilesystemPath(files[i].getPath());
        }
        return entries;
    }

    @Override
    public JSONObject getFileMetadataForLocalURL(LocalFilesystemURL inputURL) throws FileNotFoundException {
        File file = new File(this.filesystemPathForURL(inputURL));
        if (!file.exists()) {
            throw new FileNotFoundException("File at " + inputURL.uri + " does not exist.");
        }
        JSONObject metadata = new JSONObject();
        try {
            metadata.put("size", file.isDirectory() ? 0L : file.length());
            metadata.put("type", (Object)this.resourceApi.getMimeType(Uri.fromFile((File)file)));
            metadata.put("name", (Object)file.getName());
            metadata.put("fullPath", (Object)inputURL.path);
            metadata.put("lastModifiedDate", file.lastModified());
        }
        catch (JSONException e) {
            return null;
        }
        return metadata;
    }

    private void copyFile(Filesystem srcFs, LocalFilesystemURL srcURL, File destFile, boolean move) throws IOException, InvalidModificationException, NoModificationAllowedException {
        File srcFile;
        String realSrcPath;
        if (move && (realSrcPath = srcFs.filesystemPathForURL(srcURL)) != null && (srcFile = new File(realSrcPath)).renameTo(destFile)) {
            return;
        }
        CordovaResourceApi.OpenForReadResult offr = this.resourceApi.openForRead(srcFs.toNativeUri(srcURL));
        LocalFilesystem.copyResource(offr, new FileOutputStream(destFile));
        if (move) {
            srcFs.removeFileAtLocalURL(srcURL);
        }
    }

    private void copyDirectory(Filesystem srcFs, LocalFilesystemURL srcURL, File dstDir, boolean move) throws IOException, NoModificationAllowedException, InvalidModificationException, FileExistsException {
        LocalFilesystemURL[] children;
        String realSrcPath;
        if (move && (realSrcPath = srcFs.filesystemPathForURL(srcURL)) != null) {
            File srcDir = new File(realSrcPath);
            if (dstDir.exists()) {
                if (dstDir.list().length > 0) {
                    throw new InvalidModificationException("directory is not empty");
                }
                dstDir.delete();
            }
            if (srcDir.renameTo(dstDir)) {
                return;
            }
        }
        if (dstDir.exists()) {
            if (dstDir.list().length > 0) {
                throw new InvalidModificationException("directory is not empty");
            }
        } else if (!dstDir.mkdir()) {
            throw new NoModificationAllowedException("Couldn't create the destination directory");
        }
        for (LocalFilesystemURL childLocalUrl : children = srcFs.listChildren(srcURL)) {
            File target = new File(dstDir, new File(childLocalUrl.path).getName());
            if (childLocalUrl.isDirectory) {
                this.copyDirectory(srcFs, childLocalUrl, target, false);
                continue;
            }
            this.copyFile(srcFs, childLocalUrl, target, false);
        }
        if (move) {
            srcFs.recursiveRemoveFileAtLocalURL(srcURL);
        }
    }

    @Override
    public JSONObject copyFileToURL(LocalFilesystemURL destURL, String newName, Filesystem srcFs, LocalFilesystemURL srcURL, boolean move) throws IOException, InvalidModificationException, JSONException, NoModificationAllowedException, FileExistsException {
        Uri srcNativeUri;
        String newParent = this.filesystemPathForURL(destURL);
        File destinationDir = new File(newParent);
        if (!destinationDir.exists()) {
            throw new FileNotFoundException("The source does not exist");
        }
        LocalFilesystemURL destinationURL = this.makeDestinationURL(newName, srcURL, destURL, srcURL.isDirectory);
        Uri dstNativeUri = this.toNativeUri(destinationURL);
        if (dstNativeUri.equals((Object)(srcNativeUri = srcFs.toNativeUri(srcURL)))) {
            throw new InvalidModificationException("Can't copy onto itself");
        }
        if (move && !srcFs.canRemoveFileAtLocalURL(srcURL)) {
            throw new InvalidModificationException("Source URL is read-only (cannot move)");
        }
        File destFile = new File(dstNativeUri.getPath());
        if (destFile.exists()) {
            if (!srcURL.isDirectory && destFile.isDirectory()) {
                throw new InvalidModificationException("Can't copy/move a file to an existing directory");
            }
            if (srcURL.isDirectory && destFile.isFile()) {
                throw new InvalidModificationException("Can't copy/move a directory to an existing file");
            }
        }
        if (srcURL.isDirectory) {
            if (dstNativeUri.toString().startsWith(srcNativeUri.toString() + '/')) {
                throw new InvalidModificationException("Can't copy directory into itself");
            }
            this.copyDirectory(srcFs, srcURL, destFile, move);
        } else {
            this.copyFile(srcFs, srcURL, destFile, move);
        }
        return this.makeEntryForURL(destinationURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long writeToFileAtURL(LocalFilesystemURL inputURL, String data, int offset, boolean isBinary) throws IOException, NoModificationAllowedException {
        boolean append = false;
        if (offset > 0) {
            this.truncateFileAtURL(inputURL, offset);
            append = true;
        }
        byte[] rawData = isBinary ? Base64.decode((String)data, (int)0) : data.getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(rawData);
        try {
            byte[] buff = new byte[rawData.length];
            String absolutePath = this.filesystemPathForURL(inputURL);
            try (FileOutputStream out = new FileOutputStream(absolutePath, append);){
                in.read(buff, 0, buff.length);
                out.write(buff, 0, rawData.length);
                out.flush();
            }
            if (this.isPublicDirectory(absolutePath)) {
                this.broadcastNewFile(Uri.fromFile((File)new File(absolutePath)));
            }
        }
        catch (NullPointerException e) {
            NoModificationAllowedException realException = new NoModificationAllowedException(inputURL.toString());
            throw realException;
        }
        return rawData.length;
    }

    private boolean isPublicDirectory(String absolutePath) {
        if (Build.VERSION.SDK_INT >= 21) {
            for (File f : this.context.getExternalMediaDirs()) {
                if (f == null || !absolutePath.startsWith(f.getAbsolutePath())) continue;
                return true;
            }
        }
        String extPath = Environment.getExternalStorageDirectory().getAbsolutePath();
        return absolutePath.startsWith(extPath);
    }

    private void broadcastNewFile(Uri nativeUri) {
        Intent intent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", nativeUri);
        this.context.sendBroadcast(intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long truncateFileAtURL(LocalFilesystemURL inputURL, long size) throws IOException {
        File file = new File(this.filesystemPathForURL(inputURL));
        if (!file.exists()) {
            throw new FileNotFoundException("File at " + inputURL.uri + " does not exist.");
        }
        try (RandomAccessFile raf = new RandomAccessFile(this.filesystemPathForURL(inputURL), "rw");){
            if (raf.length() >= size) {
                FileChannel channel = raf.getChannel();
                channel.truncate(size);
                long l = size;
                return l;
            }
            long l = raf.length();
            return l;
        }
    }

    @Override
    public boolean canRemoveFileAtLocalURL(LocalFilesystemURL inputURL) {
        String path = this.filesystemPathForURL(inputURL);
        File file = new File(path);
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyResource(CordovaResourceApi.OpenForReadResult input, OutputStream outputStream) throws IOException {
        block8: {
            try {
                int bytesRead;
                InputStream inputStream = input.inputStream;
                if (inputStream instanceof FileInputStream && outputStream instanceof FileOutputStream) {
                    FileChannel inChannel = ((FileInputStream)input.inputStream).getChannel();
                    FileChannel outChannel = ((FileOutputStream)outputStream).getChannel();
                    long offset = 0L;
                    long length = input.length;
                    if (input.assetFd != null) {
                        offset = input.assetFd.getStartOffset();
                    }
                    inChannel.position(offset);
                    outChannel.transferFrom(inChannel, 0L, length);
                    break block8;
                }
                int BUFFER_SIZE = 8192;
                byte[] buffer = new byte[8192];
                while ((bytesRead = inputStream.read(buffer, 0, 8192)) > 0) {
                    outputStream.write(buffer, 0, bytesRead);
                }
            }
            finally {
                input.inputStream.close();
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
    }
}

