/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.whitelist;

import android.content.Context;
import android.util.Log;
import org.apache.cordova.ConfigXmlParser;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.Whitelist;
import org.xmlpull.v1.XmlPullParser;

public class WhitelistPlugin
extends CordovaPlugin {
    private static final String LOG_TAG = "WhitelistPlugin";
    private Whitelist allowedNavigations;
    private Whitelist allowedIntents;
    private Whitelist allowedRequests;

    public WhitelistPlugin() {
    }

    public WhitelistPlugin(Context context) {
        this(new Whitelist(), new Whitelist(), null);
        new CustomConfigXmlParser().parse(context);
    }

    public WhitelistPlugin(XmlPullParser xmlParser) {
        this(new Whitelist(), new Whitelist(), null);
        new CustomConfigXmlParser().parse(xmlParser);
    }

    public WhitelistPlugin(Whitelist allowedNavigations, Whitelist allowedIntents, Whitelist allowedRequests) {
        if (allowedRequests == null) {
            allowedRequests = new Whitelist();
            allowedRequests.addWhiteListEntry("file:///*", false);
            allowedRequests.addWhiteListEntry("data:*", false);
        }
        this.allowedNavigations = allowedNavigations;
        this.allowedIntents = allowedIntents;
        this.allowedRequests = allowedRequests;
    }

    public void pluginInitialize() {
        if (this.allowedNavigations == null) {
            this.allowedNavigations = new Whitelist();
            this.allowedIntents = new Whitelist();
            this.allowedRequests = new Whitelist();
            new CustomConfigXmlParser().parse(this.webView.getContext());
        }
    }

    public Boolean shouldAllowNavigation(String url) {
        if (this.allowedNavigations.isUrlWhiteListed(url)) {
            return true;
        }
        return null;
    }

    public Boolean shouldAllowRequest(String url) {
        if (Boolean.TRUE == this.shouldAllowNavigation(url)) {
            return true;
        }
        if (this.allowedRequests.isUrlWhiteListed(url)) {
            return true;
        }
        return null;
    }

    public Boolean shouldOpenExternalUrl(String url) {
        if (this.allowedIntents.isUrlWhiteListed(url)) {
            return true;
        }
        return null;
    }

    public Whitelist getAllowedNavigations() {
        return this.allowedNavigations;
    }

    public void setAllowedNavigations(Whitelist allowedNavigations) {
        this.allowedNavigations = allowedNavigations;
    }

    public Whitelist getAllowedIntents() {
        return this.allowedIntents;
    }

    public void setAllowedIntents(Whitelist allowedIntents) {
        this.allowedIntents = allowedIntents;
    }

    public Whitelist getAllowedRequests() {
        return this.allowedRequests;
    }

    public void setAllowedRequests(Whitelist allowedRequests) {
        this.allowedRequests = allowedRequests;
    }

    private class CustomConfigXmlParser
    extends ConfigXmlParser {
        private CustomConfigXmlParser() {
        }

        public void handleStartTag(XmlPullParser xml) {
            String strNode = xml.getName();
            if (strNode.equals("content")) {
                String startPage = xml.getAttributeValue(null, "src");
                WhitelistPlugin.this.allowedNavigations.addWhiteListEntry(startPage, false);
            } else if (strNode.equals("allow-navigation")) {
                String origin = xml.getAttributeValue(null, "href");
                if ("*".equals(origin)) {
                    WhitelistPlugin.this.allowedNavigations.addWhiteListEntry("http://*/*", false);
                    WhitelistPlugin.this.allowedNavigations.addWhiteListEntry("https://*/*", false);
                    WhitelistPlugin.this.allowedNavigations.addWhiteListEntry("data:*", false);
                } else {
                    WhitelistPlugin.this.allowedNavigations.addWhiteListEntry(origin, false);
                }
            } else if (strNode.equals("allow-intent")) {
                String origin = xml.getAttributeValue(null, "href");
                WhitelistPlugin.this.allowedIntents.addWhiteListEntry(origin, false);
            } else if (strNode.equals("access")) {
                boolean external;
                String origin = xml.getAttributeValue(null, "origin");
                String subdomains = xml.getAttributeValue(null, "subdomains");
                boolean bl = external = xml.getAttributeValue(null, "launch-external") != null;
                if (origin != null) {
                    if (external) {
                        Log.w((String)WhitelistPlugin.LOG_TAG, (String)"Found <access launch-external> within config.xml. Please use <allow-intent> instead.");
                        WhitelistPlugin.this.allowedIntents.addWhiteListEntry(origin, subdomains != null && subdomains.compareToIgnoreCase("true") == 0);
                    } else if ("*".equals(origin)) {
                        WhitelistPlugin.this.allowedRequests.addWhiteListEntry("http://*/*", false);
                        WhitelistPlugin.this.allowedRequests.addWhiteListEntry("https://*/*", false);
                    } else {
                        WhitelistPlugin.this.allowedRequests.addWhiteListEntry(origin, subdomains != null && subdomains.compareToIgnoreCase("true") == 0);
                    }
                }
            }
        }

        public void handleEndTag(XmlPullParser xml) {
        }
    }
}

