/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.filetransfer;

import android.net.Uri;
import android.os.Build;
import android.util.Log;
import android.webkit.CookieManager;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaResourceApi;
import org.apache.cordova.PluginManager;
import org.apache.cordova.PluginResult;
import org.apache.cordova.Whitelist;
import org.apache.cordova.filetransfer.FileProgressResult;
import org.apache.cordova.filetransfer.FileUploadResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FileTransfer
extends CordovaPlugin {
    private static final String LOG_TAG = "FileTransfer";
    private static final String LINE_START = "--";
    private static final String LINE_END = "\r\n";
    private static final String BOUNDARY = "+++++";
    public static int FILE_NOT_FOUND_ERR = 1;
    public static int INVALID_URL_ERR = 2;
    public static int CONNECTION_ERR = 3;
    public static int ABORTED_ERR = 4;
    public static int NOT_MODIFIED_ERR = 5;
    private static HashMap<String, RequestContext> activeRequests = new HashMap();
    private static final int MAX_BUFFER_SIZE = 16384;
    private static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };
    private static final TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }};

    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        if (action.equals("upload") || action.equals("download")) {
            String source = args.getString(0);
            String target = args.getString(1);
            if (action.equals("upload")) {
                this.upload(source, target, args, callbackContext);
            } else {
                this.download(source, target, args, callbackContext);
            }
            return true;
        }
        if (action.equals("abort")) {
            String objectId = args.getString(0);
            this.abort(objectId);
            callbackContext.success();
            return true;
        }
        return false;
    }

    private static void addHeadersToRequest(URLConnection connection, JSONObject headers) {
        try {
            Iterator iter = headers.keys();
            while (iter.hasNext()) {
                String headerKey = iter.next().toString();
                String cleanHeaderKey = headerKey.replaceAll("\\n", "").replaceAll("\\s+", "").replaceAll(":", "").replaceAll("[^\\x20-\\x7E]+", "");
                JSONArray headerValues = headers.optJSONArray(headerKey);
                if (headerValues == null) {
                    headerValues = new JSONArray();
                    String headerValue = headers.getString(headerKey);
                    String finalValue = headerValue.replaceAll("\\s+", " ").replaceAll("\\n", " ").replaceAll("[^\\x20-\\x7E]+", " ");
                    headerValues.put((Object)finalValue);
                }
                connection.setRequestProperty(cleanHeaderKey, headerValues.getString(0));
                for (int i = 1; i < headerValues.length(); ++i) {
                    connection.addRequestProperty(headerKey, headerValues.getString(i));
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private String getCookies(String target) {
        boolean gotCookie = false;
        String cookie = null;
        Class<?> webViewClass = this.webView.getClass();
        try {
            Method gcmMethod = webViewClass.getMethod("getCookieManager", new Class[0]);
            Class<?> iccmClass = gcmMethod.getReturnType();
            Method gcMethod = iccmClass.getMethod("getCookie", String.class);
            cookie = (String)gcMethod.invoke(iccmClass.cast(gcmMethod.invoke((Object)this.webView, new Object[0])), target);
            gotCookie = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (!gotCookie && CookieManager.getInstance() != null) {
            cookie = CookieManager.getInstance().getCookie(target);
        }
        return cookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upload(final String source, final String target, JSONArray args, CallbackContext callbackContext) throws JSONException {
        boolean useHttps;
        Log.d((String)LOG_TAG, (String)("upload " + source + " to " + target));
        final String fileKey = FileTransfer.getArgument(args, 2, "file");
        final String fileName = FileTransfer.getArgument(args, 3, "image.jpg");
        final String mimeType = FileTransfer.getArgument(args, 4, "image/jpeg");
        final JSONObject params = args.optJSONObject(5) == null ? new JSONObject() : args.optJSONObject(5);
        final boolean trustEveryone = args.optBoolean(6);
        final boolean chunkedMode = args.optBoolean(7) || args.isNull(7);
        final JSONObject headers = args.optJSONObject(8) == null ? params.optJSONObject("headers") : args.optJSONObject(8);
        final String objectId = args.getString(9);
        final String httpMethod = FileTransfer.getArgument(args, 10, "POST");
        final CordovaResourceApi resourceApi = this.webView.getResourceApi();
        Log.d((String)LOG_TAG, (String)("fileKey: " + fileKey));
        Log.d((String)LOG_TAG, (String)("fileName: " + fileName));
        Log.d((String)LOG_TAG, (String)("mimeType: " + mimeType));
        Log.d((String)LOG_TAG, (String)("params: " + params));
        Log.d((String)LOG_TAG, (String)("trustEveryone: " + trustEveryone));
        Log.d((String)LOG_TAG, (String)("chunkedMode: " + chunkedMode));
        Log.d((String)LOG_TAG, (String)("headers: " + headers));
        Log.d((String)LOG_TAG, (String)("objectId: " + objectId));
        Log.d((String)LOG_TAG, (String)("httpMethod: " + httpMethod));
        final Uri targetUri = resourceApi.remapUri(Uri.parse((String)target));
        Uri tmpSrc = Uri.parse((String)source);
        final Uri sourceUri = resourceApi.remapUri(tmpSrc.getScheme() != null ? tmpSrc : Uri.fromFile((File)new File(source)));
        int uriType = CordovaResourceApi.getUriType((Uri)targetUri);
        boolean bl = useHttps = uriType == 6;
        if (uriType != 5 && !useHttps) {
            JSONObject error = FileTransfer.createFileTransferError(INVALID_URL_ERR, source, target, null, 0, null);
            Log.e((String)LOG_TAG, (String)("Unsupported URI: " + targetUri));
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.IO_EXCEPTION, error));
            return;
        }
        final RequestContext context = new RequestContext(source, target, callbackContext);
        HashMap<String, RequestContext> hashMap = activeRequests;
        synchronized (hashMap) {
            activeRequests.put(objectId, context);
        }
        this.cordova.getThreadPool().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JSONObject error;
                if (context.aborted) {
                    return;
                }
                HttpURLConnection conn = null;
                HostnameVerifier oldHostnameVerifier = null;
                SSLSocketFactory oldSocketFactory = null;
                int totalBytes = 0;
                int fixedLength = -1;
                try {
                    String responseString;
                    String cookie;
                    boolean multipartFormUpload;
                    FileUploadResult result = new FileUploadResult();
                    FileProgressResult progress = new FileProgressResult();
                    conn = resourceApi.createHttpConnection(targetUri);
                    if (useHttps && trustEveryone) {
                        HttpsURLConnection https = (HttpsURLConnection)conn;
                        oldSocketFactory = FileTransfer.trustAllHosts(https);
                        oldHostnameVerifier = https.getHostnameVerifier();
                        https.setHostnameVerifier(DO_NOT_VERIFY);
                    }
                    conn.setDoInput(true);
                    conn.setDoOutput(true);
                    conn.setUseCaches(false);
                    conn.setRequestMethod(httpMethod);
                    boolean bl = multipartFormUpload = headers == null || !headers.has("Content-Type");
                    if (multipartFormUpload) {
                        conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=+++++");
                    }
                    if ((cookie = FileTransfer.this.getCookies(target)) != null) {
                        conn.setRequestProperty("Cookie", cookie);
                    }
                    if (headers != null) {
                        FileTransfer.addHeadersToRequest(conn, headers);
                    }
                    StringBuilder beforeData = new StringBuilder();
                    try {
                        Iterator iter = params.keys();
                        while (iter.hasNext()) {
                            Object key = iter.next();
                            if (String.valueOf(key).equals("headers")) continue;
                            beforeData.append(FileTransfer.LINE_START).append(FileTransfer.BOUNDARY).append(FileTransfer.LINE_END);
                            beforeData.append("Content-Disposition: form-data; name=\"").append(key.toString()).append('\"');
                            beforeData.append(FileTransfer.LINE_END).append(FileTransfer.LINE_END);
                            beforeData.append(params.getString(key.toString()));
                            beforeData.append(FileTransfer.LINE_END);
                        }
                    }
                    catch (JSONException e) {
                        Log.e((String)FileTransfer.LOG_TAG, (String)e.getMessage(), (Throwable)e);
                    }
                    beforeData.append(FileTransfer.LINE_START).append(FileTransfer.BOUNDARY).append(FileTransfer.LINE_END);
                    beforeData.append("Content-Disposition: form-data; name=\"").append(fileKey).append("\";");
                    beforeData.append(" filename=\"").append(fileName).append('\"').append(FileTransfer.LINE_END);
                    beforeData.append("Content-Type: ").append(mimeType).append(FileTransfer.LINE_END).append(FileTransfer.LINE_END);
                    byte[] beforeDataBytes = beforeData.toString().getBytes("UTF-8");
                    byte[] tailParamsBytes = "\r\n--+++++--\r\n".getBytes("UTF-8");
                    CordovaResourceApi.OpenForReadResult readResult = resourceApi.openForRead(sourceUri);
                    int stringLength = beforeDataBytes.length + tailParamsBytes.length;
                    if (readResult.length >= 0L) {
                        fixedLength = (int)readResult.length;
                        if (multipartFormUpload) {
                            fixedLength += stringLength;
                        }
                        progress.setLengthComputable(true);
                        progress.setTotal(fixedLength);
                    }
                    Log.d((String)FileTransfer.LOG_TAG, (String)("Content Length: " + fixedLength));
                    boolean useChunkedMode = chunkedMode && (Build.VERSION.SDK_INT < 8 || useHttps);
                    boolean bl2 = useChunkedMode = useChunkedMode || fixedLength == -1;
                    if (useChunkedMode) {
                        conn.setChunkedStreamingMode(16384);
                        conn.setRequestProperty("Transfer-Encoding", "chunked");
                    } else {
                        conn.setFixedLengthStreamingMode(fixedLength);
                    }
                    conn.connect();
                    OutputStream sendStream = null;
                    try {
                        sendStream = conn.getOutputStream();
                        RequestContext requestContext = context;
                        synchronized (requestContext) {
                            block83: {
                                if (!context.aborted) break block83;
                                return;
                            }
                            context.connection = conn;
                        }
                        if (multipartFormUpload) {
                            sendStream.write(beforeDataBytes);
                            totalBytes += beforeDataBytes.length;
                        }
                        int bytesAvailable = readResult.inputStream.available();
                        int bufferSize = Math.min(bytesAvailable, 16384);
                        byte[] buffer = new byte[bufferSize];
                        int bytesRead = readResult.inputStream.read(buffer, 0, bufferSize);
                        long prevBytesRead = 0L;
                        while (bytesRead > 0) {
                            result.setBytesSent(totalBytes += bytesRead);
                            sendStream.write(buffer, 0, bytesRead);
                            if ((long)totalBytes > prevBytesRead + 102400L) {
                                prevBytesRead = totalBytes;
                                Log.d((String)FileTransfer.LOG_TAG, (String)("Uploaded " + totalBytes + " of " + fixedLength + " bytes"));
                            }
                            bytesAvailable = readResult.inputStream.available();
                            bufferSize = Math.min(bytesAvailable, 16384);
                            bytesRead = readResult.inputStream.read(buffer, 0, bufferSize);
                            progress.setLoaded(totalBytes);
                            PluginResult progressResult = new PluginResult(PluginResult.Status.OK, progress.toJSONObject());
                            progressResult.setKeepCallback(true);
                            context.sendPluginResult(progressResult);
                        }
                        if (multipartFormUpload) {
                            sendStream.write(tailParamsBytes);
                            totalBytes += tailParamsBytes.length;
                        }
                        sendStream.flush();
                    }
                    finally {
                        FileTransfer.safeClose(readResult.inputStream);
                        FileTransfer.safeClose(sendStream);
                    }
                    RequestContext bytesAvailable = context;
                    synchronized (bytesAvailable) {
                        context.connection = null;
                    }
                    Log.d((String)FileTransfer.LOG_TAG, (String)("Sent " + totalBytes + " of " + fixedLength));
                    int responseCode = conn.getResponseCode();
                    Log.d((String)FileTransfer.LOG_TAG, (String)("response code: " + responseCode));
                    Log.d((String)FileTransfer.LOG_TAG, (String)("response headers: " + conn.getHeaderFields()));
                    TrackingInputStream inStream = null;
                    try {
                        inStream = FileTransfer.getInputStream(conn);
                        RequestContext bytesRead = context;
                        synchronized (bytesRead) {
                            block85: {
                                if (!context.aborted) break block85;
                                return;
                            }
                            context.connection = conn;
                        }
                        ByteArrayOutputStream out = new ByteArrayOutputStream(Math.max(1024, conn.getContentLength()));
                        byte[] buffer = new byte[1024];
                        int bytesRead2 = 0;
                        while ((bytesRead2 = inStream.read(buffer)) > 0) {
                            out.write(buffer, 0, bytesRead2);
                        }
                        responseString = out.toString("UTF-8");
                    }
                    finally {
                        RequestContext prevBytesRead = context;
                        synchronized (prevBytesRead) {
                            context.connection = null;
                        }
                        FileTransfer.safeClose(inStream);
                    }
                    Log.d((String)FileTransfer.LOG_TAG, (String)"got response from server");
                    Log.d((String)FileTransfer.LOG_TAG, (String)responseString.substring(0, Math.min(256, responseString.length())));
                    result.setResponseCode(responseCode);
                    result.setResponse(responseString);
                    context.sendPluginResult(new PluginResult(PluginResult.Status.OK, result.toJSONObject()));
                }
                catch (FileNotFoundException e) {
                    error = FileTransfer.createFileTransferError(FILE_NOT_FOUND_ERR, source, target, conn, e);
                    Log.e((String)FileTransfer.LOG_TAG, (String)error.toString(), (Throwable)e);
                    context.sendPluginResult(new PluginResult(PluginResult.Status.IO_EXCEPTION, error));
                }
                catch (IOException e) {
                    error = FileTransfer.createFileTransferError(CONNECTION_ERR, source, target, conn, e);
                    Log.e((String)FileTransfer.LOG_TAG, (String)error.toString(), (Throwable)e);
                    Log.e((String)FileTransfer.LOG_TAG, (String)("Failed after uploading " + totalBytes + " of " + fixedLength + " bytes."));
                    context.sendPluginResult(new PluginResult(PluginResult.Status.IO_EXCEPTION, error));
                }
                catch (JSONException e) {
                    Log.e((String)FileTransfer.LOG_TAG, (String)e.getMessage(), (Throwable)e);
                    context.sendPluginResult(new PluginResult(PluginResult.Status.JSON_EXCEPTION));
                }
                catch (Throwable t) {
                    error = FileTransfer.createFileTransferError(CONNECTION_ERR, source, target, conn, t);
                    Log.e((String)FileTransfer.LOG_TAG, (String)error.toString(), (Throwable)t);
                    context.sendPluginResult(new PluginResult(PluginResult.Status.IO_EXCEPTION, error));
                }
                finally {
                    HashMap e = activeRequests;
                    synchronized (e) {
                        activeRequests.remove(objectId);
                    }
                    if (conn != null && trustEveryone && useHttps) {
                        HttpsURLConnection https = (HttpsURLConnection)conn;
                        https.setHostnameVerifier(oldHostnameVerifier);
                        https.setSSLSocketFactory(oldSocketFactory);
                    }
                }
            }
        });
    }

    private static void safeClose(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static TrackingInputStream getInputStream(URLConnection conn) throws IOException {
        String encoding = conn.getContentEncoding();
        if (encoding != null && encoding.equalsIgnoreCase("gzip")) {
            return new TrackingGZIPInputStream(new ExposedGZIPInputStream(conn.getInputStream()));
        }
        return new SimpleTrackingInputStream(conn.getInputStream());
    }

    private static SSLSocketFactory trustAllHosts(HttpsURLConnection connection) {
        SSLSocketFactory oldFactory = connection.getSSLSocketFactory();
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory newFactory = sc.getSocketFactory();
            connection.setSSLSocketFactory(newFactory);
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
        }
        return oldFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject createFileTransferError(int errorCode, String source, String target, URLConnection connection, Throwable throwable) {
        String body;
        int httpStatus;
        block7: {
            httpStatus = 0;
            StringBuilder bodyBuilder = new StringBuilder();
            body = null;
            if (connection != null) {
                try {
                    if (!(connection instanceof HttpURLConnection)) break block7;
                    httpStatus = ((HttpURLConnection)connection).getResponseCode();
                    InputStream err = ((HttpURLConnection)connection).getErrorStream();
                    if (err == null) break block7;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(err, "UTF-8"));){
                        String line = reader.readLine();
                        while (line != null) {
                            bodyBuilder.append(line);
                            line = reader.readLine();
                            if (line == null) continue;
                            bodyBuilder.append('\n');
                        }
                        body = bodyBuilder.toString();
                    }
                }
                catch (Throwable e) {
                    Log.w((String)LOG_TAG, (String)"Error getting HTTP status code from connection.", (Throwable)e);
                }
            }
        }
        return FileTransfer.createFileTransferError(errorCode, source, target, body, httpStatus, throwable);
    }

    private static JSONObject createFileTransferError(int errorCode, String source, String target, String body, Integer httpStatus, Throwable throwable) {
        JSONObject error = null;
        try {
            error = new JSONObject();
            error.put("code", errorCode);
            error.put("source", (Object)source);
            error.put("target", (Object)target);
            if (body != null) {
                error.put("body", (Object)body);
            }
            if (httpStatus != null) {
                error.put("http_status", (Object)httpStatus);
            }
            if (throwable != null) {
                String msg = throwable.getMessage();
                if (msg == null || "".equals(msg)) {
                    msg = throwable.toString();
                }
                error.put("exception", (Object)msg);
            }
        }
        catch (JSONException e) {
            Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
        }
        return error;
    }

    private static String getArgument(JSONArray args, int position, String defaultString) {
        String arg = defaultString;
        if (args.length() > position && ((arg = args.optString(position)) == null || "null".equals(arg))) {
            arg = defaultString;
        }
        return arg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(final String source, final String target, JSONArray args, CallbackContext callbackContext) throws JSONException {
        boolean isLocalTransfer;
        Log.d((String)LOG_TAG, (String)("download " + source + " to " + target));
        final CordovaResourceApi resourceApi = this.webView.getResourceApi();
        final boolean trustEveryone = args.optBoolean(2);
        final String objectId = args.getString(3);
        final JSONObject headers = args.optJSONObject(4);
        final Uri sourceUri = resourceApi.remapUri(Uri.parse((String)source));
        Uri tmpTarget = Uri.parse((String)target);
        final Uri targetUri = resourceApi.remapUri(tmpTarget.getScheme() != null ? tmpTarget : Uri.fromFile((File)new File(target)));
        int uriType = CordovaResourceApi.getUriType((Uri)sourceUri);
        final boolean useHttps = uriType == 6;
        boolean bl = isLocalTransfer = !useHttps && uriType != 5;
        if (uriType == -1) {
            JSONObject error = FileTransfer.createFileTransferError(INVALID_URL_ERR, source, target, null, 0, null);
            Log.e((String)LOG_TAG, (String)("Unsupported URI: " + sourceUri));
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.IO_EXCEPTION, error));
            return;
        }
        Boolean shouldAllowRequest = null;
        if (isLocalTransfer) {
            shouldAllowRequest = true;
        }
        if (shouldAllowRequest == null) {
            try {
                Method gwl = this.webView.getClass().getMethod("getWhitelist", new Class[0]);
                Whitelist whitelist = (Whitelist)gwl.invoke((Object)this.webView, new Object[0]);
                shouldAllowRequest = whitelist.isUrlWhiteListed(source);
            }
            catch (NoSuchMethodException gwl) {
            }
            catch (IllegalAccessException gwl) {
            }
            catch (InvocationTargetException gwl) {
                // empty catch block
            }
        }
        if (shouldAllowRequest == null) {
            try {
                Method gpm = this.webView.getClass().getMethod("getPluginManager", new Class[0]);
                PluginManager pm = (PluginManager)gpm.invoke((Object)this.webView, new Object[0]);
                Method san = pm.getClass().getMethod("shouldAllowRequest", String.class);
                shouldAllowRequest = (Boolean)san.invoke((Object)pm, source);
            }
            catch (NoSuchMethodException gpm) {
            }
            catch (IllegalAccessException gpm) {
            }
            catch (InvocationTargetException gpm) {
                // empty catch block
            }
        }
        if (!Boolean.TRUE.equals(shouldAllowRequest)) {
            Log.w((String)LOG_TAG, (String)("Source URL is not in white list: '" + source + "'"));
            JSONObject error = FileTransfer.createFileTransferError(CONNECTION_ERR, source, target, null, 401, null);
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.IO_EXCEPTION, error));
            return;
        }
        final RequestContext context = new RequestContext(source, target, callbackContext);
        HashMap<String, RequestContext> hashMap = activeRequests;
        synchronized (hashMap) {
            activeRequests.put(objectId, context);
        }
        this.cordova.getThreadPool().execute(new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abort(String objectId) {
        RequestContext context;
        HashMap<String, RequestContext> hashMap = activeRequests;
        synchronized (hashMap) {
            context = activeRequests.remove(objectId);
        }
        if (context != null) {
            this.cordova.getThreadPool().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    RequestContext requestContext = context;
                    synchronized (requestContext) {
                        File file = context.targetFile;
                        if (file != null) {
                            file.delete();
                        }
                        JSONObject error = FileTransfer.createFileTransferError(ABORTED_ERR, context.source, context.target, null, -1, null);
                        context.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, error));
                        context.aborted = true;
                        if (context.connection != null) {
                            try {
                                context.connection.disconnect();
                            }
                            catch (Exception e) {
                                Log.e((String)FileTransfer.LOG_TAG, (String)"CB-8431 Catch workaround for fatal exception", (Throwable)e);
                            }
                        }
                    }
                }
            });
        }
    }

    private static class SimpleTrackingInputStream
    extends TrackingInputStream {
        private long bytesRead = 0L;

        public SimpleTrackingInputStream(InputStream stream) {
            super(stream);
        }

        private int updateBytesRead(int newBytesRead) {
            if (newBytesRead != -1) {
                this.bytesRead += (long)newBytesRead;
            }
            return newBytesRead;
        }

        @Override
        public int read() throws IOException {
            return this.updateBytesRead(super.read());
        }

        @Override
        public int read(byte[] bytes, int offset, int count) throws IOException {
            return this.updateBytesRead(super.read(bytes, offset, count));
        }

        @Override
        public long getTotalRawBytesRead() {
            return this.bytesRead;
        }
    }

    private static class TrackingGZIPInputStream
    extends TrackingInputStream {
        private ExposedGZIPInputStream gzin;

        public TrackingGZIPInputStream(ExposedGZIPInputStream gzin) throws IOException {
            super(gzin);
            this.gzin = gzin;
        }

        @Override
        public long getTotalRawBytesRead() {
            return this.gzin.getInflater().getBytesRead();
        }
    }

    private static class ExposedGZIPInputStream
    extends GZIPInputStream {
        public ExposedGZIPInputStream(InputStream in) throws IOException {
            super(in);
        }

        public Inflater getInflater() {
            return this.inf;
        }
    }

    private static abstract class TrackingInputStream
    extends FilterInputStream {
        public TrackingInputStream(InputStream in) {
            super(in);
        }

        public abstract long getTotalRawBytesRead();
    }

    private static final class RequestContext {
        String source;
        String target;
        File targetFile;
        CallbackContext callbackContext;
        HttpURLConnection connection;
        boolean aborted;

        RequestContext(String source, String target, CallbackContext callbackContext) {
            this.source = source;
            this.target = target;
            this.callbackContext = callbackContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendPluginResult(PluginResult pluginResult) {
            RequestContext requestContext = this;
            synchronized (requestContext) {
                if (!this.aborted) {
                    this.callbackContext.sendPluginResult(pluginResult);
                }
            }
        }
    }
}

