/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.file;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Environment;
import android.util.Base64;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.PluginResult;
import org.apache.cordova.file.AssetFilesystem;
import org.apache.cordova.file.ContentFilesystem;
import org.apache.cordova.file.DirectoryManager;
import org.apache.cordova.file.EncodingException;
import org.apache.cordova.file.FileExistsException;
import org.apache.cordova.file.Filesystem;
import org.apache.cordova.file.InvalidModificationException;
import org.apache.cordova.file.LocalFilesystem;
import org.apache.cordova.file.LocalFilesystemURL;
import org.apache.cordova.file.NoModificationAllowedException;
import org.apache.cordova.file.PermissionHelper;
import org.apache.cordova.file.TypeMismatchException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FileUtils
extends CordovaPlugin {
    private static final String LOG_TAG = "FileUtils";
    public static int NOT_FOUND_ERR = 1;
    public static int SECURITY_ERR = 2;
    public static int ABORT_ERR = 3;
    public static int NOT_READABLE_ERR = 4;
    public static int ENCODING_ERR = 5;
    public static int NO_MODIFICATION_ALLOWED_ERR = 6;
    public static int INVALID_STATE_ERR = 7;
    public static int SYNTAX_ERR = 8;
    public static int INVALID_MODIFICATION_ERR = 9;
    public static int QUOTA_EXCEEDED_ERR = 10;
    public static int TYPE_MISMATCH_ERR = 11;
    public static int PATH_EXISTS_ERR = 12;
    public static final int READ_PERM = 0;
    public static final int WRITE_PERM = 1;
    public static int UNKNOWN_ERR = 1000;
    private boolean configured = false;
    private String lastRawArgs;
    private CallbackContext callback;
    private String[] permissions = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
    private static FileUtils filePlugin;
    private ArrayList<Filesystem> filesystems;

    public void registerFilesystem(Filesystem fs) {
        if (fs != null && this.filesystemForName(fs.name) == null) {
            this.filesystems.add(fs);
        }
    }

    private Filesystem filesystemForName(String name) {
        for (Filesystem fs : this.filesystems) {
            if (fs == null || fs.name == null || !fs.name.equals(name)) continue;
            return fs;
        }
        return null;
    }

    protected String[] getExtraFileSystemsPreference(Activity activity) {
        String fileSystemsStr = this.preferences.getString("androidextrafilesystems", "files,files-external,documents,sdcard,cache,cache-external,root");
        return fileSystemsStr.split(",");
    }

    protected void registerExtraFileSystems(String[] filesystems, HashMap<String, String> availableFileSystems) {
        HashSet<String> installedFileSystems = new HashSet<String>();
        for (String fsName : filesystems) {
            if (installedFileSystems.contains(fsName)) continue;
            String fsRoot = availableFileSystems.get(fsName);
            if (fsRoot != null) {
                File newRoot = new File(fsRoot);
                if (newRoot.mkdirs() || newRoot.isDirectory()) {
                    this.registerFilesystem(new LocalFilesystem(fsName, this.webView.getContext(), this.webView.getResourceApi(), newRoot));
                    installedFileSystems.add(fsName);
                    continue;
                }
                Log.d((String)LOG_TAG, (String)("Unable to create root dir for filesystem \"" + fsName + "\", skipping"));
                continue;
            }
            Log.d((String)LOG_TAG, (String)("Unrecognized extra filesystem identifier: " + fsName));
        }
    }

    protected HashMap<String, String> getAvailableFileSystems(Activity activity) {
        Context context = activity.getApplicationContext();
        HashMap<String, String> availableFileSystems = new HashMap<String, String>();
        availableFileSystems.put("files", context.getFilesDir().getAbsolutePath());
        availableFileSystems.put("documents", new File(context.getFilesDir(), "Documents").getAbsolutePath());
        availableFileSystems.put("cache", context.getCacheDir().getAbsolutePath());
        availableFileSystems.put("root", "/");
        if (Environment.getExternalStorageState().equals("mounted")) {
            try {
                availableFileSystems.put("files-external", context.getExternalFilesDir(null).getAbsolutePath());
                availableFileSystems.put("sdcard", Environment.getExternalStorageDirectory().getAbsolutePath());
                availableFileSystems.put("cache-external", context.getExternalCacheDir().getAbsolutePath());
            }
            catch (NullPointerException e) {
                Log.d((String)LOG_TAG, (String)"External storage unavailable, check to see if USB Mass Storage Mode is on");
            }
        }
        return availableFileSystems;
    }

    public void initialize(CordovaInterface cordova, CordovaWebView webView) {
        super.initialize(cordova, webView);
        this.filesystems = new ArrayList();
        String tempRoot = null;
        String persistentRoot = null;
        Activity activity = cordova.getActivity();
        String packageName = activity.getPackageName();
        String location = this.preferences.getString("androidpersistentfilelocation", "internal");
        tempRoot = activity.getCacheDir().getAbsolutePath();
        if ("internal".equalsIgnoreCase(location)) {
            persistentRoot = activity.getFilesDir().getAbsolutePath() + "/files/";
            this.configured = true;
        } else if ("compatibility".equalsIgnoreCase(location)) {
            if (Environment.getExternalStorageState().equals("mounted")) {
                persistentRoot = Environment.getExternalStorageDirectory().getAbsolutePath();
                tempRoot = Environment.getExternalStorageDirectory().getAbsolutePath() + "/Android/data/" + packageName + "/cache/";
            } else {
                persistentRoot = "/data/data/" + packageName;
            }
            this.configured = true;
        }
        if (this.configured) {
            File tmpRootFile = new File(tempRoot);
            File persistentRootFile = new File(persistentRoot);
            tmpRootFile.mkdirs();
            persistentRootFile.mkdirs();
            this.registerFilesystem(new LocalFilesystem("temporary", webView.getContext(), webView.getResourceApi(), tmpRootFile));
            this.registerFilesystem(new LocalFilesystem("persistent", webView.getContext(), webView.getResourceApi(), persistentRootFile));
            this.registerFilesystem(new ContentFilesystem(webView.getContext(), webView.getResourceApi()));
            this.registerFilesystem(new AssetFilesystem(webView.getContext().getAssets(), webView.getResourceApi()));
            this.registerExtraFileSystems(this.getExtraFileSystemsPreference(activity), this.getAvailableFileSystems(activity));
            if (filePlugin == null) {
                filePlugin = this;
            }
        } else {
            Log.e((String)LOG_TAG, (String)"File plugin configuration error: Please set AndroidPersistentFileLocation in config.xml to one of \"internal\" (for new applications) or \"compatibility\" (for compatibility with previous versions)");
            activity.finish();
        }
    }

    public static FileUtils getFilePlugin() {
        return filePlugin;
    }

    private Filesystem filesystemForURL(LocalFilesystemURL localURL) {
        if (localURL == null) {
            return null;
        }
        return this.filesystemForName(localURL.fsName);
    }

    public Uri remapUri(Uri uri) {
        if (!"cdvfile".equals(uri.getScheme())) {
            return null;
        }
        try {
            LocalFilesystemURL inputURL = LocalFilesystemURL.parse(uri);
            Filesystem fs = this.filesystemForURL(inputURL);
            if (fs == null) {
                return null;
            }
            String path = fs.filesystemPathForURL(inputURL);
            if (path != null) {
                return Uri.parse((String)("file://" + fs.filesystemPathForURL(inputURL)));
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean execute(String action, String rawArgs, final CallbackContext callbackContext) {
        this.callback = callbackContext;
        this.lastRawArgs = rawArgs;
        if (!this.configured) {
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, "File plugin is not configured. Please see the README.md file for details on how to update config.xml"));
            return true;
        }
        if (action.equals("testSaveLocationExists")) {
            this.threadhelper(new FileOp(){

                @Override
                public void run(JSONArray args) {
                    boolean b = DirectoryManager.testSaveLocationExists();
                    callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, b));
                }
            }, rawArgs, callbackContext);
        } else if (action.equals("getFreeDiskSpace")) {
            this.threadhelper(new FileOp(){

                @Override
                public void run(JSONArray args) {
                    long l = DirectoryManager.getFreeExternalStorageSpace();
                    callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, (float)l));
                }
            }, rawArgs, callbackContext);
        } else if (action.equals("testFileExists")) {
            this.threadhelper(new FileOp(){

                @Override
                public void run(JSONArray args) throws JSONException {
                    String fname = args.getString(0);
                    boolean b = DirectoryManager.testFileExists(fname);
                    callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, b));
                }
            }, rawArgs, callbackContext);
        } else if (action.equals("testDirectoryExists")) {
            this.threadhelper(new FileOp(){

                @Override
                public void run(JSONArray args) throws JSONException {
                    String fname = args.getString(0);
                    boolean b = DirectoryManager.testFileExists(fname);
                    callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, b));
                }
            }, rawArgs, callbackContext);
        } else if (action.equals("readAsText")) {
            this.threadhelper(new FileOp(){

                @Override
                public void run(JSONArray args) throws JSONException, MalformedURLException {
                    String encoding = args.getString(1);
                    int start = args.getInt(2);
                    int end = args.getInt(3);
                    String fname = args.getString(0);
                    FileUtils.this.readFileAs(fname, start, end, callbackContext, encoding, 1);
                }
            }, rawArgs, callbackContext);
        } else if (action.equals("readAsDataURL")) {
            this.threadhelper(new FileOp(){

                @Override
                public void run(JSONArray args) throws JSONException, MalformedURLException {
                    int start = args.getInt(1);
                    int end = args.getInt(2);
                    String fname = args.getString(0);
                    FileUtils.this.readFileAs(fname, start, end, callbackContext, null, -1);
                }
            }, rawArgs, callbackContext);
        } else if (action.equals("readAsArrayBuffer")) {
            this.threadhelper(new FileOp(){

                @Override
                public void run(JSONArray args) throws JSONException, MalformedURLException {
                    int start = args.getInt(1);
                    int end = args.getInt(2);
                    String fname = args.getString(0);
                    FileUtils.this.readFileAs(fname, start, end, callbackContext, null, 6);
                }
            }, rawArgs, callbackContext);
        } else if (action.equals("readAsBinaryString")) {
            this.threadhelper(new FileOp(){

                @Override
                public void run(JSONArray args) throws JSONException, MalformedURLException {
                    int start = args.getInt(1);
                    int end = args.getInt(2);
                    String fname = args.getString(0);
                    FileUtils.this.readFileAs(fname, start, end, callbackContext, null, 7);
                }
            }, rawArgs, callbackContext);
        } else if (action.equals("write")) {
            this.threadhelper(new FileOp(){

                @Override
                public void run(JSONArray args) throws JSONException, FileNotFoundException, IOException, NoModificationAllowedException {
                    String fname = args.getString(0);
                    String data = args.getString(1);
                    int offset = args.getInt(2);
                    Boolean isBinary = args.getBoolean(3);
                    if (fname.contains(FileUtils.this.cordova.getActivity().getPackageName()) || FileUtils.this.hasReadPermission()) {
                        long fileSize = FileUtils.this.write(fname, data, offset, isBinary);
                        callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, (float)fileSize));
                    } else {
                        FileUtils.this.getWritePermission();
                    }
                }
            }, rawArgs, callbackContext);
        } else if (action.equals("truncate")) {
            this.threadhelper(new FileOp(){

                @Override
                public void run(JSONArray args) throws JSONException, FileNotFoundException, IOException, NoModificationAllowedException {
                    String fname = args.getString(0);
                    int offset = args.getInt(1);
                    long fileSize = FileUtils.this.truncateFile(fname, offset);
                    callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.OK, (float)fileSize));
                }
            }, rawArgs, callbackContext);
        } else if (action.equals("requestAllFileSystems")) {
            this.threadhelper(new FileOp(){

                @Override
                public void run(JSONArray args) throws IOException, JSONException {
                    callbackContext.success(FileUtils.this.requestAllFileSystems());
                }
            }, rawArgs, callbackContext);
        } else if (action.equals("requestAllPaths")) {
            this.cordova.getThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        callbackContext.success(FileUtils.this.requestAllPaths());
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            });
        } else if (action.equals("requestFileSystem")) {
            this.threadhelper(new FileOp(){

                @Override
                public void run(JSONArray args) throws JSONException {
                    int fstype = args.getInt(0);
                    long requiredSize = args.optLong(1);
                    FileUtils.this.requestFileSystem(fstype, requiredSize, callbackContext);
                }
            }, rawArgs, callbackContext);
        } else if (action.equals("resolveLocalFileSystemURI")) {
            this.threadhelper(new FileOp(){

                @Override
                public void run(JSONArray args) throws IOException, JSONException {
                    String fname = args.getString(0);
                    JSONObject obj = FileUtils.this.resolveLocalFileSystemURI(fname);
                    callbackContext.success(obj);
                }
            }, rawArgs, callbackContext);
        } else if (action.equals("getFileMetadata")) {
            this.threadhelper(new FileOp(){

                @Override
                public void run(JSONArray args) throws FileNotFoundException, JSONException, MalformedURLException {
                    String fname = args.getString(0);
                    JSONObject obj = FileUtils.this.getFileMetadata(fname);
                    callbackContext.success(obj);
                }
            }, rawArgs, callbackContext);
        } else if (action.equals("getParent")) {
            this.threadhelper(new FileOp(){

                @Override
                public void run(JSONArray args) throws JSONException, IOException {
                    String fname = args.getString(0);
                    JSONObject obj = FileUtils.this.getParent(fname);
                    callbackContext.success(obj);
                }
            }, rawArgs, callbackContext);
        } else if (action.equals("getDirectory")) {
            this.threadhelper(new FileOp(){

                @Override
                public void run(JSONArray args) throws FileExistsException, IOException, TypeMismatchException, EncodingException, JSONException {
                    String dirname = args.getString(0);
                    String path = args.getString(1);
                    JSONObject obj = FileUtils.this.getFile(dirname, path, args.optJSONObject(2), true);
                    callbackContext.success(obj);
                }
            }, rawArgs, callbackContext);
        } else if (action.equals("getFile")) {
            this.threadhelper(new FileOp(){

                @Override
                public void run(JSONArray args) throws FileExistsException, IOException, TypeMismatchException, EncodingException, JSONException {
                    String dirname = args.getString(0);
                    if (dirname.contains(FileUtils.this.cordova.getActivity().getPackageName()) || FileUtils.this.hasReadPermission()) {
                        String path = args.getString(1);
                        JSONObject obj = FileUtils.this.getFile(dirname, path, args.optJSONObject(2), false);
                        callbackContext.success(obj);
                    } else {
                        FileUtils.this.getReadPermission();
                    }
                }
            }, rawArgs, callbackContext);
        } else if (action.equals("remove")) {
            this.threadhelper(new FileOp(){

                @Override
                public void run(JSONArray args) throws JSONException, NoModificationAllowedException, InvalidModificationException, MalformedURLException {
                    String fname = args.getString(0);
                    boolean success = FileUtils.this.remove(fname);
                    if (success) {
                        callbackContext.success();
                    } else {
                        callbackContext.error(NO_MODIFICATION_ALLOWED_ERR);
                    }
                }
            }, rawArgs, callbackContext);
        } else if (action.equals("removeRecursively")) {
            this.threadhelper(new FileOp(){

                @Override
                public void run(JSONArray args) throws JSONException, FileExistsException, MalformedURLException, NoModificationAllowedException {
                    String fname = args.getString(0);
                    boolean success = FileUtils.this.removeRecursively(fname);
                    if (success) {
                        callbackContext.success();
                    } else {
                        callbackContext.error(NO_MODIFICATION_ALLOWED_ERR);
                    }
                }
            }, rawArgs, callbackContext);
        } else if (action.equals("moveTo")) {
            this.threadhelper(new FileOp(){

                @Override
                public void run(JSONArray args) throws JSONException, NoModificationAllowedException, IOException, InvalidModificationException, EncodingException, FileExistsException {
                    String fname = args.getString(0);
                    String newParent = args.getString(1);
                    String newName = args.getString(2);
                    JSONObject entry = FileUtils.this.transferTo(fname, newParent, newName, true);
                    callbackContext.success(entry);
                }
            }, rawArgs, callbackContext);
        } else if (action.equals("copyTo")) {
            this.threadhelper(new FileOp(){

                @Override
                public void run(JSONArray args) throws JSONException, NoModificationAllowedException, IOException, InvalidModificationException, EncodingException, FileExistsException {
                    String fname = args.getString(0);
                    String newParent = args.getString(1);
                    String newName = args.getString(2);
                    JSONObject entry = FileUtils.this.transferTo(fname, newParent, newName, false);
                    callbackContext.success(entry);
                }
            }, rawArgs, callbackContext);
        } else if (action.equals("readEntries")) {
            this.threadhelper(new FileOp(){

                @Override
                public void run(JSONArray args) throws FileNotFoundException, JSONException, MalformedURLException {
                    String fname = args.getString(0);
                    JSONArray entries = FileUtils.this.readEntries(fname);
                    callbackContext.success(entries);
                }
            }, rawArgs, callbackContext);
        } else if (action.equals("_getLocalFilesystemPath")) {
            this.threadhelper(new FileOp(){

                @Override
                public void run(JSONArray args) throws FileNotFoundException, JSONException, MalformedURLException {
                    String localURLstr = args.getString(0);
                    String fname = FileUtils.this.filesystemPathForURL(localURLstr);
                    callbackContext.success(fname);
                }
            }, rawArgs, callbackContext);
        } else {
            return false;
        }
        return true;
    }

    private void getReadPermission() {
        PermissionHelper.requestPermission(this, 0, "android.permission.READ_EXTERNAL_STORAGE");
    }

    private void getWritePermission() {
        PermissionHelper.requestPermission(this, 1, "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    private boolean hasReadPermission() {
        return PermissionHelper.hasPermission(this, "android.permission.READ_EXTERNAL_STORAGE");
    }

    private boolean hasWritePermission() {
        return PermissionHelper.hasPermission(this, "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    public LocalFilesystemURL resolveNativeUri(Uri nativeUri) {
        LocalFilesystemURL localURL = null;
        for (Filesystem fs : this.filesystems) {
            LocalFilesystemURL url = fs.toLocalUri(nativeUri);
            if (url == null || localURL != null && url.uri.toString().length() >= localURL.toString().length()) continue;
            localURL = url;
        }
        return localURL;
    }

    public String filesystemPathForURL(String localURLstr) throws MalformedURLException {
        try {
            LocalFilesystemURL inputURL = LocalFilesystemURL.parse(localURLstr);
            Filesystem fs = this.filesystemForURL(inputURL);
            if (fs == null) {
                throw new MalformedURLException("No installed handlers for this URL");
            }
            return fs.filesystemPathForURL(inputURL);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException("Unrecognized filesystem URL");
        }
    }

    public LocalFilesystemURL filesystemURLforLocalPath(String localPath) {
        LocalFilesystemURL localURL = null;
        int shortestFullPath = 0;
        for (Filesystem fs : this.filesystems) {
            LocalFilesystemURL url = fs.URLforFilesystemPath(localPath);
            if (url == null || localURL != null && url.path.length() >= shortestFullPath) continue;
            localURL = url;
            shortestFullPath = url.path.length();
        }
        return localURL;
    }

    private void threadhelper(final FileOp f, final String rawArgs, final CallbackContext callbackContext) {
        this.cordova.getThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONArray args = new JSONArray(rawArgs);
                    f.run(args);
                }
                catch (Exception e) {
                    if (e instanceof EncodingException) {
                        callbackContext.error(ENCODING_ERR);
                    }
                    if (e instanceof FileNotFoundException) {
                        callbackContext.error(NOT_FOUND_ERR);
                    }
                    if (e instanceof FileExistsException) {
                        callbackContext.error(PATH_EXISTS_ERR);
                    }
                    if (e instanceof NoModificationAllowedException) {
                        callbackContext.error(NO_MODIFICATION_ALLOWED_ERR);
                    }
                    if (e instanceof InvalidModificationException) {
                        callbackContext.error(INVALID_MODIFICATION_ERR);
                    }
                    if (e instanceof MalformedURLException) {
                        callbackContext.error(ENCODING_ERR);
                    }
                    if (e instanceof IOException) {
                        callbackContext.error(INVALID_MODIFICATION_ERR);
                    }
                    if (e instanceof EncodingException) {
                        callbackContext.error(ENCODING_ERR);
                    }
                    if (e instanceof TypeMismatchException) {
                        callbackContext.error(TYPE_MISMATCH_ERR);
                    }
                    if (e instanceof JSONException) {
                        callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.JSON_EXCEPTION));
                    }
                    e.printStackTrace();
                    callbackContext.error(UNKNOWN_ERR);
                }
            }
        });
    }

    private JSONObject resolveLocalFileSystemURI(String uriString) throws IOException, JSONException {
        if (uriString == null) {
            throw new MalformedURLException("Unrecognized filesystem URL");
        }
        Uri uri = Uri.parse((String)uriString);
        LocalFilesystemURL inputURL = LocalFilesystemURL.parse(uri);
        if (inputURL == null) {
            inputURL = this.resolveNativeUri(uri);
        }
        try {
            Filesystem fs = this.filesystemForURL(inputURL);
            if (fs == null) {
                throw new MalformedURLException("No installed handlers for this URL");
            }
            if (fs.exists(inputURL)) {
                return fs.getEntryForLocalURL(inputURL);
            }
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException("Unrecognized filesystem URL");
        }
        throw new FileNotFoundException();
    }

    private JSONArray readEntries(String baseURLstr) throws FileNotFoundException, JSONException, MalformedURLException {
        try {
            LocalFilesystemURL inputURL = LocalFilesystemURL.parse(baseURLstr);
            Filesystem fs = this.filesystemForURL(inputURL);
            if (fs == null) {
                throw new MalformedURLException("No installed handlers for this URL");
            }
            return fs.readEntriesAtLocalURL(inputURL);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException("Unrecognized filesystem URL");
        }
    }

    private JSONObject transferTo(String srcURLstr, String destURLstr, String newName, boolean move) throws JSONException, NoModificationAllowedException, IOException, InvalidModificationException, EncodingException, FileExistsException {
        if (srcURLstr == null || destURLstr == null) {
            throw new FileNotFoundException();
        }
        LocalFilesystemURL srcURL = LocalFilesystemURL.parse(srcURLstr);
        LocalFilesystemURL destURL = LocalFilesystemURL.parse(destURLstr);
        Filesystem srcFs = this.filesystemForURL(srcURL);
        Filesystem destFs = this.filesystemForURL(destURL);
        if (newName != null && newName.contains(":")) {
            throw new EncodingException("Bad file name");
        }
        return destFs.copyFileToURL(destURL, newName, srcFs, srcURL, move);
    }

    private boolean removeRecursively(String baseURLstr) throws FileExistsException, NoModificationAllowedException, MalformedURLException {
        try {
            LocalFilesystemURL inputURL = LocalFilesystemURL.parse(baseURLstr);
            if ("".equals(inputURL.path) || "/".equals(inputURL.path)) {
                throw new NoModificationAllowedException("You can't delete the root directory");
            }
            Filesystem fs = this.filesystemForURL(inputURL);
            if (fs == null) {
                throw new MalformedURLException("No installed handlers for this URL");
            }
            return fs.recursiveRemoveFileAtLocalURL(inputURL);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException("Unrecognized filesystem URL");
        }
    }

    private boolean remove(String baseURLstr) throws NoModificationAllowedException, InvalidModificationException, MalformedURLException {
        try {
            LocalFilesystemURL inputURL = LocalFilesystemURL.parse(baseURLstr);
            if ("".equals(inputURL.path) || "/".equals(inputURL.path)) {
                throw new NoModificationAllowedException("You can't delete the root directory");
            }
            Filesystem fs = this.filesystemForURL(inputURL);
            if (fs == null) {
                throw new MalformedURLException("No installed handlers for this URL");
            }
            return fs.removeFileAtLocalURL(inputURL);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException("Unrecognized filesystem URL");
        }
    }

    private JSONObject getFile(String baseURLstr, String path, JSONObject options, boolean directory) throws FileExistsException, IOException, TypeMismatchException, EncodingException, JSONException {
        try {
            LocalFilesystemURL inputURL = LocalFilesystemURL.parse(baseURLstr);
            Filesystem fs = this.filesystemForURL(inputURL);
            if (fs == null) {
                throw new MalformedURLException("No installed handlers for this URL");
            }
            return fs.getFileForLocalURL(inputURL, path, options, directory);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException("Unrecognized filesystem URL");
        }
    }

    private JSONObject getParent(String baseURLstr) throws JSONException, IOException {
        try {
            LocalFilesystemURL inputURL = LocalFilesystemURL.parse(baseURLstr);
            Filesystem fs = this.filesystemForURL(inputURL);
            if (fs == null) {
                throw new MalformedURLException("No installed handlers for this URL");
            }
            return fs.getParentForLocalURL(inputURL);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException("Unrecognized filesystem URL");
        }
    }

    private JSONObject getFileMetadata(String baseURLstr) throws FileNotFoundException, JSONException, MalformedURLException {
        try {
            LocalFilesystemURL inputURL = LocalFilesystemURL.parse(baseURLstr);
            Filesystem fs = this.filesystemForURL(inputURL);
            if (fs == null) {
                throw new MalformedURLException("No installed handlers for this URL");
            }
            return fs.getFileMetadataForLocalURL(inputURL);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException("Unrecognized filesystem URL");
        }
    }

    private void requestFileSystem(int type, long requiredSize, CallbackContext callbackContext) throws JSONException {
        Filesystem rootFs = null;
        try {
            rootFs = this.filesystems.get(type);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (rootFs == null) {
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, NOT_FOUND_ERR));
        } else {
            long availableSize = 0L;
            if (requiredSize > 0L) {
                availableSize = rootFs.getFreeSpaceInBytes();
            }
            if (availableSize < requiredSize) {
                callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, QUOTA_EXCEEDED_ERR));
            } else {
                JSONObject fs = new JSONObject();
                fs.put("name", (Object)rootFs.name);
                fs.put("root", (Object)rootFs.getRootEntry());
                callbackContext.success(fs);
            }
        }
    }

    private JSONArray requestAllFileSystems() throws IOException, JSONException {
        JSONArray ret = new JSONArray();
        for (Filesystem fs : this.filesystems) {
            ret.put((Object)fs.getRootEntry());
        }
        return ret;
    }

    private static String toDirUrl(File f) {
        return Uri.fromFile((File)f).toString() + '/';
    }

    private JSONObject requestAllPaths() throws JSONException {
        Activity context = this.cordova.getActivity();
        JSONObject ret = new JSONObject();
        ret.put("applicationDirectory", (Object)"file:///android_asset/");
        ret.put("applicationStorageDirectory", (Object)FileUtils.toDirUrl(context.getFilesDir().getParentFile()));
        ret.put("dataDirectory", (Object)FileUtils.toDirUrl(context.getFilesDir()));
        ret.put("cacheDirectory", (Object)FileUtils.toDirUrl(context.getCacheDir()));
        if (Environment.getExternalStorageState().equals("mounted")) {
            try {
                ret.put("externalApplicationStorageDirectory", (Object)FileUtils.toDirUrl(context.getExternalFilesDir(null).getParentFile()));
                ret.put("externalDataDirectory", (Object)FileUtils.toDirUrl(context.getExternalFilesDir(null)));
                ret.put("externalCacheDirectory", (Object)FileUtils.toDirUrl(context.getExternalCacheDir()));
                ret.put("externalRootDirectory", (Object)FileUtils.toDirUrl(Environment.getExternalStorageDirectory()));
            }
            catch (NullPointerException e) {
                Log.d((String)LOG_TAG, (String)"Unable to access these paths, most liklely due to USB storage");
            }
        }
        return ret;
    }

    public JSONObject getEntryForFile(File file) throws JSONException {
        for (Filesystem fs : this.filesystems) {
            JSONObject entry = fs.makeEntryForFile(file);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    @Deprecated
    public static JSONObject getEntry(File file) throws JSONException {
        if (FileUtils.getFilePlugin() != null) {
            return FileUtils.getFilePlugin().getEntryForFile(file);
        }
        return null;
    }

    public void readFileAs(String srcURLstr, int start, int end, final CallbackContext callbackContext, final String encoding, final int resultType) throws MalformedURLException {
        try {
            LocalFilesystemURL inputURL = LocalFilesystemURL.parse(srcURLstr);
            Filesystem fs = this.filesystemForURL(inputURL);
            if (fs == null) {
                throw new MalformedURLException("No installed handlers for this URL");
            }
            fs.readFileAtURL(inputURL, start, end, new Filesystem.ReadFileCallback(){

                @Override
                public void handleData(InputStream inputStream, String contentType) {
                    try {
                        PluginResult result;
                        int bytesRead;
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        int BUFFER_SIZE = 8192;
                        byte[] buffer = new byte[8192];
                        while ((bytesRead = inputStream.read(buffer, 0, 8192)) > 0) {
                            os.write(buffer, 0, bytesRead);
                        }
                        switch (resultType) {
                            case 1: {
                                result = new PluginResult(PluginResult.Status.OK, os.toString(encoding));
                                break;
                            }
                            case 6: {
                                result = new PluginResult(PluginResult.Status.OK, os.toByteArray());
                                break;
                            }
                            case 7: {
                                result = new PluginResult(PluginResult.Status.OK, os.toByteArray(), true);
                                break;
                            }
                            default: {
                                byte[] base64 = Base64.encode((byte[])os.toByteArray(), (int)2);
                                String s = "data:" + contentType + ";base64," + new String(base64, "US-ASCII");
                                result = new PluginResult(PluginResult.Status.OK, s);
                            }
                        }
                        callbackContext.sendPluginResult(result);
                    }
                    catch (IOException e) {
                        Log.d((String)FileUtils.LOG_TAG, (String)e.getLocalizedMessage());
                        callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.IO_EXCEPTION, NOT_READABLE_ERR));
                    }
                }
            });
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException("Unrecognized filesystem URL");
        }
        catch (FileNotFoundException e) {
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.IO_EXCEPTION, NOT_FOUND_ERR));
        }
        catch (IOException e) {
            Log.d((String)LOG_TAG, (String)e.getLocalizedMessage());
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.IO_EXCEPTION, NOT_READABLE_ERR));
        }
    }

    public long write(String srcURLstr, String data, int offset, boolean isBinary) throws FileNotFoundException, IOException, NoModificationAllowedException {
        try {
            LocalFilesystemURL inputURL = LocalFilesystemURL.parse(srcURLstr);
            Filesystem fs = this.filesystemForURL(inputURL);
            if (fs == null) {
                throw new MalformedURLException("No installed handlers for this URL");
            }
            long x = fs.writeToFileAtURL(inputURL, data, offset, isBinary);
            Log.d((String)"TEST", (String)(srcURLstr + ": " + x));
            return x;
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException("Unrecognized filesystem URL");
        }
    }

    private long truncateFile(String srcURLstr, long size) throws FileNotFoundException, IOException, NoModificationAllowedException {
        try {
            LocalFilesystemURL inputURL = LocalFilesystemURL.parse(srcURLstr);
            Filesystem fs = this.filesystemForURL(inputURL);
            if (fs == null) {
                throw new MalformedURLException("No installed handlers for this URL");
            }
            return fs.truncateFileAtURL(inputURL, size);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException("Unrecognized filesystem URL");
        }
    }

    public void onRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) throws JSONException {
        for (int r : grantResults) {
            if (r != -1) continue;
            this.callback.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, SECURITY_ERR));
        }
        switch (requestCode) {
            case 0: {
                this.threadhelper(new FileOp(){

                    @Override
                    public void run(JSONArray args) throws FileExistsException, IOException, TypeMismatchException, EncodingException, JSONException {
                        String dirname = args.getString(0);
                        String path = args.getString(1);
                        JSONObject obj = FileUtils.this.getFile(dirname, path, args.optJSONObject(2), false);
                        FileUtils.this.callback.success(obj);
                    }
                }, this.lastRawArgs, this.callback);
                break;
            }
            case 1: {
                this.threadhelper(new FileOp(){

                    @Override
                    public void run(JSONArray args) throws JSONException, FileNotFoundException, IOException, NoModificationAllowedException {
                        String fname = args.getString(0);
                        String data = args.getString(1);
                        int offset = args.getInt(2);
                        Boolean isBinary = args.getBoolean(3);
                        long fileSize = FileUtils.this.write(fname, data, offset, isBinary);
                        FileUtils.this.callback.sendPluginResult(new PluginResult(PluginResult.Status.OK, (float)fileSize));
                    }
                }, this.lastRawArgs, this.callback);
            }
        }
    }

    private static interface FileOp {
        public void run(JSONArray var1) throws Exception;
    }
}

