/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btopbase;

import android.app.Activity;
import android.app.LocalActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopbase.BTWebActivity;
import com.beatop.btopbase.R;

public class BTTitleWebActivity
extends BTBaseActivity {
    private TextView title;
    private ImageView back;
    private FrameLayout webContent;
    private LocalActivityManager activityManager;
    private String url;
    private String initTitle;
    private View webPage;
    private Receiver receiver;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.btbase_activity_titleweb);
        this.activityManager = new LocalActivityManager((Activity)this, true);
        this.activityManager.dispatchCreate(savedInstanceState);
        Intent it = this.getIntent();
        this.url = it.getStringExtra("url");
        this.initTitle = it.getStringExtra("title");
        this.initView();
        this.receiver = new Receiver();
        IntentFilter filter = new IntentFilter("received_title_broadcast");
        this.registerReceiver(this.receiver, filter);
    }

    private void initView() {
        this.title = (TextView)this.findViewById(R.id.title);
        this.title.setText((CharSequence)this.initTitle);
        this.back = (ImageView)this.findViewById(R.id.back);
        this.webContent = (FrameLayout)this.findViewById(R.id.web_content);
        Intent it = new Intent((Context)this, BTWebActivity.class);
        it.putExtra("url", this.url);
        this.webPage = this.activityManager.startActivity("web", it).getDecorView();
        this.webContent.removeAllViews();
        this.webContent.addView(this.webPage);
        this.back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                BTTitleWebActivity.this.onBackPressed();
            }
        });
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.unregisterReceiver(this.receiver);
    }

    @Override
    protected void onLanguageChanged() {
    }

    public class Receiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("received_title_broadcast")) {
                String webTitle = intent.getStringExtra("title");
                Log.e((String)BTTitleWebActivity.this.TAG, (String)("onReceive: " + webTitle));
                BTTitleWebActivity.this.title.setText((CharSequence)webTitle.split("-")[0]);
            }
        }
    }
}

