/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btopbase;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.os.Bundle;
import android.widget.Toast;
import com.beatop.btopbase.module.CheckMobileResultEntity;
import com.beatop.btopbase.network.NetWorkServer;
import com.beatop.btopbase.network.NetWorkUtils;
import com.beatop.btopbase.utils.SPHelper;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class BTBaseActivity
extends Activity {
    protected final String TAG = "BTop::" + ((Object)((Object)this)).getClass().getSimpleName();
    protected final String LANGUAGE_CHANGE_BROADCAST = "change_language_broadcast";
    protected boolean isZh = true;
    protected Resources resources;
    protected LanguageChangeReceiver receiver;
    protected static NetWorkServer netWorkServer;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.resources = this.getResources();
        this.receiver = new LanguageChangeReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction("change_language_broadcast");
        this.registerReceiver(this.receiver, filter);
        this.isZh = SPHelper.getLanguageSetting().equals("zh");
        netWorkServer = NetWorkUtils.getInstance().getNetWorkServer();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.unregisterReceiver(this.receiver);
    }

    protected abstract void onLanguageChanged();

    protected void showMsg(String msg) {
        Toast toast = Toast.makeText((Context)this, (CharSequence)msg, (int)0);
        toast.setGravity(17, 0, 0);
        toast.show();
    }

    protected void checkMobileNumber(String area_code, String mobile, final OnCheckMobileReturn onCheckMobileReturn) {
        netWorkServer.checkMobile(area_code, mobile, null).enqueue((Callback)new Callback<CheckMobileResultEntity>(){

            public void onResponse(Call<CheckMobileResultEntity> call, Response<CheckMobileResultEntity> response) {
                onCheckMobileReturn.onResponse((CheckMobileResultEntity)response.body());
            }

            public void onFailure(Call<CheckMobileResultEntity> call, Throwable t) {
                onCheckMobileReturn.onFailure(t);
            }
        });
    }

    protected static interface OnCheckMobileReturn {
        public void onResponse(CheckMobileResultEntity var1);

        public void onFailure(Throwable var1);
    }

    protected class LanguageChangeReceiver
    extends BroadcastReceiver {
        protected LanguageChangeReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("change_language_broadcast")) {
                BTBaseActivity.this.isZh = SPHelper.getLanguageSetting().equals("zh");
                BTBaseActivity.this.onLanguageChanged();
            }
        }
    }
}

