/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.webcontain;

import android.app.Activity;
import android.app.Dialog;
import android.content.Intent;
import android.os.Bundle;
import android.util.Base64;
import android.webkit.WebSettings;
import android.webkit.WebView;
import java.io.IOException;
import java.io.InputStream;
import org.apache.cordova.CordovaActivity;
import org.apache.cordova.CordovaInterfaceImpl;

public class WebContainerActivity
extends CordovaActivity {
    private Dialog pd;
    private boolean showLoadingDialog = true;
    public static final String RECEIVED_TITLE_BROADCAST = "received_title_broadcast";

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.pd = this.setPd();
        this.showLoadingDialog = this.enableLoadingDialog();
    }

    protected CordovaInterfaceImpl makeCordovaInterface() {
        return new CordovaInterfaceImpl((Activity)this){

            public Object onMessage(String id, Object data) {
                return WebContainerActivity.this.onMessage(id, data);
            }

            public void onPageStarted(WebView view, String url) {
                if (WebContainerActivity.this.showLoadingDialog && WebContainerActivity.this.pd != null) {
                    WebContainerActivity.this.pd.show();
                }
            }

            public void onReceivedTitle(WebView view, String title) {
                super.onReceivedTitle(view, title);
                Intent it = new Intent();
                it.setAction(WebContainerActivity.RECEIVED_TITLE_BROADCAST);
                it.putExtra("title", title);
                WebContainerActivity.this.sendBroadcast(it);
            }

            public void onPageFinished(WebView view, String url) {
                if (WebContainerActivity.this.showLoadingDialog && WebContainerActivity.this.pd != null) {
                    WebContainerActivity.this.pd.dismiss();
                }
                WebContainerActivity.injectCordovaJS(view);
            }
        };
    }

    public Dialog setPd() {
        return null;
    }

    public boolean enableLoadingDialog() {
        return true;
    }

    public static void injectScriptFile(WebView view, String scriptFile) {
        try {
            InputStream input = view.getContext().getAssets().open(scriptFile);
            byte[] buffer = new byte[input.available()];
            input.read(buffer);
            input.close();
            String encoded = Base64.encodeToString((byte[])buffer, (int)2);
            view.loadUrl("javascript:(function() {if(window.cordova){return;};var parent = document.getElementsByTagName('head').item(0);var script = document.createElement('script');script.type = 'text/javascript';script.innerHTML = window.atob('" + encoded + "');" + "parent.appendChild(script)" + "})()");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void injectCordovaJS(WebView view) {
        WebSettings webSettings = view.getSettings();
        webSettings.setJavaScriptEnabled(true);
        WebContainerActivity.injectScriptFile(view, "www/cordova.js");
    }
}

