/*
 * Decompiled with CFR 0.152.
 */
package com.beardedhen.androidbootstrap.api.defaults;

import android.content.Context;
import android.support.annotation.ColorInt;
import com.beardedhen.androidbootstrap.R;
import com.beardedhen.androidbootstrap.api.attributes.BootstrapBrand;
import com.beardedhen.androidbootstrap.utils.ColorUtils;

public enum DefaultBootstrapBrand implements BootstrapBrand
{
    PRIMARY(R.color.bootstrap_brand_primary),
    SUCCESS(R.color.bootstrap_brand_success),
    INFO(R.color.bootstrap_brand_info),
    WARNING(R.color.bootstrap_brand_warning),
    DANGER(R.color.bootstrap_brand_danger),
    SECONDARY(R.color.bootstrap_brand_secondary_fill, R.color.bootstrap_brand_secondary_text),
    REGULAR(R.color.bootstrap_gray_light);

    private final int textColor;
    private final int color;

    private DefaultBootstrapBrand(int color2) {
        this.color = color2;
        this.textColor = 17170443;
    }

    private DefaultBootstrapBrand(int color2, int textColor) {
        this.color = color2;
        this.textColor = textColor;
    }

    public static DefaultBootstrapBrand fromAttributeValue(int attrValue) {
        switch (attrValue) {
            case 0: {
                return PRIMARY;
            }
            case 1: {
                return SUCCESS;
            }
            case 2: {
                return INFO;
            }
            case 3: {
                return WARNING;
            }
            case 4: {
                return DANGER;
            }
            case 5: {
                return REGULAR;
            }
            case 6: {
                return SECONDARY;
            }
        }
        return REGULAR;
    }

    @Override
    @ColorInt
    public int defaultFill(Context context) {
        return ColorUtils.resolveColor(this.color, context);
    }

    @Override
    @ColorInt
    public int defaultEdge(Context context) {
        return ColorUtils.decreaseRgbChannels(context, this.color, 0.025f);
    }

    @Override
    @ColorInt
    public int activeFill(Context context) {
        return ColorUtils.decreaseRgbChannels(context, this.color, 0.125f);
    }

    @Override
    @ColorInt
    public int activeEdge(Context context) {
        return ColorUtils.decreaseRgbChannels(context, this.color, 0.15f);
    }

    @Override
    @ColorInt
    public int disabledFill(Context context) {
        return ColorUtils.increaseOpacity(context, this.color, 165);
    }

    @Override
    @ColorInt
    public int disabledEdge(Context context) {
        return ColorUtils.increaseOpacity(context, this.color, -25);
    }

    @Override
    @ColorInt
    public int defaultTextColor(Context context) {
        return ColorUtils.resolveColor(this.textColor, context);
    }

    @Override
    @ColorInt
    public int activeTextColor(Context context) {
        return ColorUtils.resolveColor(this.textColor, context);
    }

    @Override
    @ColorInt
    public int disabledTextColor(Context context) {
        return ColorUtils.resolveColor(this.textColor, context);
    }

    @Override
    @ColorInt
    public int getColor() {
        return this.color;
    }
}

