/*
 * Decompiled with CFR 0.152.
 */
package com.beardedhen.androidbootstrap;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import com.beardedhen.androidbootstrap.AwesomeTextView;
import com.beardedhen.androidbootstrap.BootstrapDrawableFactory;
import com.beardedhen.androidbootstrap.R;
import com.beardedhen.androidbootstrap.api.attributes.BootstrapHeading;
import com.beardedhen.androidbootstrap.api.defaults.DefaultBootstrapHeading;
import com.beardedhen.androidbootstrap.api.view.BootstrapHeadingView;
import com.beardedhen.androidbootstrap.api.view.RoundableView;
import com.beardedhen.androidbootstrap.utils.ViewUtils;
import java.io.Serializable;

public class BootstrapLabel
extends AwesomeTextView
implements RoundableView,
BootstrapHeadingView {
    private static final String TAG = "com.beardedhen.androidbootstrap.BootstrapLabel";
    private BootstrapHeading bootstrapHeading;
    private boolean roundable;

    public BootstrapLabel(Context context) {
        super(context);
        this.initialise(null);
    }

    public BootstrapLabel(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialise(attrs);
    }

    public BootstrapLabel(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialise(attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialise(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.BootstrapLabel);
        try {
            int attrValue = a.getInt(R.styleable.BootstrapLabel_bootstrapHeading, 5);
            this.roundable = a.getBoolean(R.styleable.BootstrapLabel_roundedCorners, false);
            this.bootstrapHeading = DefaultBootstrapHeading.fromAttributeValue(attrValue);
        }
        finally {
            a.recycle();
        }
        this.updateBootstrapState();
    }

    @Override
    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(TAG, super.onSaveInstanceState());
        bundle.putBoolean("com.beardedhen.androidbootstrap.api.view.Roundable", this.roundable);
        bundle.putSerializable("com.beardedhen.androidbootstrap.api.attributes.BootstrapHeading", (Serializable)this.bootstrapHeading);
        return bundle;
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.roundable = bundle.getBoolean("com.beardedhen.androidbootstrap.api.view.Roundable");
            Serializable heading = bundle.getSerializable("com.beardedhen.androidbootstrap.api.attributes.BootstrapHeading");
            if (heading instanceof BootstrapHeading) {
                this.bootstrapHeading = (BootstrapHeading)heading;
            }
            state = bundle.getParcelable(TAG);
        }
        super.onRestoreInstanceState(state);
        this.updateBootstrapState();
    }

    @Override
    public void updateBootstrapState() {
        super.updateBootstrapState();
        if (this.bootstrapHeading != null) {
            int vert = (int)this.bootstrapHeading.verticalPadding(this.getContext());
            int hori = (int)this.bootstrapHeading.horizontalPadding(this.getContext());
            this.setPadding(hori, vert, hori, vert);
            this.setTextSize(this.bootstrapHeading.getTextSize(this.getContext()));
        }
        this.setTextColor(this.getBootstrapBrand().defaultTextColor(this.getContext()));
        this.setTypeface(Typeface.DEFAULT_BOLD);
        Drawable bg = BootstrapDrawableFactory.bootstrapLabel(this.getContext(), this.getBootstrapBrand(), this.roundable, this.getHeight());
        ViewUtils.setBackgroundDrawable((View)this, bg);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.roundable && h != oldh) {
            this.updateBootstrapState();
        }
    }

    @Override
    public void setRounded(boolean rounded) {
        this.roundable = rounded;
        this.updateBootstrapState();
    }

    @Override
    public boolean isRounded() {
        return this.roundable;
    }

    @Override
    public void setBootstrapHeading(@NonNull BootstrapHeading bootstrapHeading) {
        this.bootstrapHeading = bootstrapHeading;
        this.updateBootstrapState();
    }

    @Override
    @NonNull
    public BootstrapHeading getBootstrapHeading() {
        return this.bootstrapHeading;
    }
}

