/*
 * Decompiled with CFR 0.152.
 */
package com.beardedhen.androidbootstrap;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import com.beardedhen.androidbootstrap.BootstrapBaseThumbnail;
import com.beardedhen.androidbootstrap.BootstrapDrawableFactory;
import com.beardedhen.androidbootstrap.R;
import com.beardedhen.androidbootstrap.api.defaults.DefaultBootstrapBrand;
import com.beardedhen.androidbootstrap.api.defaults.DefaultBootstrapSize;
import com.beardedhen.androidbootstrap.utils.ColorUtils;
import com.beardedhen.androidbootstrap.utils.DimenUtils;
import com.beardedhen.androidbootstrap.utils.ViewUtils;

public class BootstrapCircleThumbnail
extends BootstrapBaseThumbnail {
    private static final String TAG = "com.beardedhen.androidbootstrap.BootstrapCircleThumbnail";
    private final RectF imageRectF = new RectF();
    private final Matrix matrix = new Matrix();

    public BootstrapCircleThumbnail(Context context) {
        super(context);
        this.initialise(null);
    }

    public BootstrapCircleThumbnail(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialise(attrs);
    }

    public BootstrapCircleThumbnail(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialise(attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialise(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.BootstrapCircleThumbnail);
        try {
            int typeOrdinal = a.getInt(R.styleable.BootstrapCircleThumbnail_bootstrapBrand, -1);
            int sizeOrdinal = a.getInt(R.styleable.BootstrapCircleThumbnail_bootstrapSize, -1);
            this.hasBorder = a.getBoolean(R.styleable.BootstrapCircleThumbnail_hasBorder, true);
            this.bootstrapSize = DefaultBootstrapSize.fromAttributeValue(sizeOrdinal).scaleFactor();
            this.bootstrapBrand = typeOrdinal == -1 ? DefaultBootstrapBrand.PRIMARY : DefaultBootstrapBrand.fromAttributeValue(typeOrdinal);
        }
        finally {
            a.recycle();
        }
        this.baselineOuterBorderWidth = DimenUtils.pixelsFromDpResource(this.getContext(), R.dimen.bthumbnail_outer_stroke);
        super.initialise(attrs);
    }

    @Override
    protected void updateImageState() {
        float viewWidth = this.getWidth();
        float viewHeight = this.getHeight();
        if ((int)viewWidth <= 0 || (int)viewHeight <= 0) {
            return;
        }
        if (this.sourceBitmap != null) {
            BitmapShader imageShader = new BitmapShader(this.sourceBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.imagePaint.setShader((Shader)imageShader);
            float bitmapWidth = this.sourceBitmap.getWidth();
            float bitmapHeight = this.sourceBitmap.getHeight();
            float scaleFactor = bitmapWidth < bitmapHeight ? bitmapWidth : bitmapHeight;
            float xScale = viewWidth / scaleFactor;
            float yScale = viewHeight / scaleFactor;
            float dx = 0.0f;
            float dy = 0.0f;
            if (bitmapWidth > bitmapHeight) {
                dx = (viewWidth - bitmapWidth * xScale) * 0.5f;
            } else if (bitmapHeight > bitmapWidth) {
                dy = (viewHeight - bitmapHeight * yScale) * 0.5f;
            }
            this.matrix.set(null);
            this.matrix.setScale(xScale, yScale);
            this.matrix.postTranslate(dx + 0.5f, dy + 0.5f);
            imageShader.setLocalMatrix(this.matrix);
            this.imageRectF.set(0.0f, 0.0f, viewWidth, viewHeight);
        }
        this.updateBackground();
        this.invalidate();
    }

    protected void onDraw(@NonNull Canvas canvas) {
        float center;
        float viewWidth = this.getWidth();
        float viewHeight = this.getHeight();
        if ((int)viewWidth <= 0 || (int)viewHeight <= 0) {
            return;
        }
        boolean isPlaceholder = this.sourceBitmap == null;
        float imageRadius = center = viewWidth / 2.0f;
        if (this.hasBorder) {
            imageRadius -= this.baselineBorderWidth * this.bootstrapSize;
        }
        Paint paint = isPlaceholder ? this.placeholderPaint : this.imagePaint;
        canvas.drawCircle(center, center, imageRadius, paint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int w = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int h = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.sourceBitmap != null) {
            if (View.MeasureSpec.getMode((int)widthMeasureSpec) == 0) {
                w = this.sourceBitmap.getWidth();
            }
            if (View.MeasureSpec.getMode((int)heightMeasureSpec) == 0) {
                h = this.sourceBitmap.getHeight();
            }
        }
        if (w > h) {
            w = h;
        }
        if (h > w) {
            h = w;
        }
        this.setMeasuredDimension(w, h);
    }

    private void updateBackground() {
        Drawable bg = null;
        if (this.hasBorder) {
            bg = BootstrapDrawableFactory.bootstrapCircleThumbnail(this.getContext(), this.bootstrapBrand, (int)(this.baselineOuterBorderWidth * this.bootstrapSize), ColorUtils.resolveColor(R.color.bootstrap_thumbnail_background, this.getContext()));
        }
        ViewUtils.setBackgroundDrawable((View)this, bg);
    }
}

