/*
 * Decompiled with CFR 0.152.
 */
package com.beardedhen.androidbootstrap;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import com.beardedhen.androidbootstrap.BootstrapButton;
import com.beardedhen.androidbootstrap.BootstrapGroup;
import com.beardedhen.androidbootstrap.R;
import com.beardedhen.androidbootstrap.api.attributes.BootstrapBrand;
import com.beardedhen.androidbootstrap.api.attributes.ViewGroupPosition;
import com.beardedhen.androidbootstrap.api.defaults.ButtonMode;
import com.beardedhen.androidbootstrap.api.defaults.DefaultBootstrapBrand;
import com.beardedhen.androidbootstrap.api.defaults.DefaultBootstrapSize;
import com.beardedhen.androidbootstrap.api.view.BootstrapBrandView;
import com.beardedhen.androidbootstrap.api.view.BootstrapSizeView;
import com.beardedhen.androidbootstrap.api.view.ButtonModeView;
import com.beardedhen.androidbootstrap.api.view.OutlineableView;
import com.beardedhen.androidbootstrap.api.view.RoundableView;
import java.io.Serializable;
import java.util.ArrayList;

public class BootstrapButtonGroup
extends BootstrapGroup
implements BootstrapSizeView,
OutlineableView,
RoundableView,
BootstrapBrandView,
ButtonModeView {
    private static final String TAG = "com.beardedhen.androidbootstrap.BootstrapButtonGroup";
    private static final String KEY_MODE = "com.beardedhen.androidbootstrap.BootstrapButtonGroup.MODE";
    private float bootstrapSize;
    private ButtonMode buttonMode;
    private BootstrapBrand bootstrapBrand;
    private boolean rounded;
    private boolean outline;
    private int checkedButtonId = 0;

    public BootstrapButtonGroup(Context context) {
        super(context);
        this.initialise(null);
    }

    public BootstrapButtonGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialise(attrs);
    }

    public BootstrapButtonGroup(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialise(attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialise(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.BootstrapButtonGroup);
        try {
            this.rounded = a.getBoolean(R.styleable.BootstrapButtonGroup_roundedCorners, false);
            this.outline = a.getBoolean(R.styleable.BootstrapButtonGroup_showOutline, false);
            int typeOrdinal = a.getInt(R.styleable.BootstrapButtonGroup_buttonMode, -1);
            int brandOrdinal = a.getInt(R.styleable.BootstrapButtonGroup_bootstrapBrand, -1);
            int sizeOrdinal = a.getInt(R.styleable.BootstrapButtonGroup_bootstrapSize, -1);
            this.checkedButtonId = a.getResourceId(R.styleable.BootstrapButtonGroup_checkedButton, 0);
            this.buttonMode = ButtonMode.fromAttributeValue(typeOrdinal);
            this.bootstrapBrand = DefaultBootstrapBrand.fromAttributeValue(brandOrdinal);
            this.bootstrapSize = DefaultBootstrapSize.fromAttributeValue(sizeOrdinal).scaleFactor();
        }
        finally {
            a.recycle();
        }
        this.updateBootstrapGroup();
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(TAG, super.onSaveInstanceState());
        bundle.putSerializable(KEY_MODE, (Serializable)((Object)this.buttonMode));
        bundle.putSerializable("BootstrapBrand", (Serializable)this.bootstrapBrand);
        bundle.putBoolean("com.beardedhen.androidbootstrap.api.view.Roundable", this.rounded);
        bundle.putBoolean("Outlineable", this.outline);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.outline = bundle.getBoolean("Outlineable");
            this.rounded = bundle.getBoolean("com.beardedhen.androidbootstrap.api.view.Roundable");
            Serializable brand = bundle.getSerializable("BootstrapBrand");
            Serializable m = bundle.getSerializable(KEY_MODE);
            if (m instanceof ButtonMode) {
                this.buttonMode = (ButtonMode)((Object)m);
            }
            if (brand instanceof BootstrapBrand) {
                this.bootstrapBrand = (BootstrapBrand)brand;
            }
            state = bundle.getParcelable(TAG);
        }
        super.onRestoreInstanceState(state);
        this.updateBootstrapGroup();
    }

    @Override
    protected void onBootstrapViewAdded() {
        this.updateBootstrapGroup();
    }

    @Override
    protected void onBootstrapViewRemoved() {
        this.updateBootstrapGroup();
    }

    @Override
    protected void updateBootstrapGroup() {
        int childCount = this.getChildCount();
        int orientation = this.getOrientation();
        if (childCount == 0) {
            return;
        }
        if (childCount == 1) {
            BootstrapButton button = this.retrieveButtonChild(0);
            button.setViewGroupPosition(ViewGroupPosition.SOLO, 0);
        }
        ArrayList<BootstrapButton> buttonList = new ArrayList<BootstrapButton>();
        for (int i = 0; i < childCount; ++i) {
            BootstrapButton button = this.retrieveButtonChild(i);
            if (button.getVisibility() != 0) continue;
            buttonList.add(button);
        }
        int size = buttonList.size();
        for (int i = 0; i < size; ++i) {
            BootstrapButton button = (BootstrapButton)buttonList.get(i);
            ViewGroupPosition position = i == 0 ? (orientation == 0 ? ViewGroupPosition.START : ViewGroupPosition.TOP) : (i == size - 1 ? (orientation == 0 ? ViewGroupPosition.END : ViewGroupPosition.BOTTOM) : (orientation == 0 ? ViewGroupPosition.MIDDLE_HORI : ViewGroupPosition.MIDDLE_VERT));
            button.setViewGroupPosition(position, i);
            button.updateFromParent(this.bootstrapBrand, this.bootstrapSize, this.buttonMode, this.outline, this.rounded);
            if (this.buttonMode == ButtonMode.RADIO && button.isMustBeSelected()) {
                button.setSelected(true);
                this.onRadioToggle(i);
                this.checkedButtonId = 0;
                continue;
            }
            if (this.buttonMode != ButtonMode.RADIO || button.getId() != this.checkedButtonId) continue;
            button.setSelected(true);
            this.onRadioToggle(i);
        }
    }

    private BootstrapButton retrieveButtonChild(int i) {
        View view = this.getChildAt(i);
        if (view instanceof BootstrapButton) {
            return (BootstrapButton)view;
        }
        throw new IllegalStateException("All child view of BootstrapButtonGroup must be BootstrapButtons");
    }

    void onRadioToggle(int index) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (i == index) continue;
            BootstrapButton b = this.retrieveButtonChild(i);
            b.setSelected(false);
        }
    }

    public void check(@IdRes int id) {
        this.checkedButtonId = id;
    }

    @Override
    public float getBootstrapSize() {
        return this.bootstrapSize;
    }

    @Override
    public void setBootstrapSize(DefaultBootstrapSize bootstrapSize) {
        this.setBootstrapSize(bootstrapSize.scaleFactor());
    }

    @Override
    public void setBootstrapSize(float bootstrapSize) {
        this.bootstrapSize = bootstrapSize;
        for (int i = 0; i < this.getChildCount(); ++i) {
            BootstrapButton button = this.retrieveButtonChild(i);
            button.setBootstrapSize(this.bootstrapSize);
        }
    }

    @Override
    @NonNull
    public ButtonMode getButtonMode() {
        return this.buttonMode;
    }

    @Override
    public void setButtonMode(@NonNull ButtonMode buttonMode) {
        this.buttonMode = buttonMode;
        for (int i = 0; i < this.getChildCount(); ++i) {
            BootstrapButton button = this.retrieveButtonChild(i);
            button.setButtonMode(buttonMode);
        }
    }

    @Override
    public void setBootstrapBrand(@NonNull BootstrapBrand bootstrapBrand) {
        this.bootstrapBrand = bootstrapBrand;
        for (int i = 0; i < this.getChildCount(); ++i) {
            BootstrapButton button = this.retrieveButtonChild(i);
            button.setBootstrapBrand(bootstrapBrand);
        }
    }

    @Override
    @NonNull
    public BootstrapBrand getBootstrapBrand() {
        return this.bootstrapBrand;
    }

    @Override
    public void setShowOutline(boolean showOutline) {
        this.outline = showOutline;
        for (int i = 0; i < this.getChildCount(); ++i) {
            BootstrapButton button = this.retrieveButtonChild(i);
            button.setShowOutline(this.outline);
        }
    }

    @Override
    public boolean isShowOutline() {
        return this.outline;
    }

    @Override
    public void setRounded(boolean rounded) {
        this.rounded = rounded;
        for (int i = 0; i < this.getChildCount(); ++i) {
            BootstrapButton button = this.retrieveButtonChild(i);
            button.setRounded(rounded);
        }
    }

    @Override
    public boolean isRounded() {
        return this.rounded;
    }
}

