/*
 * Decompiled with CFR 0.152.
 */
package com.beardedhen.androidbootstrap;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.beardedhen.androidbootstrap.R;
import com.beardedhen.androidbootstrap.api.attributes.BootstrapBrand;
import com.beardedhen.androidbootstrap.api.defaults.DefaultBootstrapSize;
import com.beardedhen.androidbootstrap.api.view.BootstrapBrandView;
import com.beardedhen.androidbootstrap.api.view.BootstrapSizeView;
import com.beardedhen.androidbootstrap.api.view.BorderView;
import com.beardedhen.androidbootstrap.utils.ColorUtils;
import com.beardedhen.androidbootstrap.utils.DimenUtils;
import java.io.Serializable;

abstract class BootstrapBaseThumbnail
extends ImageView
implements BootstrapBrandView,
BorderView,
BootstrapSizeView {
    private static final String TAG = "com.beardedhen.androidbootstrap.BootstrapBaseThumbnail";
    protected BootstrapBrand bootstrapBrand;
    protected boolean hasBorder;
    protected float baselineBorderWidth;
    protected float baselineOuterBorderWidth;
    protected float bootstrapSize;
    protected Bitmap sourceBitmap;
    protected final Paint placeholderPaint = new Paint();
    protected final Paint borderPaint = new Paint();
    protected final Paint imagePaint = new Paint();

    public BootstrapBaseThumbnail(Context context) {
        super(context);
        this.initialise(null);
    }

    public BootstrapBaseThumbnail(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialise(attrs);
    }

    public BootstrapBaseThumbnail(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialise(attrs);
    }

    protected void initialise(AttributeSet attrs) {
        this.baselineOuterBorderWidth = DimenUtils.pixelsFromDpResource(this.getContext(), R.dimen.bthumbnail_outer_stroke);
        this.baselineBorderWidth = DimenUtils.pixelsFromDpResource(this.getContext(), R.dimen.bthumbnail_default_border);
        this.setupPaints();
        this.updateImageState();
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(TAG, super.onSaveInstanceState());
        bundle.putSerializable("com.beardedhen.androidbootstrap.api.view.BootstrapBrandView", (Serializable)this.bootstrapBrand);
        bundle.putBoolean("com.beardedhen.androidbootstrap.api.view.KEY_DISPLAYED", this.hasBorder);
        bundle.putFloat("com.beardedhen.androidbootstrap.api.view.BootstrapSizeView", this.bootstrapSize);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.hasBorder = bundle.getBoolean("com.beardedhen.androidbootstrap.api.view.KEY_DISPLAYED");
            this.bootstrapSize = bundle.getFloat("com.beardedhen.androidbootstrap.api.view.BootstrapSizeView");
            Serializable brand = bundle.getSerializable("com.beardedhen.androidbootstrap.api.view.BootstrapBrandView");
            if (brand instanceof BootstrapBrand) {
                this.bootstrapBrand = (BootstrapBrand)brand;
            }
            state = bundle.getParcelable(TAG);
        }
        super.onRestoreInstanceState(state);
        this.updateImageState();
    }

    private void setupPaints() {
        int strokeColor = this.bootstrapBrand.defaultEdge(this.getContext());
        int placeholderColor = ColorUtils.resolveColor(R.color.bootstrap_gray_light, this.getContext());
        this.borderPaint.setColor(strokeColor);
        this.borderPaint.setAntiAlias(true);
        this.borderPaint.setStrokeWidth(this.baselineBorderWidth);
        this.borderPaint.setStyle(Paint.Style.STROKE);
        this.imagePaint.setAntiAlias(true);
        this.placeholderPaint.setColor(placeholderColor);
        this.placeholderPaint.setAntiAlias(true);
        this.placeholderPaint.setStyle(Paint.Style.FILL);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.updateImageState();
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        if (scaleType != ImageView.ScaleType.CENTER_CROP) {
            throw new IllegalArgumentException("Only CenterCrop is currently supported by this view");
        }
        super.setScaleType(scaleType);
    }

    public ImageView.ScaleType getScaleType() {
        return ImageView.ScaleType.CENTER_CROP;
    }

    @Nullable
    private Bitmap getBitmapForView() {
        Drawable drawable = this.getDrawable();
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        int w = drawable.getIntrinsicWidth();
        int h = drawable.getIntrinsicHeight();
        Bitmap bm = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        drawable.draw(new Canvas(bm));
        return bm;
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.sourceBitmap = bm;
        this.updateImageState();
    }

    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
        this.sourceBitmap = this.getBitmapForView();
        this.updateImageState();
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.sourceBitmap = this.getBitmapForView();
        this.updateImageState();
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.sourceBitmap = this.getBitmapForView();
        this.updateImageState();
    }

    protected abstract void updateImageState();

    @Override
    public void setBootstrapBrand(@NonNull BootstrapBrand bootstrapBrand) {
        this.bootstrapBrand = bootstrapBrand;
        this.updateImageState();
    }

    @Override
    @NonNull
    public BootstrapBrand getBootstrapBrand() {
        return this.bootstrapBrand;
    }

    @Override
    @TargetApi(value=16)
    public void setBorderDisplayed(boolean displayed) {
        this.hasBorder = displayed;
        this.updateImageState();
    }

    @Override
    public boolean isBorderDisplayed() {
        return this.hasBorder;
    }

    @Override
    public float getBootstrapSize() {
        return this.bootstrapSize;
    }

    @Override
    public void setBootstrapSize(float bootstrapSize) {
        this.bootstrapSize = bootstrapSize;
        this.updateImageState();
    }

    @Override
    public void setBootstrapSize(DefaultBootstrapSize bootstrapSize) {
        this.setBootstrapSize(bootstrapSize.scaleFactor());
    }
}

