/*
 * Decompiled with CFR 0.152.
 */
package com.beardedhen.androidbootstrap;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.widget.PopupWindowCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.ScrollView;
import android.widget.TextView;
import com.beardedhen.androidbootstrap.AwesomeTextView;
import com.beardedhen.androidbootstrap.BetaApi;
import com.beardedhen.androidbootstrap.BootstrapDrawableFactory;
import com.beardedhen.androidbootstrap.R;
import com.beardedhen.androidbootstrap.api.attributes.BootstrapBrand;
import com.beardedhen.androidbootstrap.api.attributes.ViewGroupPosition;
import com.beardedhen.androidbootstrap.api.defaults.DefaultBootstrapSize;
import com.beardedhen.androidbootstrap.api.defaults.ExpandDirection;
import com.beardedhen.androidbootstrap.api.view.OutlineableView;
import com.beardedhen.androidbootstrap.api.view.RoundableView;
import com.beardedhen.androidbootstrap.utils.ColorUtils;
import com.beardedhen.androidbootstrap.utils.DimenUtils;
import com.beardedhen.androidbootstrap.utils.DrawableUtils;
import com.beardedhen.androidbootstrap.utils.ViewUtils;
import java.io.Serializable;
import java.util.regex.Pattern;

@BetaApi
public class BootstrapDropDown
extends AwesomeTextView
implements View.OnClickListener,
RoundableView,
OutlineableView,
PopupWindow.OnDismissListener {
    private static final String TAG = "com.beardedhen.androidbootstrap.BootstrapDropDown";
    private static final String KEY_DIRECTION = "com.beardedhen.androidbootstrap.BootstrapDropDown.EXPAND_DIRECTION";
    private static final String SEARCH_REGEX_HEADER = "\\{dropdown_header\\}.*";
    private static final String SEARCH_REGEX_SEPARATOR = "\\{dropdown_separator\\}.*";
    private static final String SEARCH_REGEX_DISABLED = "\\{dropdown_disabled\\}.*";
    private static final String REPLACE_REGEX_HEADER = "\\{dropdown_header\\}";
    private static final String REPLACE_REGEX_SEPARATOR = "\\{dropdown_separator\\}";
    private static final String REPLACE_REGEX_DISABLED = "\\{dropdown_disabled\\}";
    private static final int SCREEN_WIDTH_GUESS = 1000;
    private ExpandDirection expandDirection;
    private PopupWindow dropdownWindow;
    private View.OnClickListener clickListener;
    private String[] dropdownData;
    private OnDropDownItemClickListener onDropDownItemClickListener;
    private boolean roundedCorners;
    private boolean showOutline;
    private float bootstrapSize;
    private int itemHeight;
    private int dropDownViewHeight;
    private int dropDownViewWidth;
    private int screenWidth;
    private float baselineStrokeWidth;
    private float baselineCornerRadius;
    private float baselineFontSize;
    private float baselineDropDownViewFontSize;
    private float baselineItemRightPadding;
    private float baselineItemLeftPadding;
    private float baselineVertPadding;
    private float baselineHoriPadding;

    public BootstrapDropDown(Context context) {
        super(context);
        this.initialise(null);
    }

    public BootstrapDropDown(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialise(attrs);
    }

    public BootstrapDropDown(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialise(attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialise(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.BootstrapDropDown);
        try {
            this.roundedCorners = a.getBoolean(R.styleable.BootstrapDropDown_roundedCorners, false);
            this.showOutline = a.getBoolean(R.styleable.BootstrapDropDown_showOutline, false);
            int directionOrdinal = a.getInt(R.styleable.BootstrapDropDown_bootstrapExpandDirection, -1);
            int dataOrdinal = a.getResourceId(R.styleable.BootstrapDropDown_dropdownResource, -1);
            int sizeOrdinal = a.getInt(R.styleable.BootstrapDropDown_bootstrapSize, -1);
            this.expandDirection = ExpandDirection.fromAttributeValue(directionOrdinal);
            this.bootstrapSize = DefaultBootstrapSize.fromAttributeValue(sizeOrdinal).scaleFactor();
            this.itemHeight = a.getDimensionPixelSize(R.styleable.BootstrapDropDown_itemHeight, (int)DimenUtils.pixelsFromDpResource(this.getContext(), R.dimen.bootstrap_dropdown_default_item_height));
            this.dropdownData = this.isInEditMode() ? new String[]{"Android Studio", "Layout Preview", "Is Always", "Breaking"} : this.getContext().getResources().getStringArray(dataOrdinal);
        }
        finally {
            a.recycle();
        }
        this.baselineStrokeWidth = DimenUtils.pixelsFromDpResource(this.getContext(), R.dimen.bootstrap_dropdown_default_edge_width);
        this.baselineCornerRadius = DimenUtils.pixelsFromDpResource(this.getContext(), R.dimen.bootstrap_dropdown_default_corner_radius);
        this.baselineFontSize = DimenUtils.pixelsFromSpResource(this.getContext(), R.dimen.bootstrap_dropdown_default_font_size);
        this.baselineDropDownViewFontSize = DimenUtils.pixelsFromSpResource(this.getContext(), R.dimen.bootstrap_dropdown_default_item_font_size);
        this.baselineItemLeftPadding = DimenUtils.pixelsFromDpResource(this.getContext(), R.dimen.bootstrap_dropdown_default_item_left_padding);
        this.baselineItemRightPadding = DimenUtils.pixelsFromDpResource(this.getContext(), R.dimen.bootstrap_dropdown_default_item_right_padding);
        this.baselineVertPadding = DimenUtils.pixelsFromDpResource(this.getContext(), R.dimen.bootstrap_button_default_vert_padding);
        this.baselineHoriPadding = DimenUtils.pixelsFromDpResource(this.getContext(), R.dimen.bootstrap_button_default_hori_padding);
        if (this.isInEditMode()) {
            this.screenWidth = 1000;
        } else {
            DisplayMetrics metrics = new DisplayMetrics();
            ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay().getMetrics(metrics);
            this.screenWidth = metrics.widthPixels;
        }
        this.createDropDown();
        this.updateDropDownState();
    }

    private void createDropDown() {
        ScrollView dropdownView = this.createDropDownView();
        this.dropdownWindow = new PopupWindow();
        this.dropdownWindow.setFocusable(true);
        this.dropdownWindow.setHeight(-2);
        if (!this.isInEditMode()) {
            this.dropdownWindow.setBackgroundDrawable(DrawableUtils.resolveDrawable(17301683, this.getContext()));
        }
        this.dropdownWindow.setContentView((View)dropdownView);
        this.dropdownWindow.setOnDismissListener((PopupWindow.OnDismissListener)this);
        this.dropdownWindow.setAnimationStyle(0x1030001);
        float longestStringWidth = this.measureStringWidth(this.getLongestString(this.dropdownData)) + (float)DimenUtils.dpToPixels((this.baselineItemRightPadding + this.baselineItemLeftPadding) * this.bootstrapSize);
        if (longestStringWidth < (float)this.getMeasuredWidth()) {
            this.dropdownWindow.setWidth(DimenUtils.dpToPixels(this.getMeasuredWidth()));
        } else {
            this.dropdownWindow.setWidth((int)longestStringWidth + DimenUtils.dpToPixels(8.0f));
        }
    }

    private ScrollView createDropDownView() {
        final LinearLayout dropdownView = new LinearLayout(this.getContext());
        ScrollView scrollView = new ScrollView(this.getContext());
        int clickableChildCounter = 0;
        dropdownView.setOrientation(1);
        int height = (int)((float)this.itemHeight * this.bootstrapSize);
        LinearLayout.LayoutParams childParams = new LinearLayout.LayoutParams(-1, height);
        for (String text : this.dropdownData) {
            TextView childView = new TextView(this.getContext());
            childView.setGravity(16);
            childView.setLayoutParams((ViewGroup.LayoutParams)childParams);
            int padding = (int)(this.baselineItemLeftPadding * this.bootstrapSize);
            childView.setPadding(padding, 0, padding, 0);
            childView.setTextSize(this.baselineDropDownViewFontSize * this.bootstrapSize);
            childView.setTextColor(ColorUtils.resolveColor(17170444, this.getContext()));
            Drawable background = this.getContext().obtainStyledAttributes(null, new int[]{16843534}, 0, 0).getDrawable(0);
            ViewUtils.setBackgroundDrawable((View)childView, background);
            childView.setTextColor(BootstrapDrawableFactory.bootstrapDropDownViewText(this.getContext()));
            childView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BootstrapDropDown.this.dropdownWindow.dismiss();
                    if (BootstrapDropDown.this.onDropDownItemClickListener != null) {
                        BootstrapDropDown.this.onDropDownItemClickListener.onItemClick((ViewGroup)dropdownView, v, v.getId());
                    }
                }
            });
            if (Pattern.matches(SEARCH_REGEX_HEADER, text)) {
                childView.setText((CharSequence)text.replaceFirst(REPLACE_REGEX_HEADER, ""));
                childView.setTextSize((this.baselineDropDownViewFontSize - 2.0f) * this.bootstrapSize);
                childView.setClickable(false);
                childView.setTextColor(ColorUtils.resolveColor(R.color.bootstrap_gray_light, this.getContext()));
            } else if (Pattern.matches(SEARCH_REGEX_SEPARATOR, text)) {
                childView = new DividerView(this.getContext());
                childView.setClickable(false);
                childView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 3));
            } else if (Pattern.matches(SEARCH_REGEX_DISABLED, text)) {
                childView.setEnabled(false);
                childView.setId(clickableChildCounter++);
                childView.setText((CharSequence)text.replaceFirst(REPLACE_REGEX_DISABLED, ""));
            } else {
                childView.setText((CharSequence)text);
                childView.setId(clickableChildCounter++);
            }
            dropdownView.addView((View)childView);
        }
        dropdownView.measure(0, 0);
        this.dropDownViewHeight = dropdownView.getMeasuredHeight();
        this.dropDownViewWidth = dropdownView.getMeasuredWidth();
        scrollView.setVerticalScrollBarEnabled(false);
        scrollView.setHorizontalScrollBarEnabled(false);
        scrollView.addView((View)dropdownView);
        this.cleanData();
        return scrollView;
    }

    private void updateDropDownState() {
        super.updateBootstrapState();
        BootstrapBrand bootstrapBrand = this.getBootstrapBrand();
        float cornerRadius = this.baselineCornerRadius;
        float strokeWidth = this.baselineStrokeWidth;
        float fontSize = this.baselineFontSize * this.bootstrapSize;
        strokeWidth *= this.bootstrapSize;
        super.setOnClickListener((View.OnClickListener)this);
        this.setTextSize(fontSize);
        this.setGravity(17);
        this.setCompoundDrawablesWithIntrinsicBounds(null, null, (Drawable)BootstrapDrawableFactory.bootstrapDropDownArrow(this.getContext(), DimenUtils.dpToPixels(8.0f * this.bootstrapSize), DimenUtils.dpToPixels(12.0f * this.bootstrapSize), this.expandDirection, this.showOutline, this.getBootstrapBrand()), null);
        this.setCompoundDrawablePadding(DimenUtils.dpToPixels(8.0f));
        this.setTextColor(BootstrapDrawableFactory.bootstrapButtonText(this.getContext(), this.showOutline, bootstrapBrand));
        Drawable bg = BootstrapDrawableFactory.bootstrapButton(this.getContext(), bootstrapBrand, (int)strokeWidth, (int)cornerRadius, ViewGroupPosition.SOLO, this.showOutline, this.roundedCorners);
        ViewUtils.setBackgroundDrawable((View)this, bg);
        int vert = (int)(this.baselineVertPadding * this.bootstrapSize);
        int hori = (int)(this.baselineHoriPadding * this.bootstrapSize);
        this.setPadding(hori, vert, hori, vert);
    }

    private float measureStringWidth(String text) {
        Paint mPaint = new Paint();
        mPaint.setTextSize(this.baselineDropDownViewFontSize * this.bootstrapSize);
        return DimenUtils.dpToPixels(mPaint.measureText(text));
    }

    private String getLongestString(String[] array) {
        int maxLength = 0;
        String longestString = null;
        for (String s : array) {
            if (s.length() <= maxLength) continue;
            maxLength = s.length();
            longestString = s;
        }
        return longestString;
    }

    private void cleanData() {
        String[] cleanArray = new String[this.dropdownData.length];
        for (int i = 0; i < this.dropdownData.length; ++i) {
            cleanArray[i] = this.dropdownData[i].replaceAll(REPLACE_REGEX_HEADER, "").replaceAll(REPLACE_REGEX_DISABLED, "").replaceAll(REPLACE_REGEX_SEPARATOR, "");
        }
        this.dropdownData = cleanArray;
    }

    public void setOnDropDownItemClickListener(OnDropDownItemClickListener onDropDownItemClickListener) {
        this.onDropDownItemClickListener = onDropDownItemClickListener;
    }

    @Override
    public boolean isShowOutline() {
        return this.showOutline;
    }

    @Override
    public boolean isRounded() {
        return this.roundedCorners;
    }

    public ExpandDirection getExpandDirection() {
        return this.expandDirection;
    }

    public String[] getDropdownData() {
        return this.dropdownData;
    }

    @Override
    public void setShowOutline(boolean showOutline) {
        this.showOutline = showOutline;
        this.updateDropDownState();
    }

    @Override
    public void setRounded(boolean rounded) {
        this.roundedCorners = rounded;
        this.updateDropDownState();
    }

    public void setExpandDirection(ExpandDirection expandDirection) {
        this.expandDirection = expandDirection;
        this.updateDropDownState();
    }

    public void setDropdownData(String[] dropdownData) {
        this.dropdownData = dropdownData;
        this.createDropDown();
        this.updateDropDownState();
    }

    public void onDismiss() {
        this.setSelected(false);
        this.dropdownWindow.getContentView().scrollTo(0, 0);
    }

    public void onClick(View v) {
        int axisXOffset;
        int gravity;
        if (this.clickListener != null) {
            this.clickListener.onClick(v);
        }
        if ((float)this.dropDownViewWidth + this.getX() > (float)this.screenWidth) {
            gravity = 8388661;
            axisXOffset = DimenUtils.dpToPixels(8.0f);
        } else {
            gravity = 0x800033;
            axisXOffset = -DimenUtils.dpToPixels(8.0f);
        }
        int axisYOffset = DimenUtils.dpToPixels(4.0f);
        switch (this.expandDirection) {
            case UP: {
                PopupWindowCompat.showAsDropDown((PopupWindow)this.dropdownWindow, (View)v, (int)axisXOffset, (int)(-this.dropDownViewHeight - this.getMeasuredHeight() - axisYOffset * 3), (int)gravity);
                break;
            }
            case DOWN: {
                PopupWindowCompat.showAsDropDown((PopupWindow)this.dropdownWindow, (View)v, (int)axisXOffset, (int)(-axisYOffset), (int)gravity);
            }
        }
        this.setSelected(true);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(TAG, super.onSaveInstanceState());
        bundle.putBoolean("com.beardedhen.androidbootstrap.api.view.Roundable", this.roundedCorners);
        bundle.putBoolean("Outlineable", this.showOutline);
        bundle.putSerializable(KEY_DIRECTION, (Serializable)((Object)this.expandDirection));
        bundle.putFloat("com.beardedhen.androidbootstrap.api.view.BootstrapSizeView", this.bootstrapSize);
        return bundle;
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.roundedCorners = bundle.getBoolean("com.beardedhen.androidbootstrap.api.view.Roundable");
            this.showOutline = bundle.getBoolean("Outlineable");
            this.bootstrapSize = bundle.getFloat("com.beardedhen.androidbootstrap.api.view.BootstrapSizeView");
            Serializable direction = bundle.getSerializable(KEY_DIRECTION);
            if (direction instanceof ExpandDirection) {
                this.expandDirection = (ExpandDirection)((Object)direction);
            }
        }
        super.onRestoreInstanceState(state);
    }

    public void setOnClickListener(View.OnClickListener clickListener) {
        this.clickListener = clickListener;
    }

    private static class DividerView
    extends TextView {
        private final Paint paint = new Paint();

        public DividerView(Context context) {
            super(context);
            this.paint.setColor(ColorUtils.resolveColor(R.color.bootstrap_dropdown_divider, context));
        }

        protected void onDraw(Canvas canvas) {
            canvas.drawLine(0.0f, 1.0f, (float)canvas.getWidth(), 1.0f, this.paint);
            super.onDraw(canvas);
        }
    }

    public static interface OnDropDownItemClickListener {
        public void onItemClick(ViewGroup var1, View var2, int var3);
    }
}

