/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.app.job.JobService;
import android.util.Log;
import com.beaconsinspace.android.beacon.detector.BISCollectionManager;
import com.beaconsinspace.android.beacon.detector.BISDetector;
import com.beaconsinspace.android.beacon.detector.BISDetectorBootstrapListener;
import com.beaconsinspace.android.beacon.detector.BISLog;
import java.util.Timer;
import java.util.TimerTask;

@TargetApi(value=26)
public class BISJobService
extends JobService {
    private Timer timer;
    private TimerTask timerTask;
    private static final String TAG = "BISJobService";
    private static BISDetector detectorInstance;

    public boolean onStartJob(JobParameters jobParameters) {
        try {
            BISCollectionManager collectionManager;
            if (detectorInstance != null && (collectionManager = detectorInstance.getCollectionManager()) != null) {
                collectionManager.stopLocationGathering();
            }
            detectorInstance = new BISDetector(this.getApplicationContext());
            BISJobService.detectorInstance.contextDescription = TAG;
            detectorInstance.bootstrap(new BISDetectorBootstrapListener(){

                @Override
                public void onBootstrapSuccess(BISDetector detector) {
                    BISCollectionManager collectionManager = detector.getCollectionManager();
                    if (collectionManager != null) {
                        collectionManager.startLocationGathering();
                    }
                }

                @Override
                public void onBootstrapFailure() {
                    Log.d((String)BISJobService.TAG, (String)"Bootstrap failed.");
                }
            });
            return false;
        }
        catch (Throwable t) {
            BISLog.e(TAG, t.getMessage());
            return false;
        }
    }

    public boolean onStopJob(JobParameters jobParameters) {
        try {
            if (detectorInstance != null) {
                BISCollectionManager collectionManager = detectorInstance.getCollectionManager();
                if (collectionManager != null) {
                    collectionManager.stopLocationGathering();
                }
                detectorInstance = null;
            }
        }
        catch (Throwable t) {
            BISLog.e(TAG, t.getMessage());
        }
        return false;
    }
}

