/*
 * Decompiled with CFR 0.152.
 */
package com.beaconsinspace.android.beacon.detector.deviceatlas;

import android.annotation.TargetApi;
import android.hardware.Camera;
import com.beaconsinspace.android.beacon.detector.deviceatlas.Camera;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=9)
class CameraV1 {
    private static final String TAG = CameraV1.class.getName();

    CameraV1() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Camera> getCameras() {
        ArrayList<Camera> toReturn = new ArrayList<Camera>();
        int numCams = android.hardware.Camera.getNumberOfCameras();
        for (int id = 0; id < numCams; ++id) {
            android.hardware.Camera camera = null;
            try {
                camera = android.hardware.Camera.open((int)id);
                Camera.Parameters params = camera.getParameters();
                List sizes = params.getSupportedPictureSizes();
                Camera.Size maxSize = null;
                for (int i = 0; i < sizes.size(); ++i) {
                    Camera.Size s = (Camera.Size)sizes.get(i);
                    if (maxSize != null && s.width <= maxSize.width) continue;
                    maxSize = s;
                }
                if (maxSize == null) continue;
                toReturn.add(new Camera(maxSize.width, maxSize.height, CameraV1.getFacing(id), CameraV1.hasFlash(params)));
                continue;
            }
            catch (RuntimeException runtimeException) {
                continue;
            }
            finally {
                if (camera != null) {
                    camera.release();
                }
            }
        }
        return toReturn;
    }

    public static boolean hasFlash(Camera.Parameters params) {
        List supportedFlashModes = params.getSupportedFlashModes();
        return supportedFlashModes != null && !supportedFlashModes.isEmpty() && (supportedFlashModes.size() != 1 || !((String)supportedFlashModes.get(0)).equals("off"));
    }

    private static String getFacing(int cameraId) {
        String facing;
        Camera.CameraInfo info = new Camera.CameraInfo();
        android.hardware.Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
        switch (info.facing) {
            case 1: {
                facing = "front";
                break;
            }
            case 0: {
                facing = "back";
                break;
            }
            default: {
                facing = "id=" + info.facing;
            }
        }
        return facing;
    }
}

